/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.core.text.plugin.PluginImportNode;
import org.eclipse.pde.internal.core.text.plugin.PluginLibraryNode;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;

public abstract class PluginBaseNode
extends PluginObjectNode
implements IPluginBase {
    private static final long serialVersionUID = 1L;
    private String fSchemaVersion;

    @Override
    public void add(IPluginLibrary library) throws CoreException {
        IDocumentElementNode parent = this.getEnclosingElement("runtime", true);
        if (library instanceof PluginLibraryNode) {
            PluginLibraryNode node = (PluginLibraryNode)library;
            node.setModel(this.getModel());
            parent.addChildNode(node);
            this.fireStructureChanged(library, 1);
        }
    }

    @Override
    public void add(IPluginImport pluginImport) throws CoreException {
        IDocumentElementNode parent = this.getEnclosingElement("requires", true);
        if (pluginImport instanceof PluginImportNode) {
            PluginImportNode node = (PluginImportNode)pluginImport;
            parent.addChildNode(node);
            this.fireStructureChanged(pluginImport, 1);
        }
    }

    public void add(IPluginImport[] pluginImports) {
        IDocumentElementNode parent = this.getEnclosingElement("requires", true);
        IPluginImport[] iPluginImportArray = pluginImports;
        int n = pluginImports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pluginImport = iPluginImportArray[n2];
            if (pluginImport != null && pluginImport instanceof PluginImportNode) {
                PluginImportNode node = (PluginImportNode)pluginImport;
                parent.addChildNode(node);
            }
            ++n2;
        }
        this.fireStructureChanged(pluginImports, 1);
    }

    @Override
    public void remove(IPluginImport pluginImport) throws CoreException {
        IDocumentElementNode parent = this.getEnclosingElement("requires", false);
        if (parent != null) {
            parent.removeChildNode((IDocumentElementNode)((Object)pluginImport));
            pluginImport.setInTheModel(false);
            this.fireStructureChanged(pluginImport, 2);
        }
    }

    public void remove(IPluginImport[] pluginImports) {
        IDocumentElementNode parent = this.getEnclosingElement("requires", false);
        if (parent != null) {
            IPluginImport[] iPluginImportArray = pluginImports;
            int n = pluginImports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pluginImport = iPluginImportArray[n2];
                parent.removeChildNode((IDocumentElementNode)((Object)pluginImport));
                pluginImport.setInTheModel(false);
                ++n2;
            }
            this.fireStructureChanged(pluginImports, 2);
        }
    }

    @Override
    public IPluginLibrary[] getLibraries() {
        ArrayList<IDocumentElementNode> result = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode requiresNode = this.getEnclosingElement("runtime", false);
        if (requiresNode != null) {
            IDocumentElementNode[] children;
            IDocumentElementNode[] iDocumentElementNodeArray = children = requiresNode.getChildNodes();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
                if (childNode instanceof IPluginLibrary) {
                    result.add(childNode);
                }
                ++n2;
            }
        }
        return result.toArray(new IPluginLibrary[result.size()]);
    }

    private IDocumentElementNode getEnclosingElement(String elementName, boolean create) {
        IDocumentElementNode[] children;
        PluginElementNode element = null;
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            if (childNode instanceof IPluginElement && ((PluginElementNode)childNode).getXMLTagName().equals(elementName)) {
                element = (PluginElementNode)childNode;
                break;
            }
            ++n2;
        }
        if (element == null && create) {
            element = new PluginElementNode();
            element.setXMLTagName(elementName);
            element.setParentNode(this);
            element.setModel(this.getModel());
            element.setInTheModel(true);
            if (elementName.equals("runtime")) {
                this.addChildNode(element, 0);
            } else if (elementName.equals("requires")) {
                if (children.length > 0 && children[0].getXMLTagName().equals("runtime")) {
                    this.addChildNode(element, 1);
                } else {
                    this.addChildNode(element, 0);
                }
            }
        }
        return element;
    }

    @Override
    public IPluginImport[] getImports() {
        ArrayList<IDocumentElementNode> result = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode requiresNode = this.getEnclosingElement("requires", false);
        if (requiresNode != null) {
            IDocumentElementNode[] children;
            IDocumentElementNode[] iDocumentElementNodeArray = children = requiresNode.getChildNodes();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
                if (childNode instanceof IPluginImport) {
                    result.add(childNode);
                }
                ++n2;
            }
        }
        return result.toArray(new IPluginImport[result.size()]);
    }

    @Override
    public String getProviderName() {
        return this.getXMLAttributeValue("provider-name");
    }

    @Override
    public String getVersion() {
        return this.getXMLAttributeValue("version");
    }

    @Override
    public void remove(IPluginLibrary library) throws CoreException {
        IDocumentElementNode parent = this.getEnclosingElement("runtime", false);
        if (parent != null) {
            parent.removeChildNode((IDocumentElementNode)((Object)library));
            library.setInTheModel(false);
            this.fireStructureChanged(library, 2);
        }
    }

    @Override
    public void setProviderName(String providerName) throws CoreException {
        this.setXMLAttribute("provider-name", providerName);
    }

    @Override
    public void setVersion(String version) throws CoreException {
        this.setXMLAttribute("version", version);
    }

    @Override
    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        IDocumentElementNode node = this.getEnclosingElement("runtime", false);
        if (node != null) {
            node.swap((IDocumentElementNode)((Object)l1), (IDocumentElementNode)((Object)l2));
            this.firePropertyChanged(node, "library_order", l1, l2);
        }
    }

    @Override
    public String getSchemaVersion() {
        return this.fSchemaVersion;
    }

    @Override
    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.fSchemaVersion = schemaVersion;
    }

    @Override
    public void add(IPluginExtension extension) throws CoreException {
        if (extension instanceof PluginExtensionNode) {
            PluginExtensionNode node = (PluginExtensionNode)extension;
            node.setModel(this.getModel());
            this.addChildNode(node);
            this.fireStructureChanged(extension, 1);
        }
    }

    public void add(IPluginExtension extension, int position) {
        if (!(extension instanceof PluginExtensionNode)) {
            return;
        }
        if (position < 0 || position > this.getChildCount()) {
            return;
        }
        PluginExtensionNode node = (PluginExtensionNode)extension;
        node.setModel(this.getModel());
        this.addChildNode(node, position);
        this.fireStructureChanged(extension, 1);
    }

    @Override
    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        if (extensionPoint instanceof PluginExtensionPointNode) {
            PluginExtensionPointNode node = (PluginExtensionPointNode)extensionPoint;
            node.setModel(this.getModel());
            extensionPoint.setInTheModel(true);
            node.setParentNode(this);
            IPluginExtensionPoint[] extPoints = this.getExtensionPoints();
            if (extPoints.length > 0) {
                this.addChildNode(node, this.indexOf((IDocumentElementNode)((Object)extPoints[extPoints.length - 1])) + 1);
            } else {
                IDocumentElementNode requires = this.getEnclosingElement("requires", false);
                if (requires != null) {
                    this.addChildNode(node, this.indexOf(requires) + 1);
                } else {
                    IDocumentElementNode runtime = this.getEnclosingElement("runtime", false);
                    if (runtime != null) {
                        this.addChildNode(node, this.indexOf(runtime) + 1);
                    } else {
                        this.addChildNode(node, 0);
                    }
                }
            }
            this.fireStructureChanged(extensionPoint, 1);
        }
    }

    @Override
    public IPluginExtensionPoint[] getExtensionPoints() {
        IDocumentElementNode[] children;
        ArrayList<IDocumentElementNode> result = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            if (childNode instanceof IPluginExtensionPoint) {
                result.add(childNode);
            }
            ++n2;
        }
        return result.toArray(new IPluginExtensionPoint[result.size()]);
    }

    @Override
    public IPluginExtension[] getExtensions() {
        IDocumentElementNode[] children;
        ArrayList<IDocumentElementNode> result = new ArrayList<IDocumentElementNode>();
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            if (childNode instanceof IPluginExtension) {
                result.add(childNode);
            }
            ++n2;
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    @Override
    public int getIndexOf(IPluginExtension e) {
        IPluginExtension[] children = this.getExtensions();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void remove(IPluginExtension extension) throws CoreException {
        if (extension instanceof IDocumentElementNode) {
            this.removeChildNode((IDocumentElementNode)((Object)extension));
            extension.setInTheModel(false);
            this.fireStructureChanged(extension, 2);
        }
    }

    @Override
    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        if (extensionPoint instanceof IDocumentElementNode) {
            this.removeChildNode((IDocumentElementNode)((Object)extensionPoint));
            extensionPoint.setInTheModel(false);
            this.fireStructureChanged(extensionPoint, 2);
        }
    }

    public void remove(IPluginObject node) {
        if (node instanceof IDocumentElementNode) {
            this.removeChildNode((IDocumentElementNode)((Object)node));
            node.setInTheModel(false);
            this.fireStructureChanged(node, 2);
        }
    }

    @Override
    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.swap((IDocumentElementNode)((Object)e1), (IDocumentElementNode)((Object)e2));
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    @Override
    public void swap(IPluginImport import1, IPluginImport import2) throws CoreException {
        IDocumentElementNode node = this.getEnclosingElement("requires", false);
        if (node != null) {
            node.swap((IDocumentElementNode)((Object)import1), (IDocumentElementNode)((Object)import2));
            this.firePropertyChanged(node, "import_order", import1, import2);
        }
    }

    @Override
    public String getId() {
        return this.getXMLAttributeValue("id");
    }

    @Override
    public void setId(String id) throws CoreException {
        this.setXMLAttribute("id", id);
    }

    @Override
    public String getName() {
        return this.getXMLAttributeValue("name");
    }

    @Override
    public void setName(String name) throws CoreException {
        this.setXMLAttribute("name", name);
    }

    @Override
    public String write(boolean indent) {
        IPluginExtension[] extensions;
        IPluginExtensionPoint[] extPoints;
        IDocumentElementNode requires;
        String newLine = this.getLineDelimiter();
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newLine);
        buffer.append("<?eclipse version=\"3.0\"?>" + newLine);
        buffer.append(this.writeShallow(false) + newLine);
        IDocumentElementNode runtime = this.getEnclosingElement("runtime", false);
        if (runtime != null) {
            runtime.setLineIndent(this.getLineIndent() + 3);
            buffer.append(runtime.write(true) + newLine);
        }
        if ((requires = this.getEnclosingElement("requires", false)) != null) {
            requires.setLineIndent(this.getLineIndent() + 3);
            buffer.append(requires.write(true) + newLine);
        }
        IPluginExtensionPoint[] iPluginExtensionPointArray = extPoints = this.getExtensionPoints();
        int n = extPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extPoint = iPluginExtensionPointArray[n2];
            IDocumentElementNode extPointNode = (IDocumentElementNode)((Object)extPoint);
            extPointNode.setLineIndent(this.getLineIndent() + 3);
            buffer.append(extPointNode.write(true) + newLine);
            ++n2;
        }
        IPluginExtension[] iPluginExtensionArray = extensions = this.getExtensions();
        int n3 = extensions.length;
        n = 0;
        while (n < n3) {
            IPluginExtension extension = iPluginExtensionArray[n];
            IDocumentElementNode extensionNode = (IDocumentElementNode)((Object)extension);
            extensionNode.setLineIndent(this.getLineIndent() + 3);
            buffer.append(extensionNode.write(true) + newLine);
            ++n;
        }
        buffer.append("</" + this.getXMLTagName() + ">");
        return buffer.toString();
    }

    @Override
    public String writeShallow(boolean terminate) {
        String[] specific;
        String provider;
        String version;
        String name;
        String newLine = System.lineSeparator();
        StringBuilder buffer = new StringBuilder();
        buffer.append("<" + this.getXMLTagName());
        buffer.append(newLine);
        String id = this.getId();
        if (id != null && id.trim().length() > 0) {
            buffer.append("   id=\"" + this.getWritableString(id) + "\"" + newLine);
        }
        if ((name = this.getName()) != null && name.trim().length() > 0) {
            buffer.append("   name=\"" + this.getWritableString(name) + "\"" + newLine);
        }
        if ((version = this.getVersion()) != null && version.trim().length() > 0) {
            buffer.append("   version=\"" + this.getWritableString(version) + "\"" + newLine);
        }
        if ((provider = this.getProviderName()) != null && provider.trim().length() > 0) {
            buffer.append("   provider-name=\"" + this.getWritableString(provider) + "\"");
        }
        String[] stringArray = specific = this.getSpecificAttributes();
        int n = specific.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            buffer.append(newLine + element);
            ++n2;
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    protected abstract String[] getSpecificAttributes();

    @Override
    public boolean isRoot() {
        return true;
    }
}

