/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.util.HashtableOfLong;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.Util;

public class MatchingNodeSet {
    Map<ASTNode, Integer> matchingNodes = new HashMap<ASTNode, Integer>();
    private final HashtableOfLong matchingNodesKeys = new HashtableOfLong(3);
    static Integer EXACT_MATCH = 0;
    static Integer POTENTIAL_MATCH = 1;
    static Integer ERASURE_MATCH = 16;
    public boolean mustResolve;
    SimpleSet possibleMatchingNodesSet = new SimpleSet(7);
    private final HashtableOfLong possibleMatchingNodesKeys = new HashtableOfLong(7);

    public MatchingNodeSet(boolean mustResolvePattern) {
        this.mustResolve = mustResolvePattern;
    }

    public int addMatch(ASTNode node, int matchLevel) {
        int maskedLevel = matchLevel & 0xF;
        switch (maskedLevel) {
            case 1: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 1 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, POTENTIAL_MATCH);
                break;
            }
            case 2: {
                this.addPossibleMatch(node);
                break;
            }
            case 4: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 16 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, ERASURE_MATCH);
                break;
            }
            case 3: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 0 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, EXACT_MATCH);
            }
        }
        return matchLevel;
    }

    public void addPossibleMatch(ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        ASTNode existing = (ASTNode)this.possibleMatchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.possibleMatchingNodesSet.remove((Object)existing);
        }
        this.possibleMatchingNodesSet.add((Object)node);
        this.possibleMatchingNodesKeys.put(key, (Object)node);
    }

    public void addTrustedMatch(ASTNode node, boolean isExact) {
        this.addTrustedMatch(node, isExact ? EXACT_MATCH : POTENTIAL_MATCH);
    }

    void addTrustedMatch(ASTNode node, Integer level) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        ASTNode existing = (ASTNode)this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.remove(existing);
        }
        this.matchingNodes.put(node, level);
        this.matchingNodesKeys.put(key, (Object)node);
    }

    protected boolean hasPossibleNodes(int start, int end) {
        Object[] nodes;
        Object[] objectArray = nodes = this.possibleMatchingNodesSet.values;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object n3 = objectArray[n2];
            ASTNode node = (ASTNode)n3;
            if (node != null && start <= node.sourceStart && node.sourceEnd <= end) {
                return true;
            }
            ++n2;
        }
        for (ASTNode node : this.matchingNodes.keySet()) {
            if (node == null || start > node.sourceStart || node.sourceEnd > end) continue;
            return true;
        }
        return false;
    }

    protected ASTNode[] matchingNodes(int start, int end) {
        ArrayList<ASTNode> nodes = null;
        for (ASTNode node : this.matchingNodes.keySet()) {
            if (node == null || start > node.sourceStart || node.sourceEnd > end) continue;
            if (nodes == null) {
                nodes = new ArrayList<ASTNode>();
            }
            nodes.add(node);
        }
        if (nodes == null) {
            return null;
        }
        Object[] result = (ASTNode[])nodes.toArray(ASTNode[]::new);
        Util.Comparer comparer = new Util.Comparer(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((ASTNode)o1).sourceStart - ((ASTNode)o2).sourceStart;
            }
        };
        Util.sort(result, comparer);
        return result;
    }

    public Object removePossibleMatch(ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        ASTNode existing = (ASTNode)this.possibleMatchingNodesKeys.get(key);
        if (existing == null) {
            return null;
        }
        this.possibleMatchingNodesKeys.put(key, null);
        return this.possibleMatchingNodesSet.remove((Object)node);
    }

    public Object removeTrustedMatch(ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        ASTNode existing = (ASTNode)this.matchingNodesKeys.get(key);
        if (existing == null) {
            return null;
        }
        this.matchingNodesKeys.put(key, null);
        return this.matchingNodes.remove(node);
    }

    public String toString() {
        Object[] nodes;
        StringBuilder result = new StringBuilder();
        result.append("Exact matches:");
        for (Map.Entry<ASTNode, Integer> entry : this.matchingNodes.entrySet()) {
            ASTNode node = entry.getKey();
            if (node == null) continue;
            result.append("\n\t");
            switch (entry.getValue()) {
                case 0: {
                    result.append("ACCURATE_MATCH: ");
                    break;
                }
                case 1: {
                    result.append("INACCURATE_MATCH: ");
                    break;
                }
                case 16: {
                    result.append("ERASURE_MATCH: ");
                }
            }
            node.print(0, result);
        }
        result.append("\nPossible matches:");
        Object[] objectArray = nodes = this.possibleMatchingNodesSet.values;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object n3 = objectArray[n2];
            ASTNode node = (ASTNode)n3;
            if (node != null) {
                result.append("\nPOSSIBLE_MATCH: ");
                node.print(0, result);
            }
            ++n2;
        }
        return result.toString();
    }
}

