/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.ecl.parser.IEclParserErrorReporter;

public class EclParserErrorCollector
implements IEclParserErrorReporter {
    private List<EclError> errors = new ArrayList<EclError>();

    public EclError[] getErrors() {
        return this.errors.toArray(new EclError[this.errors.size()]);
    }

    @Override
    public void reportError(String hdr, String msg) {
        this.errors.add(new EclError(hdr, msg));
    }

    public static class EclError {
        private String header;
        private String message;
        private int start = -1;
        private int end = -1;

        public String getHeader() {
            return this.header;
        }

        public String getMessage() {
            return this.message;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public EclError(String hdr, String msg) {
            this.header = hdr;
            this.message = msg;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EclError other = (EclError)obj;
            if (this.end != other.end) {
                return false;
            }
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            return this.start == other.start;
        }
    }
}

