/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.edit.ui.provider.ImageDataSynthesizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class URLImageDescriptor
extends ImageDescriptor {
    protected URL url;
    protected String key1;
    protected String key2;

    URLImageDescriptor(URL url, String key1, String key2) {
        this.url = url;
        this.key1 = key1;
        this.key2 = key2;
    }

    public ImageData getImageData() {
        InputStream in = null;
        try {
            if (this.key1 != null) {
                ImageDataSynthesizer imageDataSynthesizer = new ImageDataSynthesizer(this.url);
                in = imageDataSynthesizer.generateGIF(this.key1, this.key2);
                ImageData imageData = new ImageData(in);
                return imageData;
            }
            in = this.url.openStream();
            ImageData imageData = new ImageData(in);
            return imageData;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
    }

    protected InputStream getStream() throws IOException {
        return this.url.openStream();
    }

    public int hashCode() {
        return this.url.hashCode() | (this.key1 == null ? 0 : this.key1.hashCode()) | (this.key2 == null ? 0 : this.key2.hashCode());
    }

    public boolean equals(Object that) {
        if (that instanceof URLImageDescriptor) {
            URLImageDescriptor otherURLImageDescriptor = (URLImageDescriptor)((Object)that);
            return this.url.equals(otherURLImageDescriptor.url) && (this.key1 == null ? otherURLImageDescriptor.key1 == null : this.key1.equals(otherURLImageDescriptor.key1)) && (this.key2 == null ? otherURLImageDescriptor.key2 == null : this.key2.equals(otherURLImageDescriptor.key2));
        }
        return false;
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        return new Image(device, this.getImageData());
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "(" + this.url + "#" + this.key1 + "/" + this.key2 + ")";
    }
}

