/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.logicalstructures;

import com.sun.jdi.VMDisconnectedException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate3;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIPlaceholderVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaStructureErrorValue;
import org.eclipse.jdt.internal.debug.core.logicalstructures.LogicalObjectStructureValue;
import org.eclipse.jdt.internal.debug.core.logicalstructures.LogicalStructuresMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JavaLogicalStructure
implements ILogicalStructureType,
ILogicalStructureTypeDelegate3 {
    private static IStatusHandler fgStackFrameProvider;
    private String fType;
    private boolean fSubtypes;
    private String fValue;
    private String fDescription;
    private String[][] fVariables;
    private String fContributingPluginId = null;

    public JavaLogicalStructure(String type, boolean subtypes, String value, String description, String[][] variables) {
        this.fType = type;
        this.fSubtypes = subtypes;
        this.fValue = value;
        this.fDescription = description;
        this.fVariables = variables;
    }

    public JavaLogicalStructure(IConfigurationElement configurationElement) throws CoreException {
        this.fType = configurationElement.getAttribute("type");
        if (this.fType == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.JavaLogicalStructures_0, null));
        }
        this.fSubtypes = Boolean.parseBoolean(configurationElement.getAttribute("subtypes"));
        this.fValue = configurationElement.getAttribute("value");
        this.fDescription = configurationElement.getAttribute("description");
        if (this.fDescription == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.JavaLogicalStructures_4, null));
        }
        IConfigurationElement[] variableElements = configurationElement.getChildren("variable");
        if (this.fValue == null && variableElements.length == 0) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.JavaLogicalStructures_1, null));
        }
        this.fVariables = new String[variableElements.length][2];
        int j = 0;
        while (j < this.fVariables.length) {
            String variableName = variableElements[j].getAttribute("name");
            if (variableName == null) {
                throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.JavaLogicalStructures_2, null));
            }
            this.fVariables[j][0] = variableName;
            String variableValue = variableElements[j].getAttribute("value");
            if (variableValue == null) {
                throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.JavaLogicalStructures_3, null));
            }
            this.fVariables[j][1] = variableValue;
            ++j;
        }
        this.fContributingPluginId = configurationElement.getContributor().getName();
    }

    public boolean providesLogicalStructure(IValue value) {
        if (!(value instanceof IJavaObject)) {
            return false;
        }
        return this.getType((IJavaObject)value) != null;
    }

    public IValue getLogicalStructure(IValue value) throws CoreException {
        if (!(value instanceof IJavaObject)) {
            return value;
        }
        IJavaObject javaValue = (IJavaObject)value;
        try {
            IJavaReferenceType type = this.getType(javaValue);
            if (type == null) {
                return value;
            }
            IJavaStackFrame stackFrame = this.getStackFrame(javaValue);
            if (stackFrame == null) {
                return value;
            }
            IJavaProject project = JavaDebugUtils.resolveJavaProject(stackFrame);
            if (project == null) {
                return value;
            }
            IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)stackFrame.getDebugTarget());
            EvaluationBlock evaluationBlock = new EvaluationBlock(javaValue, type, (IJavaThread)stackFrame.getThread(), evaluationEngine);
            if (this.fValue == null) {
                JDIPlaceholderVariable[] variables = new JDIPlaceholderVariable[this.fVariables.length];
                int i = 0;
                while (i < this.fVariables.length) {
                    variables[i] = new JDIPlaceholderVariable(this.fVariables[i][0], evaluationBlock.evaluate(this.fVariables[i][1]), javaValue);
                    ++i;
                }
                return new LogicalObjectStructureValue(javaValue, variables);
            }
            IJavaValue logicalValue = evaluationBlock.evaluate(this.fValue);
            if (logicalValue instanceof JDIValue) {
                ((JDIValue)logicalValue).setLogicalParent(javaValue);
            }
            return logicalValue;
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 100) {
                throw e;
            }
            JDIDebugPlugin.log(e);
            return value;
        }
    }

    public void releaseValue(IValue value) {
        block3: {
            if (value instanceof IJavaObject) {
                try {
                    ((IJavaObject)value).enableCollection();
                }
                catch (DebugException e) {
                    if (e.getStatus().getException() instanceof VMDisconnectedException) break block3;
                    JDIDebugPlugin.log(e);
                }
            }
        }
    }

    private IJavaReferenceType getType(IJavaObject value) {
        IJavaClassType classType;
        block10: {
            IJavaType type;
            block9: {
                type = value.getJavaType();
                if (type instanceof IJavaClassType) break block9;
                return null;
            }
            classType = (IJavaClassType)type;
            if (classType.getName().equals(this.fType)) {
                return classType;
            }
            if (this.fSubtypes) break block10;
            return null;
        }
        try {
            IJavaInterfaceType[] superInterfaces;
            IJavaClassType superClass = classType.getSuperclass();
            while (superClass != null) {
                if (superClass.getName().equals(this.fType)) {
                    return superClass;
                }
                superClass = superClass.getSuperclass();
            }
            IJavaInterfaceType[] iJavaInterfaceTypeArray = superInterfaces = classType.getAllInterfaces();
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaInterfaceType superInterface = iJavaInterfaceTypeArray[n2];
                if (superInterface.getName().equals(this.fType)) {
                    return superInterface;
                }
                ++n2;
            }
        }
        catch (DebugException e) {
            JDIDebugPlugin.log(e);
            return null;
        }
        return null;
    }

    private IJavaStackFrame getStackFrame(IValue value) throws CoreException {
        IJavaStackFrame stackFrame;
        IStatusHandler handler = JavaLogicalStructure.getStackFrameProvider();
        if (handler != null && (stackFrame = (IJavaStackFrame)handler.handleStatus(JDIDebugPlugin.STATUS_GET_EVALUATION_FRAME, (Object)value)) != null) {
            return stackFrame;
        }
        IDebugTarget target = value.getDebugTarget();
        IJavaDebugTarget javaTarget = (IJavaDebugTarget)target.getAdapter(IJavaDebugTarget.class);
        if (javaTarget != null) {
            IThread[] threads;
            IThread[] iThreadArray = threads = javaTarget.getThreads();
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                if (thread.isSuspended()) {
                    return (IJavaStackFrame)thread.getTopStackFrame();
                }
                ++n2;
            }
        }
        return null;
    }

    private static IStatusHandler getStackFrameProvider() {
        if (fgStackFrameProvider == null) {
            fgStackFrameProvider = DebugPlugin.getDefault().getStatusHandler(JDIDebugPlugin.STATUS_GET_EVALUATION_FRAME);
        }
        return fgStackFrameProvider;
    }

    public boolean isSubtypes() {
        return this.fSubtypes;
    }

    public void setSubtypes(boolean subtypes) {
        this.fSubtypes = subtypes;
    }

    public String getQualifiedTypeName() {
        return this.fType;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public String[][] getVariables() {
        return this.fVariables;
    }

    public void setVariables(String[][] variables) {
        this.fVariables = variables;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription(IValue value) {
        return this.getDescription();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public boolean isContributed() {
        return this.fContributingPluginId != null;
    }

    public String getContributingPluginId() {
        return this.fContributingPluginId;
    }

    public String getId() {
        return JDIDebugPlugin.getUniqueIdentifier() + this.fType + this.fDescription;
    }

    private class EvaluationBlock
    implements IEvaluationListener {
        private final IJavaObject fEvaluationValue;
        private final IJavaReferenceType fEvaluationType;
        private final IJavaThread fThread;
        private final IAstEvaluationEngine fEvaluationEngine;
        private IEvaluationResult fResult;

        public EvaluationBlock(IJavaObject value, IJavaReferenceType type, IJavaThread thread, IAstEvaluationEngine evaluationEngine) {
            this.fEvaluationValue = value;
            this.fEvaluationType = type;
            this.fThread = thread;
            this.fEvaluationEngine = evaluationEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evaluationComplete(IEvaluationResult result) {
            EvaluationBlock evaluationBlock = this;
            synchronized (evaluationBlock) {
                this.fResult = result;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IJavaValue evaluate(String snippet) throws DebugException {
            Map<String, String> compileOptions = Collections.singletonMap("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
            ICompiledExpression compiledExpression = this.fEvaluationEngine.getCompiledExpression(snippet, this.fEvaluationType, compileOptions);
            if (compiledExpression.hasErrors()) {
                String[] errorMessages = compiledExpression.getErrorMessages();
                this.log(errorMessages);
                return new JavaStructureErrorValue(errorMessages, (IJavaValue)this.fEvaluationValue);
            }
            this.fResult = null;
            this.fEvaluationEngine.evaluateExpression(compiledExpression, this.fEvaluationValue, this.fThread, this, 384, false);
            EvaluationBlock errorMessages = this;
            synchronized (errorMessages) {
                if (this.fResult == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.fResult == null) {
                return new JavaStructureErrorValue(LogicalStructuresMessages.JavaLogicalStructure_1, (IJavaValue)this.fEvaluationValue);
            }
            if (this.fResult.hasErrors()) {
                String message;
                DebugException exception = this.fResult.getException();
                if (exception != null) {
                    if (exception.getStatus().getException() instanceof UnsupportedOperationException) {
                        message = LogicalStructuresMessages.JavaLogicalStructure_0;
                    } else {
                        if (exception.getStatus().getCode() == 100) {
                            throw exception;
                        }
                        message = MessageFormat.format(LogicalStructuresMessages.JavaLogicalStructure_2, exception.getMessage());
                    }
                } else {
                    message = LogicalStructuresMessages.JavaLogicalStructure_3;
                }
                return new JavaStructureErrorValue(message, (IJavaValue)this.fEvaluationValue);
            }
            return this.fResult.getValue();
        }

        private void log(String[] messages) {
            if (JavaLogicalStructure.this.isContributed()) {
                String log = Arrays.asList(messages).stream().collect(Collectors.joining("\n"));
                String error = String.format("Error while evaluating '%s' logical structure for type %s with the value '%s'", JavaLogicalStructure.this.getDescription(), JavaLogicalStructure.this.getQualifiedTypeName(), JavaLogicalStructure.this.getValue());
                JDIDebugPlugin.log((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 4, error, (Throwable)new IllegalStateException(log)));
            }
        }
    }
}

