/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.StreamUtil;

public abstract class BasePersistenceModel
implements IPersistenceModel {
    protected final Map<String, File> files = new HashMap<String, File>();
    protected final Resource element;
    protected final File root;
    protected final IPath rootPath;
    private boolean modified = false;
    private byte[] internalContent = null;
    private Set<String> extractions = new HashSet<String>();
    private boolean disposed = false;

    protected abstract void doExtractAll(InputStream var1) throws IOException;

    protected abstract void doExtractFile(String var1, InputStream var2) throws IOException;

    protected abstract void doReadIndex(InputStream var1);

    protected abstract void doStoreTo(File var1) throws FileNotFoundException, IOException;

    @Override
    public boolean isContentEntryRequired() {
        return true;
    }

    @Override
    public boolean isAllowEmptyMetadataContent() {
        return false;
    }

    public BasePersistenceModel(Resource element) {
        String uri;
        RcpttPlugin default1;
        this.element = element;
        IPath nonExistent = null;
        do {
            default1 = RcpttPlugin.getDefault();
            assert (default1 != null);
            String string = uri = element == null || element.getURI() == null ? "_" : element.getURI().toString();
        } while ((nonExistent = default1.getStateLocation().append("attachments").append(String.valueOf(FileUtil.limitSize((String)FileUtil.getID((String)uri))) + System.currentTimeMillis())).toFile().exists());
        assert (nonExistent != null);
        this.rootPath = nonExistent;
        this.root = this.rootPath.toFile();
        try {
            this.readIndex();
        }
        catch (CoreException e) {
            RcpttPlugin.log(e);
        }
    }

    @Override
    public Resource getResource() {
        return this.element;
    }

    public void setInternalContent(byte[] internalContent) {
        this.internalContent = internalContent;
        try {
            this.readIndex();
        }
        catch (CoreException e) {
            RcpttPlugin.log(e);
        }
    }

    private void initialize() {
        assert (!this.disposed);
        this.root.mkdirs();
    }

    @Override
    public boolean hasElements() {
        return !this.files.isEmpty();
    }

    @Override
    public String[] getNames() {
        return this.files.keySet().toArray(new String[this.files.size()]);
    }

    private void readIndex() throws CoreException {
        assert (!this.disposed);
        InputStream contents = this.getContentsStream();
        if (contents == null) {
            return;
        }
        try {
            this.doReadIndex(contents);
        }
        catch (Throwable throwable) {
            try {
                contents.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            contents.close();
        }
        catch (IOException iOException) {}
    }

    protected InputStream getContentsStream() {
        IFile file;
        InputStream input;
        block7: {
            input = null;
            IFile iFile = file = this.element != null ? Q7Utils.getLocation(this.element) : null;
            if (file != null && !file.exists()) {
                return null;
            }
            if (this.internalContent != null) {
                input = new ByteArrayInputStream(this.internalContent);
            }
            try {
                if (input != null || file != null) break block7;
                return null;
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() != 271) {
                    RcpttPlugin.log(e);
                }
                return null;
            }
        }
        if (input == null) {
            input = file.getContents();
        }
        BufferedInputStream contents = new BufferedInputStream(input);
        return contents;
    }

    protected File putFileItem(String name, IPath filePath) {
        return this.files.put(name, filePath.toFile());
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.removeAll();
        this.disposed = true;
    }

    @Override
    public InputStream read(String name) {
        assert (!this.disposed);
        File file = this.files.get(name);
        if (file == null) {
            return null;
        }
        this.waitUntilExtracted(name);
        if (!file.exists()) {
            this.extractFile(name);
            this.waitUntilExtracted(name);
        }
        if (file.exists()) {
            try {
                return this.getInput(file);
            }
            catch (FileNotFoundException e) {
                RcpttPlugin.log(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilExtracted(String name) {
        Set<String> set = this.extractions;
        synchronized (set) {
            while (true) {
                if (!this.extractions.contains(name)) {
                    return;
                }
                try {
                    this.extractions.wait(100L);
                }
                catch (InterruptedException e) {
                    RcpttPlugin.log(e);
                }
            }
        }
    }

    protected BufferedInputStream getInput(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void extractFile(String fName) {
        InputStream contents;
        block36: {
            block35: {
                this.initialize();
                contents = null;
                Set<String> set = this.extractions;
                // MONITORENTER : set
                if (!this.extractions.contains(fName)) break block35;
                // MONITOREXIT : set
                Set<String> set2 = this.extractions;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : set
                        throw throwable;
                    }
                }
                // MONITORENTER : set2
                this.extractions.remove(fName);
                this.extractions.notifyAll();
                // MONITOREXIT : set2
                try {
                    if (contents == null) return;
                    contents.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            this.extractions.add(fName);
            // MONITOREXIT : set
            contents = this.getContentsStream();
            if (contents != null) break block36;
            Set<String> set = this.extractions;
            // MONITORENTER : set
            this.extractions.remove(fName);
            this.extractions.notifyAll();
            // MONITOREXIT : set
            try {
                if (contents == null) return;
                contents.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                this.doExtractFile(fName, contents);
            }
            catch (Throwable e1) {
                RcpttPlugin.log(e1);
                Set<String> set = this.extractions;
                // MONITORENTER : set
                this.extractions.remove(fName);
                this.extractions.notifyAll();
                // MONITOREXIT : set
                try {
                    if (contents == null) return;
                    contents.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Set<String> set = this.extractions;
            // MONITORENTER : set
            this.extractions.remove(fName);
            this.extractions.notifyAll();
            // MONITOREXIT : set
            try {
                if (contents == null) throw throwable;
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Set<String> set = this.extractions;
        // MONITORENTER : set
        this.extractions.remove(fName);
        this.extractions.notifyAll();
        // MONITOREXIT : set
        try {
            if (contents == null) return;
            contents.close();
            return;
        }
        catch (IOException iOException) {}
    }

    @Override
    public void delete(String name) {
        File file = this.files.get(name);
        if (file != null && file.exists()) {
            file.delete();
        }
        this.files.remove(name);
    }

    @Override
    public boolean restore(String name) {
        File file = this.files.get(name);
        if (file != null && file.exists()) {
            file.delete();
            this.extractFile(name);
            return file.exists();
        }
        return false;
    }

    @Override
    public OutputStream store(String name) {
        this.modified = true;
        return this.internalStore(name);
    }

    protected OutputStream internalStore(String name) {
        this.initialize();
        IPath path = this.rootPath.append((IPath)new Path(name));
        File file = path.toFile();
        file.getParentFile().mkdirs();
        this.files.put(name, file);
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            RcpttPlugin.log(e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extractAll() {
        InputStream contents;
        block13: {
            this.initialize();
            contents = null;
            contents = this.getContentsStream();
            if (contents != null) break block13;
            try {
                if (contents == null) return;
                contents.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                this.doExtractAll(contents);
            }
            catch (Throwable e1) {
                RcpttPlugin.log(e1);
                try {
                    if (contents == null) return;
                    contents.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (contents == null) throw throwable;
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (contents == null) return;
            contents.close();
            return;
        }
        catch (IOException iOException) {}
    }

    @Override
    public File storeToTemporaty() {
        this.initialize();
        File file = this.rootPath.append(".q7.content.temporary" + System.currentTimeMillis()).toFile();
        try {
            this.doStoreTo(file);
        }
        catch (Exception e) {
            RcpttPlugin.log(e);
        }
        return file;
    }

    @Override
    public void removeAll() {
        this.files.clear();
        if (this.root != null) {
            FileUtil.deleteFiles((File[])this.root.listFiles());
            this.root.delete();
        }
    }

    @Override
    public boolean copyFrom(IPersistenceModel originalModel) {
        String[] names;
        this.removeAll();
        String[] stringArray = names = originalModel.getNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            InputStream inputStream = originalModel.read(name);
            OutputStream outputStream = this.store(name);
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return names.length > 0;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void updateMetadata() {
    }

    @Override
    public void updateAttributes() {
    }

    @Override
    public void setUnmodified() {
        this.modified = false;
    }

    @Override
    public int size(String teslaContentEntry) {
        InputStream stream = this.read(teslaContentEntry);
        int result = 0;
        if (stream != null) {
            try {
                try {
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    while ((len = stream.read(buffer)) > 0) {
                        result += len;
                    }
                }
                catch (IOException iOException) {
                    result = 0;
                    StreamUtil.closeSilently((Closeable)stream);
                }
            }
            finally {
                StreamUtil.closeSilently((Closeable)stream);
            }
        }
        return result;
    }

    @Override
    public void rename(String oldName, String newName) {
        InputStream read = this.read(oldName);
        if (read != null) {
            OutputStream store = this.store(newName);
            try {
                FileUtil.copy((InputStream)read, (OutputStream)store);
                this.delete(oldName);
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
        }
    }
}

