/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.RefactoringUtils;

public class UpdateTagReferenceChange
extends Change {
    private final IQ7NamedElement element;
    private final String newTagName;
    private final String oldTagName;

    public UpdateTagReferenceChange(IQ7NamedElement element, String oldTagName, String newTagName) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)oldTagName);
        Assert.isNotNull((Object)newTagName);
        this.element = element;
        this.oldTagName = oldTagName;
        this.newTagName = newTagName;
    }

    public String getName() {
        return NLS.bind((String)Messages.UpdateTagReferenceChange_Name, (Object[])new Object[]{this.oldTagName, RefactoringUtils.elementToString(this.element)});
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            int index;
            String tags;
            pm.beginTask(this.getName(), 1);
            String newTags = tags = this.element.getTags();
            Matcher matcher = Pattern.compile(",\\s*(" + this.oldTagName + ")").matcher(tags);
            while (matcher.find()) {
                index = matcher.start(1);
                newTags = String.valueOf(newTags.substring(0, index)) + this.newTagName + newTags.substring(index + this.oldTagName.length(), newTags.length());
            }
            matcher = Pattern.compile("\\s*(" + this.oldTagName + ")").matcher(tags);
            if (matcher.lookingAt()) {
                index = matcher.start(1);
                newTags = String.valueOf(newTags.substring(0, index)) + this.newTagName + newTags.substring(index + this.oldTagName.length(), newTags.length());
            }
            IQ7NamedElement elementWc = this.element.getWorkingCopy(pm);
            try {
                elementWc.setTags(newTags);
                elementWc.commitWorkingCopy(true, pm);
            }
            finally {
                elementWc.discardWorkingCopy();
            }
            UpdateTagReferenceChange updateTagReferenceChange = new UpdateTagReferenceChange(this.element, this.newTagName, this.oldTagName);
            return updateTagReferenceChange;
        }
        finally {
            pm.done();
        }
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.element.getTags().contains(this.oldTagName)) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)Messages.UpdateTagReferenceChange_InvalidStateMsg, (Object)RefactoringUtils.elementToString(this.element), (Object)this.oldTagName));
        }
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.element;
    }
}

