/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.processors;

import java.util.WeakHashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rcptt.tesla.core.protocol.ActivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.CancelCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.DeactivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.ui.SWTElementMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.jface.rap.TeslaCellEditorManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CellEditorSupport {
    private SWTUIProcessor processor;
    protected WeakHashMap<Widget, CellEditor> cellEditorActivations = new WeakHashMap();

    public CellEditorSupport(SWTUIProcessor processor) {
        this.processor = processor;
    }

    protected Response handleActivateCellEditor(ActivateCellEditor command) {
        Element element = command.getElement();
        final SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement != null) {
            final int column = command.getColumn();
            if (uiElement.isTree()) {
                String[] path;
                final Tree tree = (Tree)PlayerWrapUtils.unwrapWidget(uiElement);
                final TreeItem current = Viewers.getTreeItem(tree, path = uiElement.getPathSelection());
                if (current != null) {
                    this.getPlayer().exec("Run cell editor", new Runnable(){

                        @Override
                        public void run() {
                            TreeItem[] selection;
                            TreeItem ti;
                            TreeViewer viewer = TeslaSWTAccess.getTreeViewer(tree);
                            if (current instanceof TreeItem && viewer != null && !this.edit(uiElement, column, viewer, ti = (TreeItem)current)) {
                                this.edit(uiElement, column, viewer, ti);
                            }
                            Object vv = TeslaSWTAccess.getPropertySheet((Control)tree);
                            TeslaCellEditorManager instance = TeslaCellEditorManager.getInstance();
                            if (vv != null && (selection = tree.getSelection()).length == 1) {
                                instance.makeNewAsForced(true);
                                TeslaSWTAccess.callHandleSelect(vv, selection);
                                CellEditorSupport.this.cellEditorActivations.put(uiElement.widget, instance.getLastActivated());
                                instance.makeNewAsForced(false);
                            }
                        }

                        private boolean edit(SWTUIElement uiElement2, int column2, TreeViewer viewer, TreeItem ti) {
                            block11: {
                                TeslaCellEditorManager instance = TeslaCellEditorManager.getInstance();
                                if (viewer.isCellEditorActive()) {
                                    CellEditor[] editors = viewer.getCellEditors();
                                    if (editors != null && editors.length == 1) {
                                        CellEditorSupport.this.cellEditorActivations.put(uiElement2.widget, editors[0]);
                                        return true;
                                    }
                                    ColumnViewerEditor cve = viewer.getColumnViewerEditor();
                                    if (cve != null) {
                                        if (cve.getFocusCell() != null && cve.getFocusCell().getColumnIndex() == column2) {
                                            CellEditor editor = TeslaSWTAccess.getCellEditorFromColumnEditor(cve);
                                            if (editor != null) {
                                                CellEditorSupport.this.cellEditorActivations.put(uiElement2.widget, editor);
                                                return true;
                                            }
                                        } else {
                                            viewer.cancelEditing();
                                        }
                                    }
                                }
                                try {
                                    instance.makeNewAsForced(true);
                                    Object toEdit = ti.getData();
                                    if (toEdit == null) {
                                        toEdit = ti;
                                    }
                                    viewer.editElement(toEdit, column2);
                                    if (instance.getLastActivated() != null) {
                                        CellEditorSupport.this.cellEditorActivations.put(uiElement2.widget, instance.getLastActivated());
                                        break block11;
                                    }
                                    return false;
                                }
                                finally {
                                    instance.makeNewAsForced(false);
                                }
                            }
                            return true;
                        }
                    });
                }
            } else if (uiElement.isTable()) {
                TableItem current;
                Table table = (Table)PlayerWrapUtils.unwrapWidget(uiElement);
                String[] path = uiElement.getPathSelection();
                String curPath = "";
                if (path != null && path.length > 0) {
                    curPath = path[0];
                }
                if ((current = Viewers.getTableItem(table, curPath)) != null) {
                    final TableViewer viewer = TeslaSWTAccess.getTableViewer(table);
                    final TeslaCellEditorManager instance = TeslaCellEditorManager.getInstance();
                    if (viewer != null) {
                        this.getPlayer().exec("Run cell editor", new Runnable(){

                            @Override
                            public void run() {
                                TableItem ti;
                                boolean done = false;
                                if (current instanceof TableItem && (ti = (TableItem)current).getData() != null) {
                                    done = true;
                                    if (viewer.isCellEditorActive()) {
                                        CellEditor[] editors = viewer.getCellEditors();
                                        if (editors != null && editors.length == 1) {
                                            CellEditorSupport.this.cellEditorActivations.put(uiElement.widget, editors[0]);
                                            return;
                                        }
                                        ColumnViewerEditor cve = viewer.getColumnViewerEditor();
                                        if (cve != null) {
                                            if (cve.getFocusCell() != null && cve.getFocusCell().getColumnIndex() == column) {
                                                CellEditor editor = TeslaSWTAccess.getCellEditorFromColumnEditor(cve);
                                                if (editor != null) {
                                                    CellEditorSupport.this.cellEditorActivations.put(uiElement.widget, editor);
                                                    return;
                                                }
                                            } else {
                                                viewer.cancelEditing();
                                            }
                                        }
                                    }
                                    instance.makeNewAsForced(true);
                                    try {
                                        viewer.editElement(ti.getData(), column);
                                        CellEditorSupport.this.cellEditorActivations.put(uiElement.widget, instance.getLastActivated());
                                    }
                                    finally {
                                        instance.makeNewAsForced(false);
                                    }
                                }
                                if (!done) {
                                    if (viewer.isCellEditorActive()) {
                                        viewer.cancelEditing();
                                    }
                                    try {
                                        instance.makeNewAsForced(true);
                                        if (current instanceof TableItem && ((TableItem)current).getData() != null) {
                                            viewer.editElement(((TableItem)current).getData(), column);
                                        } else {
                                            viewer.editElement(current, column);
                                        }
                                        CellEditorSupport.this.cellEditorActivations.put(uiElement.widget, instance.getLastActivated());
                                    }
                                    finally {
                                        instance.makeNewAsForced(false);
                                    }
                                }
                            }
                        });
                    } else {
                        TableItem[] selection;
                        Object vv = TeslaSWTAccess.getPropertySheet((Control)table);
                        if (vv != null && (selection = table.getSelection()).length == 1) {
                            instance.makeNewAsForced(true);
                            TeslaSWTAccess.callHandleSelect(vv, selection);
                            this.cellEditorActivations.put(uiElement.widget, instance.getLastActivated());
                            instance.makeNewAsForced(false);
                        }
                    }
                }
            }
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    private SWTElementMapper getMapper() {
        return this.processor.getMapper();
    }

    private SWTUIPlayer getPlayer() {
        return this.processor.getPlayer();
    }

    protected Response handleApplyCellEditor(final ApplyCellEditor command) {
        CellEditor cellEditor;
        Element element = command.getElement();
        final SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement != null && (cellEditor = this.cellEditorActivations.get(uiElement.widget)) != null) {
            this.getPlayer().exec("Apply direct edit", new Runnable(){

                @Override
                public void run() {
                    TeslaSWTAccess.callMethodValueChanged(cellEditor, "valueChanged", cellEditor.isValueValid(), true);
                    TeslaSWTAccess.callMethod(cellEditor, "fireApplyEditorValue", new Object[0]);
                    if (cellEditor instanceof ComboBoxViewerCellEditor) {
                        TeslaSWTAccess.callMethod(ComboBoxViewerCellEditor.class, (Object)cellEditor, "applyEditorValueAndDeactivate", new Object[0]);
                    }
                    if (command.isDeactivate()) {
                        cellEditor.deactivate();
                        CellEditorSupport.this.cellEditorActivations.remove(uiElement.widget);
                    }
                }
            });
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    protected Response handleCancelCellEditor(CancelCellEditor command) {
        CellEditor cellEditor;
        Element element = command.getElement();
        SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement != null && (cellEditor = this.cellEditorActivations.get(uiElement.widget)) != null) {
            this.getPlayer().exec("Cancel direct edit", new Runnable(){

                @Override
                public void run() {
                    TeslaSWTAccess.callMethod(cellEditor, "fireCancelEditor", new Object[0]);
                }
            });
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    protected Response handleDeactivateCellEditor(DeactivateCellEditor command) {
        CellEditor cellEditor;
        Element element = command.getElement();
        final SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement != null && (cellEditor = this.cellEditorActivations.get(uiElement.widget)) != null) {
            this.getPlayer().exec("Deactivate cell edit", new Runnable(){

                @Override
                public void run() {
                    cellEditor.deactivate();
                    CellEditorSupport.this.getPlayer().getEvents().sendFocus(uiElement.unwrap());
                    CellEditorSupport.this.cellEditorActivations.remove(uiElement.widget);
                }
            });
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    public void clear() {
        this.cellEditorActivations.clear();
    }
}

