/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.model.index.IIndexer;

public class IndexerManager {
    private List<IIndexer> indexers = null;
    private static IndexerManager instance = null;

    private IndexerManager() {
    }

    private synchronized void initialize() {
        IConfigurationElement[] elements;
        if (this.indexers != null) {
            return;
        }
        this.indexers = new ArrayList<IIndexer>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.core.indexer");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                IIndexer provider = (IIndexer)cfg.createExecutableExtension("class");
                this.indexers.add(provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public IIndexer[] getIndexers() {
        this.initialize();
        return this.indexers.toArray(new IIndexer[this.indexers.size()]);
    }

    public static synchronized IndexerManager getInstance() {
        if (instance == null) {
            instance = new IndexerManager();
        }
        return instance;
    }
}

