/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.UpdateCore;

public class SiteManager {
    private static String os;
    private static String ws;
    private static String arch;
    private static String nl;

    private SiteManager() {
    }

    public static ISite getSite(URL siteURL) throws CoreException {
        return InternalSiteManager.getSite(siteURL, true, null);
    }

    public static ISite getSite(URL siteURL, IProgressMonitor monitor) throws CoreException {
        return InternalSiteManager.getSite(siteURL, true, monitor);
    }

    public static ISite getSite(URL siteURL, boolean usesCache) throws CoreException {
        return InternalSiteManager.getSite(siteURL, usesCache, null);
    }

    public static ISite getSite(URL siteURL, boolean usesCache, IProgressMonitor monitor) throws CoreException {
        return InternalSiteManager.getSite(siteURL, usesCache, monitor);
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.getLocalSite();
    }

    public static void handleNewChanges() throws CoreException {
    }

    public static String getOSArch() {
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        return arch;
    }

    public static String getOS() {
        if (os == null) {
            os = Platform.getOS();
        }
        return os;
    }

    public static String getWS() {
        if (ws == null) {
            ws = Platform.getWS();
        }
        return ws;
    }

    public static void setOSArch(String arch) {
        SiteManager.arch = arch;
    }

    public static void setOS(String os) {
        SiteManager.os = os;
    }

    public static void setWS(String ws) {
        SiteManager.ws = ws;
    }

    public static void setNL(String nl) {
        SiteManager.nl = nl;
    }

    public static long getEstimatedTransferRate(URL site) {
        if (site == null) {
            return 0L;
        }
        return InternalSiteManager.getEstimatedTransferRate(site.getHost());
    }

    public static String getNL() {
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }

    public static String getHttpProxyServer() {
        IProxyData data;
        IProxyService service = UpdateCore.getPlugin().getProxyService();
        if (service != null && service.isProxiesEnabled() && (data = service.getProxyData("HTTP")) != null) {
            return data.getHost();
        }
        return null;
    }

    public static String getHttpProxyPort() {
        IProxyData data;
        IProxyService service = UpdateCore.getPlugin().getProxyService();
        if (service != null && service.isProxiesEnabled() && (data = service.getProxyData("HTTP")) != null) {
            if (data.getPort() == -1) {
                return "80";
            }
            return String.valueOf(data.getPort());
        }
        return null;
    }

    public static boolean isHttpProxyEnable() {
        IProxyService service = UpdateCore.getPlugin().getProxyService();
        if (service != null && service.isProxiesEnabled()) {
            IProxyData data = service.getProxyData("HTTP");
            return data != null && data.getHost() != null;
        }
        return false;
    }

    public static void setHttpProxyInfo(boolean enable, String httpProxyServer, String httpProxyPort) {
        IProxyData data;
        IProxyService service = UpdateCore.getPlugin().getProxyService();
        if (service == null) {
            return;
        }
        if (enable && !service.isProxiesEnabled()) {
            service.setProxiesEnabled(enable);
        }
        if (service.isProxiesEnabled() && (data = service.getProxyData("HTTP")) != null) {
            data.setHost(httpProxyServer);
            if (httpProxyPort == null || httpProxyPort.equals("80")) {
                data.setPort(-1);
            } else {
                try {
                    int port = Integer.parseInt(httpProxyPort);
                    data.setPort(port);
                }
                catch (NumberFormatException e) {
                    UpdateCore.log(e);
                }
            }
            try {
                service.setProxyData(new IProxyData[]{data});
            }
            catch (CoreException e) {
                UpdateCore.log(e);
            }
        }
    }
}

