/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl.rap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.util.swt.rap.ImageUtil;
import org.eclipse.rcptt.util.swt.rap.TableTreeUtil;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Column;
import org.eclipse.rcptt.verifications.tree.ItemData;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;
import org.eclipse.rcptt.verifications.tree.TreeFactory;
import org.eclipse.rcptt.verifications.tree.TreeVerificationUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class TreeVerificationModeller {
    public static Tree getTreeData(Widget widget, boolean includeRowsData) {
        Tree result = TreeFactory.eINSTANCE.createTree();
        Widget[] columns = TableTreeUtil.getColumns((Widget)widget);
        result.setStyle(widget.getStyle());
        result.setEnabled(TableTreeUtil.getEnabled((Widget)widget));
        result.setHeaderVisible(TableTreeUtil.getHeaderVisible((Widget)widget));
        result.setLinesVisible(TableTreeUtil.getLinesVisible((Widget)widget));
        result.setSortColumnInd(TableTreeUtil.getSortColumn((Widget)widget));
        result.setSortDirection(TableTreeUtil.getSortDirection((Widget)widget));
        int i = 0;
        while (i < columns.length) {
            Column col = TreeFactory.eINSTANCE.createColumn();
            Widget column = columns[i];
            col.setImage(SWTModelMapper.mapImage((Image)TableTreeUtil.getColumnImage((Widget)column)));
            col.setStyle(column.getStyle());
            col.setTooltip(TableTreeUtil.getTooltip((Widget)column));
            col.setName(TableTreeUtil.getName((Widget)column));
            col.setWidth(TableTreeUtil.getWidth((Widget)column));
            result.getColumns().add((Object)col);
            ++i;
        }
        if (includeRowsData) {
            Item[] itemArray = TableTreeUtil.getItems((Widget)widget);
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                result.getRows().add((Object)TreeVerificationModeller.getRow(item, columns.length, true));
                ++n2;
            }
        }
        return result;
    }

    public static Row getRow(Item item, int columnCount, boolean includeChildren) {
        Row result = TreeFactory.eINSTANCE.createRow();
        ItemData itemData = TreeFactory.eINSTANCE.createItemData();
        org.eclipse.rcptt.tesla.core.ui.Image image = SWTModelMapper.mapImage((Image)TableTreeUtil.getImage((Item)item));
        result.setChecked(TableTreeUtil.isChecked((Widget)item));
        result.setGrayed(TableTreeUtil.getGrayed((Widget)item));
        itemData.setText(TableTreeUtil.getValue((Item)item));
        itemData.setBackgroundColor(SWTModelMapper.makeColor((Color)TableTreeUtil.getBackground((Widget)item)));
        itemData.setForegroundColor(SWTModelMapper.makeColor((Color)TableTreeUtil.getForeground((Widget)item)));
        itemData.setImage(image);
        result.setData(itemData);
        if (columnCount == 0) {
            result.getValues().add((Object)TreeVerificationModeller.createCellfromItem(item, 0));
        } else {
            int i = 0;
            while (i < columnCount) {
                result.getValues().add((Object)TreeVerificationModeller.createCellfromItem(item, i));
                ++i;
            }
        }
        if (includeChildren) {
            Item[] itemArray = TableTreeUtil.getChildren((Widget)item);
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item child = itemArray[n2];
                result.getChildren().add((Object)TreeVerificationModeller.getRow(child, columnCount, true));
                ++n2;
            }
        }
        return result;
    }

    private static Cell createCellfromItem(Item item, int index) {
        Cell cell = TreeFactory.eINSTANCE.createCell();
        ItemData cellData = TreeFactory.eINSTANCE.createItemData();
        org.eclipse.rcptt.tesla.core.ui.Image image = SWTModelMapper.mapImage((Image)TableTreeUtil.getImage((Item)item, (int)index));
        cellData.setText(TableTreeUtil.getValue((Item)item, (int)index));
        cellData.setBackgroundColor(SWTModelMapper.makeColor((Color)TableTreeUtil.getBackground((Widget)item, (int)index)));
        cellData.setForegroundColor(SWTModelMapper.makeColor((Color)TableTreeUtil.getForeground((Widget)item, (int)index)));
        cellData.setImage(image);
        cell.setData(cellData);
        return cell;
    }

    public static Map<String, byte[]> extractImages(Widget widget) {
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        Widget[] widgetArray = TableTreeUtil.getColumns((Widget)widget);
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget column = widgetArray[n2];
            TreeVerificationModeller.insertImage(TableTreeUtil.getColumnImage((Widget)column), images);
            ++n2;
        }
        widgetArray = TableTreeUtil.getItems((Widget)widget);
        n = widgetArray.length;
        n2 = 0;
        while (n2 < n) {
            Widget item = widgetArray[n2];
            TreeVerificationModeller.extractImages((Item)item, images);
            ++n2;
        }
        return images;
    }

    private static void extractImages(Item item, Map<String, byte[]> imagesDest) {
        int i;
        int columnsCount = TableTreeUtil.getColumnCount((Widget)item);
        ArrayList<Image> images = new ArrayList<Image>();
        if (columnsCount == 0) {
            images.add(TableTreeUtil.getImage((Item)item));
        } else {
            i = 0;
            while (i < columnsCount) {
                images.add(TableTreeUtil.getImage((Item)item, (int)i));
                ++i;
            }
        }
        i = 0;
        while (i < images.size()) {
            TreeVerificationModeller.insertImage((Image)images.get(i), imagesDest);
            ++i;
        }
        Item[] itemArray = TableTreeUtil.getChildren((Widget)item);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item child = itemArray[n2];
            TreeVerificationModeller.extractImages(child, imagesDest);
            ++n2;
        }
    }

    private static void insertImage(Image swtImage, Map<String, byte[]> imageDest) {
        String path;
        org.eclipse.rcptt.tesla.core.ui.Image image = SWTModelMapper.mapImage((Image)swtImage);
        if (image != null && !imageDest.containsKey(path = TreeVerificationUtils.getDecoratedImagePath((org.eclipse.rcptt.tesla.core.ui.Image)image))) {
            imageDest.put(path, ImageUtil.serializeImage((Image)swtImage));
        }
    }
}

