/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.util.ArrayList;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.text.templates.ContextTypeRegistry;

public class CodeTemplateContextType
extends TemplateContextType {
    public static final String CATCHBLOCK_CONTEXTTYPE = "catchblock_context";
    public static final String METHODBODY_CONTEXTTYPE = "methodbody_context";
    public static final String CONSTRUCTORBODY_CONTEXTTYPE = "constructorbody_context";
    public static final String GETTERBODY_CONTEXTTYPE = "getterbody_context";
    public static final String SETTERBODY_CONTEXTTYPE = "setterbody_context";
    public static final String NEWTYPE_CONTEXTTYPE = "newtype_context";
    public static final String CLASSBODY_CONTEXTTYPE = "classbody_context";
    public static final String INTERFACEBODY_CONTEXTTYPE = "interfacebody_context";
    public static final String ENUMBODY_CONTEXTTYPE = "enumbody_context";
    public static final String ANNOTATIONBODY_CONTEXTTYPE = "annotationbody_context";
    public static final String FILECOMMENT_CONTEXTTYPE = "filecomment_context";
    public static final String TYPECOMMENT_CONTEXTTYPE = "typecomment_context";
    public static final String FIELDCOMMENT_CONTEXTTYPE = "fieldcomment_context";
    public static final String METHODCOMMENT_CONTEXTTYPE = "methodcomment_context";
    public static final String CONSTRUCTORCOMMENT_CONTEXTTYPE = "constructorcomment_context";
    public static final String OVERRIDECOMMENT_CONTEXTTYPE = "overridecomment_context";
    public static final String DELEGATECOMMENT_CONTEXTTYPE = "delegatecomment_context";
    public static final String GETTERCOMMENT_CONTEXTTYPE = "gettercomment_context";
    public static final String SETTERCOMMENT_CONTEXTTYPE = "settercomment_context";
    private static final String CODETEMPLATES_PREFIX = "org.eclipse.jdt.ui.text.codetemplates.";
    public static final String COMMENT_SUFFIX = "comment";
    public static final String CATCHBLOCK_ID = "org.eclipse.jdt.ui.text.codetemplates.catchblock";
    public static final String METHODSTUB_ID = "org.eclipse.jdt.ui.text.codetemplates.methodbody";
    public static final String NEWTYPE_ID = "org.eclipse.jdt.ui.text.codetemplates.newtype";
    public static final String CONSTRUCTORSTUB_ID = "org.eclipse.jdt.ui.text.codetemplates.constructorbody";
    public static final String GETTERSTUB_ID = "org.eclipse.jdt.ui.text.codetemplates.getterbody";
    public static final String SETTERSTUB_ID = "org.eclipse.jdt.ui.text.codetemplates.setterbody";
    public static final String FILECOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.filecomment";
    public static final String TYPECOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.typecomment";
    public static final String CLASSBODY_ID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
    public static final String INTERFACEBODY_ID = "org.eclipse.jdt.ui.text.codetemplates.interfacebody";
    public static final String ENUMBODY_ID = "org.eclipse.jdt.ui.text.codetemplates.enumbody";
    public static final String ANNOTATIONBODY_ID = "org.eclipse.jdt.ui.text.codetemplates.annotationbody";
    public static final String FIELDCOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.fieldcomment";
    public static final String METHODCOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
    public static final String CONSTRUCTORCOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
    public static final String OVERRIDECOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
    public static final String DELEGATECOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.delegatecomment";
    public static final String GETTERCOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
    public static final String SETTERCOMMENT_ID = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
    public static final String EXCEPTION_TYPE = "exception_type";
    public static final String EXCEPTION_VAR = "exception_var";
    public static final String ENCLOSING_METHOD = "enclosing_method";
    public static final String ENCLOSING_TYPE = "enclosing_type";
    public static final String BODY_STATEMENT = "body_statement";
    public static final String FIELD = "field";
    public static final String FIELD_TYPE = "field_type";
    public static final String BARE_FIELD_NAME = "bare_field_name";
    public static final String PARAM = "param";
    public static final String RETURN_TYPE = "return_type";
    public static final String SEE_TO_OVERRIDDEN_TAG = "see_to_overridden";
    public static final String SEE_TO_TARGET_TAG = "see_to_target";
    public static final String TAGS = "tags";
    public static final String TYPENAME = "type_name";
    public static final String FILENAME = "file_name";
    public static final String PACKAGENAME = "package_name";
    public static final String PROJECTNAME = "project_name";
    public static final String PACKAGE_DECLARATION = "package_declaration";
    public static final String TYPE_DECLARATION = "type_declaration";
    public static final String CLASS_BODY = "classbody";
    public static final String INTERFACE_BODY = "interfacebody";
    public static final String ENUM_BODY = "enumbody";
    public static final String ANNOTATION_BODY = "annotationbody";
    public static final String TYPE_COMMENT = "typecomment";
    public static final String FILE_COMMENT = "filecomment";
    private boolean fIsComment = false;

    public CodeTemplateContextType(String contextName) {
        super(contextName);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new Todo());
        if (CATCHBLOCK_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(EXCEPTION_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_exceptiontype));
            this.addResolver(new CodeTemplateVariableResolver(EXCEPTION_VAR, JavaManipulationMessages.CodeTemplateContextType_variable_description_exceptionvar));
        } else if (METHODBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(BODY_STATEMENT, JavaManipulationMessages.CodeTemplateContextType_variable_description_bodystatement));
        } else if (CONSTRUCTORBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(BODY_STATEMENT, JavaManipulationMessages.CodeTemplateContextType_variable_description_bodystatement));
        } else if (GETTERBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldname));
        } else if (SETTERBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldname));
            this.addResolver(new CodeTemplateVariableResolver(PARAM, JavaManipulationMessages.CodeTemplateContextType_variable_description_param));
        } else if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_typename));
            this.addResolver(new CodeTemplateVariableResolver(PACKAGE_DECLARATION, JavaManipulationMessages.CodeTemplateContextType_variable_description_packdeclaration));
            this.addResolver(new CodeTemplateVariableResolver(TYPE_DECLARATION, JavaManipulationMessages.CodeTemplateContextType_variable_description_typedeclaration));
            this.addResolver(new CodeTemplateVariableResolver(TYPE_COMMENT, JavaManipulationMessages.CodeTemplateContextType_variable_description_typecomment));
            this.addResolver(new CodeTemplateVariableResolver(FILE_COMMENT, JavaManipulationMessages.CodeTemplateContextType_variable_description_filecomment));
            this.addCompilationUnitVariables();
        } else if (CLASSBODY_CONTEXTTYPE.equals(contextName) || INTERFACEBODY_CONTEXTTYPE.equals(contextName) || ENUMBODY_CONTEXTTYPE.equals(contextName) || ANNOTATIONBODY_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_typename));
            this.addCompilationUnitVariables();
        } else if (TYPECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_typename));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (FILECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(TYPENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_typename));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (FIELDCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_fieldtype));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaManipulationMessages.CodeTemplateContextType_variable_description_fieldname));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (METHODCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(RETURN_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_returntype));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (OVERRIDECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(SEE_TO_OVERRIDDEN_TAG, JavaManipulationMessages.CodeTemplateContextType_variable_description_see_overridden_tag));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (DELEGATECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(SEE_TO_TARGET_TAG, JavaManipulationMessages.CodeTemplateContextType_variable_description_see_target_tag));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (CONSTRUCTORCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new TagsVariableResolver());
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (GETTERCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldtype));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldname));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(BARE_FIELD_NAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_barefieldname));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        } else if (SETTERCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingtype));
            this.addResolver(new CodeTemplateVariableResolver(FIELD_TYPE, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldtype));
            this.addResolver(new CodeTemplateVariableResolver(FIELD, JavaManipulationMessages.CodeTemplateContextType_variable_description_getterfieldname));
            this.addResolver(new CodeTemplateVariableResolver(ENCLOSING_METHOD, JavaManipulationMessages.CodeTemplateContextType_variable_description_enclosingmethod));
            this.addResolver(new CodeTemplateVariableResolver(PARAM, JavaManipulationMessages.CodeTemplateContextType_variable_description_param));
            this.addResolver(new CodeTemplateVariableResolver(BARE_FIELD_NAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_barefieldname));
            this.addCompilationUnitVariables();
            this.fIsComment = true;
        }
    }

    private void addCompilationUnitVariables() {
        this.addResolver(new CodeTemplateVariableResolver(FILENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_filename));
        this.addResolver(new CodeTemplateVariableResolver(PACKAGENAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_packagename));
        this.addResolver(new CodeTemplateVariableResolver(PROJECTNAME, JavaManipulationMessages.CodeTemplateContextType_variable_description_projectname));
    }

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        ArrayList<String> required = new ArrayList<String>(5);
        String contextName = this.getId();
        if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            required.add(PACKAGE_DECLARATION);
            required.add(TYPE_DECLARATION);
        }
        int i = 0;
        while (i < variables.length) {
            String type = variables[i].getType();
            if (this.getResolver(type) == null) {
                String unknown = BasicElementLabels.getJavaElementName(type);
                throw new TemplateException(Messages.format(JavaManipulationMessages.CodeTemplateContextType_validate_unknownvariable, unknown));
            }
            required.remove(type);
            ++i;
        }
        if (!required.isEmpty()) {
            String missing = BasicElementLabels.getJavaElementName((String)required.get(0));
            throw new TemplateException(Messages.format(JavaManipulationMessages.CodeTemplateContextType_validate_missingvariable, missing));
        }
        super.validateVariables(variables);
    }

    public TemplateContext createContext() {
        return null;
    }

    public static void registerContextTypes(ContextTypeRegistry registry) {
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CATCHBLOCK_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(METHODBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CONSTRUCTORBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(GETTERBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(SETTERBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(NEWTYPE_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CLASSBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(INTERFACEBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(ENUMBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(ANNOTATIONBODY_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(FILECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(TYPECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(FIELDCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(METHODCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(CONSTRUCTORCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(OVERRIDECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(DELEGATECOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(GETTERCOMMENT_CONTEXTTYPE));
        registry.addContextType((TemplateContextType)new CodeTemplateContextType(SETTERCOMMENT_CONTEXTTYPE));
    }

    public void validate(String pattern) throws TemplateException {
        super.validate(pattern);
        if (this.fIsComment && !this.isValidComment(pattern)) {
            throw new TemplateException(JavaManipulationMessages.CodeTemplateContextType_validate_invalidcomment);
        }
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static class CodeTemplateVariableResolver
    extends TemplateVariableResolver {
        public CodeTemplateVariableResolver(String type, String description) {
            super(type, description);
        }

        protected String resolve(TemplateContext context) {
            return context.getVariable(this.getType());
        }
    }

    public static class TagsVariableResolver
    extends TemplateVariableResolver {
        public TagsVariableResolver() {
            super(CodeTemplateContextType.TAGS, JavaManipulationMessages.CodeTemplateContextType_variable_description_tags);
        }

        protected String resolve(TemplateContext context) {
            return "@";
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaManipulationMessages.CodeTemplateContextType_variable_description_todo);
        }

        protected String resolve(TemplateContext context) {
            String todoTaskTag = StubUtility.getTodoTaskTag(((CodeTemplateContext)context).getJavaProject());
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

