/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.aspects.swt.rap;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IAssertSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IBasicSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.IExtendedSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.swt.rap.ISkipAwareEventListener;
import org.eclipse.rcptt.tesla.ui.RWTUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class SWTEventManager {
    public static final int EVENT_TAB_RESTORE = 0;
    public static final int EVENT_TAB_MINIMIZE = 1;
    public static final int EVENT_TAB_MAXIMIZE = 2;
    public static final int EVENT_TAB_SHOW_LIST = 3;
    private static Set<IAbstractSWTEventListener> listeners = new HashSet<IAbstractSWTEventListener>();
    private static boolean freezeState;
    private static Shell[] ignoreFreeze;
    private static List<WeakReference<CCombo>> comboList;
    private static boolean shouldProceed;
    private static Map<Widget, Object> menuSources;

    static {
        comboList = new ArrayList<WeakReference<CCombo>>();
        shouldProceed = false;
        menuSources = Collections.synchronizedMap(new WeakHashMap());
    }

    private SWTEventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(IAbstractSWTEventListener listener) {
        Set<IAbstractSWTEventListener> set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(IAbstractSWTEventListener listener) {
        Set<IAbstractSWTEventListener> set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<T> getListeners(Class<T> clazz$) {
        HashSet<T> result = new HashSet<T>();
        Set<IAbstractSWTEventListener> set = listeners;
        synchronized (set) {
            for (IAbstractSWTEventListener eventListener : listeners) {
                if (!clazz$.isInstance(eventListener)) continue;
                result.add(clazz$.cast(eventListener));
            }
        }
        return result;
    }

    public static boolean needProceedEvents() {
        Set<IExtendedSWTEventListener> set = SWTEventManager.getListeners(IExtendedSWTEventListener.class);
        for (IExtendedSWTEventListener l : set) {
            if (!l.needProceedEvent()) continue;
            return true;
        }
        return false;
    }

    public static void setCurrentEvent(Event event) {
        for (IExtendedSWTEventListener listener : SWTEventManager.getListeners(IExtendedSWTEventListener.class)) {
            listener.setCurrentEvent(event);
        }
    }

    public static boolean skipEvent(Widget widget, int type, Event event, boolean send) {
        for (ISkipAwareEventListener listener : SWTEventManager.getListeners(ISkipAwareEventListener.class)) {
            if (!listener.isSkipEvent(widget, type, event, send)) continue;
            return true;
        }
        return false;
    }

    public static void recordEvent(Widget widget, int type, Event event) {
        Set<IBasicSWTEventListener> listeners = SWTEventManager.getListeners(IBasicSWTEventListener.class);
        IBasicSWTEventListener exclusive = null;
        for (IBasicSWTEventListener listener : listeners) {
            if (!listener.isExclusiveEventHandle(widget, type, event)) continue;
            if (exclusive == null) {
                exclusive = listener;
                continue;
            }
            throw new RuntimeException("Recording processors collision: " + listener.getClass().getName() + " and " + exclusive.getClass().getName() + " both want to handle event exclusive.");
        }
        if (exclusive != null) {
            exclusive.recordEvent(widget, type, event);
        } else {
            for (IBasicSWTEventListener listener : listeners) {
                listener.recordEvent(widget, type, event);
            }
        }
    }

    public static void recordDragEvent(Event event) {
        for (IExtendedSWTEventListener listener : SWTEventManager.getListeners(IExtendedSWTEventListener.class)) {
            listener.recordDragEvent(event);
        }
    }

    public static void recordSWTDialog(Dialog dialog, Object result) {
        for (IExtendedSWTEventListener listener : SWTEventManager.getListeners(IExtendedSWTEventListener.class)) {
            listener.recordSWTDialog(dialog, result);
        }
    }

    public static void recordRapDownload(String handler, String url, String content) {
        for (IExtendedSWTEventListener listener : SWTEventManager.getListeners(IExtendedSWTEventListener.class)) {
            listener.recordRapDownloadHandler(handler, url, content);
        }
    }

    public static void setFreeze(final boolean value) {
        freezeState = value;
        RWTUtils.findDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class)).execute("rwt.client.rcptt.Assertion.getInstance().setActive(" + (value ? "true" : "false") + ");");
            }
        });
    }

    public static boolean isFreeze(Widget widget, int type, Event event) {
        if (freezeState) {
            if (ignoreFreeze != null) {
                if (widget instanceof Control) {
                    Shell shell = ((Control)widget).getShell();
                    int i = 0;
                    while (i < ignoreFreeze.length) {
                        if (ignoreFreeze[i].equals(shell)) {
                            return false;
                        }
                        ++i;
                    }
                } else if (widget instanceof ToolItem) {
                    Shell shell = ((ToolItem)widget).getParent().getShell();
                    int i = 0;
                    while (i < ignoreFreeze.length) {
                        if (ignoreFreeze[i].equals(shell)) {
                            return false;
                        }
                        ++i;
                    }
                } else if (widget instanceof ScrollBar) {
                    Shell shell = ((ScrollBar)widget).getParent().getShell();
                    int i = 0;
                    while (i < ignoreFreeze.length) {
                        if (ignoreFreeze[i].equals(shell)) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void setIgnoreFreeze(Shell[] ignored) {
        ignoreFreeze = ignored;
    }

    public static boolean handleEventInFreeze(Widget widget, int type, Event event) {
        boolean finalResult = false;
        for (IAssertSWTEventListener listener : SWTEventManager.getListeners(IAssertSWTEventListener.class)) {
            boolean bl = finalResult = finalResult || listener.handleEventInFreeze(widget, type, event);
        }
        return finalResult;
    }

    public static void handleUpdateHover(Control widget) {
        for (IAssertSWTEventListener listener : SWTEventManager.getListeners(IAssertSWTEventListener.class)) {
            listener.handleUpdateHover(widget);
        }
    }

    public static void recordCombo(CCombo combo) {
        comboList.add(new WeakReference<CCombo>(combo));
        if (comboList.size() > 1) {
            SWTEventManager.cleanCombos();
        }
    }

    public static CCombo[] getCombo() {
        SWTEventManager.cleanCombos();
        ArrayList<CCombo> result = new ArrayList<CCombo>();
        for (WeakReference<CCombo> cc : comboList) {
            CCombo ccg;
            if (cc == null || (ccg = (CCombo)cc.get()) == null || ccg.isDisposed()) continue;
            result.add(ccg);
        }
        return result.toArray(new CCombo[result.size()]);
    }

    private static void cleanCombos() {
        ArrayList<WeakReference<CCombo>> toRemove = new ArrayList<WeakReference<CCombo>>();
        for (WeakReference<CCombo> cc : comboList) {
            CCombo ccg = (CCombo)cc.get();
            if (ccg != null && !ccg.isDisposed()) continue;
            toRemove.add(cc);
        }
        comboList.removeAll(toRemove);
    }

    public static void recordTabFolderEvent(Control tabControl, int eventId) {
        for (IExtendedSWTEventListener listener : SWTEventManager.getListeners(IExtendedSWTEventListener.class)) {
            listener.recordTabFolderEvent(tabControl, eventId);
        }
    }

    public static boolean getFreeze() {
        return freezeState;
    }

    public static boolean isShouldProceed(Widget widget, int type) {
        return shouldProceed;
    }

    public static void setShouldProceed(boolean shouldProceess) {
        shouldProceed = shouldProceess;
    }

    public static void setMenuSource(Menu menu, Object source) {
        if (menu != null && source != null) {
            menuSources.put((Widget)menu, source);
        }
    }

    public static Object getMenuSource(Widget menu) {
        return menuSources.get(menu);
    }

    public static void cleanMenuSources() {
        HashSet<Widget> keysToRemove = new HashSet<Widget>();
        for (Map.Entry<Widget, Object> entry : menuSources.entrySet()) {
            if (!(entry.getValue() instanceof Widget) || !entry.getKey().isDisposed() && !((Widget)entry.getValue()).isDisposed()) continue;
            keysToRemove.add(entry.getKey());
        }
        for (Widget w : keysToRemove) {
            menuSources.remove(w);
        }
    }
}

