/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;

public class RefContentProposal
implements IContentProposal {
    private static final String[] PREFIXES = new String[]{"refs/heads/", "refs/remotes/", "refs/tags/"};
    private static final String branchPF = " [" + UIText.RefContentProposal_branch + "]";
    private static final String trackingBranchPF = " [" + UIText.RefContentProposal_trackingBranch + "]";
    private static final String tagPF = " [" + UIText.RefContentProposal_tag + "]";
    private static final String[] PREFIXES_DESCRIPTIONS = new String[]{branchPF, trackingBranchPF, tagPF};
    private final Repository db;
    private final String refName;
    private final ObjectId objectId;
    private final boolean upstream;

    private static void appendObjectSummary(StringBuilder sb, String type, PersonIdent author, String message) {
        sb.append(type);
        if (author != null) {
            sb.append(" ");
            sb.append(UIText.RefContentProposal_by);
            sb.append(" ");
            sb.append(author.getName());
            sb.append("\n");
            sb.append(author.getWhen());
        }
        sb.append("\n\n");
        int newLine = message.indexOf(10);
        int last = newLine != -1 ? newLine : message.length();
        sb.append(message.substring(0, last));
    }

    public RefContentProposal(Repository repo, Ref ref, boolean upstream) {
        this(repo, ref.getName(), ref.getObjectId(), upstream);
    }

    public RefContentProposal(Repository repo, String refName, ObjectId objectId, boolean upstream) {
        this.db = repo;
        this.refName = refName;
        this.objectId = objectId;
        this.upstream = upstream;
    }

    public String getContent() {
        return this.refName;
    }

    public int getCursorPosition() {
        return this.refName.length();
    }

    public String getDescription() {
        if (this.objectId == null) {
            return null;
        }
        if (this.upstream && this.objectId.equals((AnyObjectId)ObjectId.zeroId())) {
            return String.valueOf(this.refName) + '\n' + UIText.RefContentProposal_newRemoteObject;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ObjectReader reader = this.db.newObjectReader();
                ObjectLoader loader = null;
                try {
                    loader = reader.open((AnyObjectId)this.objectId);
                }
                catch (MissingObjectException e) {
                    if (this.upstream) {
                        String string = String.valueOf(this.refName) + '\n' + this.objectId.abbreviate(7).name() + " - " + UIText.RefContentProposal_unknownRemoteObject;
                        if (reader != null) {
                            reader.close();
                        }
                        return string;
                    }
                    throw e;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.refName);
                sb.append('\n');
                sb.append(reader.abbreviate((AnyObjectId)this.objectId).name());
                sb.append(" - ");
                switch (loader.getType()) {
                    case 1: {
                        Throwable throwable2 = null;
                        Object var7_14 = null;
                        try (RevWalk rw = new RevWalk(this.db);){
                            RevCommit c = rw.parseCommit((AnyObjectId)this.objectId);
                            RefContentProposal.appendObjectSummary(sb, UIText.RefContentProposal_commit, c.getAuthorIdent(), c.getFullMessage());
                            break;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    case 4: {
                        Throwable throwable4 = null;
                        Object var7_16 = null;
                        try (RevWalk rw = new RevWalk(this.db);){
                            RevTag t = rw.parseTag((AnyObjectId)this.objectId);
                            RefContentProposal.appendObjectSummary(sb, UIText.RefContentProposal_tag, t.getTaggerIdent(), t.getFullMessage());
                            break;
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    case 2: {
                        sb.append(UIText.RefContentProposal_tree);
                        break;
                    }
                    case 3: {
                        sb.append(UIText.RefContentProposal_blob);
                        break;
                    }
                    default: {
                        sb.append(UIText.RefContentProposal_unknownObject);
                    }
                }
                try {
                    return sb.toString();
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.RefContentProposal_errorReadingObject, (Object)this.objectId, (Object)this.refName), e);
            return null;
        }
    }

    public String getLabel() {
        int i = 0;
        while (i < PREFIXES.length) {
            if (this.refName.startsWith(PREFIXES[i])) {
                return String.valueOf(this.refName.substring(PREFIXES[i].length())) + PREFIXES_DESCRIPTIONS[i];
            }
            ++i;
        }
        return this.refName;
    }
}

