/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.internal.resources;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.ui.WSSearchSwitch;
import org.eclipse.rcptt.ui.search.Matcher;
import org.eclipse.rcptt.workspace.WorkspaceContext;

public class WorkspaceContextMatcher
implements Matcher {
    public boolean matches(IQ7NamedElement object, String query, SubMonitor monitor) {
        if (!(object instanceof IContext)) {
            return false;
        }
        String type = Q7SearchCore.findContextTypeByDocument((IContext)((IContext)object));
        if (type == null && object instanceof IContext) {
            try {
                type = ((IContext)object).getType().getId();
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        if (type != null && !type.equals("org.eclipse.rcptt.ctx.workspace")) {
            return false;
        }
        try {
            NamedElement ctx = object.getNamedElement();
            if (ctx instanceof WorkspaceContext) {
                WorkspaceContext context = (WorkspaceContext)ctx;
                WSSearchSwitch sw = new WSSearchSwitch(query, (IProgressMonitor)monitor);
                try {
                    return (Boolean)sw.doSwitch((EObject)context.getContent());
                }
                catch (OperationCanceledException operationCanceledException) {
                    return false;
                }
            }
            return false;
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return false;
        }
    }
}

