/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.text.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.tesla.core.ui.TextPosition;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.JFaceTextEventManager;
import org.eclipse.rcptt.verifications.runtime.ErrorList;
import org.eclipse.rcptt.verifications.text.TextFactory;
import org.eclipse.rcptt.verifications.text.TextVerification;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Widget;

public class TextVerificationProcessor
extends VerificationProcessor {
    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        final TextVerification textVerification = (TextVerification)EcoreUtil.copy((EObject)((TextVerification)verification));
        final SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)textVerification.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final ErrorList errors = new ErrorList();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String actualText;
                String expectedText = textVerification.getText();
                if (expectedText == null) {
                    expectedText = "";
                }
                if (widget instanceof StyledText) {
                    TextVerificationProcessor.unfold((StyledText)widget);
                }
                if ((actualText = PlayerTextUtils.getTextForVerification((SWTUIElement)swtuiElement)) == null) {
                    actualText = "";
                }
                if (!actualText.equals(expectedText)) {
                    errors.add("Expected text is \"%s\", but it was \"%s\".", new Object[]{expectedText, actualText});
                }
                EList expectedStyleEntries = textVerification.getStyles();
                PlayerTextUtils.squashRanges((List)expectedStyleEntries);
                if (expectedStyleEntries.size() > 0 && !textVerification.isIgnoreStyling()) {
                    if (!(widget instanceof StyledText)) {
                        errors.add("Expected StyledText widget, got %s.", new Object[]{widget.getClass().getName()});
                    } else {
                        StyledText styledText = (StyledText)widget;
                        List actualStyleEntries = PlayerTextUtils.captureStyleRanges((StyledText)styledText);
                        PlayerTextUtils.squashRanges((List)actualStyleEntries);
                        boolean failed = false;
                        int i = 0;
                        while (i < Math.min(expectedStyleEntries.size(), actualStyleEntries.size())) {
                            StyleRangeEntry actual;
                            StyleRangeEntry expected = (StyleRangeEntry)expectedStyleEntries.get(i);
                            if (!EcoreUtil.equals((EObject)expected, (EObject)(actual = (StyleRangeEntry)actualStyleEntries.get(i)))) {
                                errors.add("Difference in text styling found at %s.", new Object[]{TextVerificationProcessor.posToString(TextVerificationProcessor.earliestPos(expected.getStartPos(), actual.getStartPos()))});
                                failed = true;
                                break;
                            }
                            ++i;
                        }
                        if (!failed && expectedStyleEntries.size() != actualStyleEntries.size()) {
                            if (actualStyleEntries.size() > expectedStyleEntries.size()) {
                                errors.add("Difference in text styling found at %s.", new Object[]{TextVerificationProcessor.posToString(((StyleRangeEntry)actualStyleEntries.get(expectedStyleEntries.size())).getStartPos())});
                            } else {
                                errors.add("Difference in text styling found at %s.", new Object[]{TextVerificationProcessor.posToString(((StyleRangeEntry)actualStyleEntries.get(actualStyleEntries.size() - 1)).getStartPos())});
                            }
                        }
                    }
                }
            }
        });
        errors.throwIfAny(String.format("Widget text verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        final TextVerification p = (TextVerification)param;
        final SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)p.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final TextVerification result = TextFactory.eINSTANCE.createTextVerification();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.setSelector(p.getSelector());
                result.setText(PlayerTextUtils.getTextForVerification((SWTUIElement)swtuiElement));
                if (widget instanceof StyledText) {
                    StyledText styledText = (StyledText)widget;
                    if (TextVerificationProcessor.unfold(styledText)) {
                        result.setText(PlayerTextUtils.getTextForVerification((SWTUIElement)swtuiElement));
                    }
                    List captured = PlayerTextUtils.captureStyleRanges((StyledText)styledText);
                    PlayerTextUtils.squashRanges((List)captured);
                    result.getStyles().addAll((Collection)captured);
                    result.setIgnoreStyling(result.getStyles().size() > 0 ? p.isIgnoreStyling() : true);
                } else {
                    result.setIgnoreStyling(true);
                }
            }
        });
        return result;
    }

    private static boolean unfold(StyledText styledText) {
        TextViewer viewer = JFaceTextEventManager.getViewer((StyledText)styledText);
        if (viewer != null && viewer instanceof SourceViewer) {
            viewer.doOperation(20);
            AbstractReconciler reconciler = (AbstractReconciler)TeslaSWTAccess.getField(AbstractReconciler.class, (Object)viewer, (String)"fReconciler");
            if (reconciler != null) {
                TeslaSWTAccess.call((Object)reconciler, (String)"forceReconciling", (Object[])new Object[0]);
                Object thread = TeslaSWTAccess.getField(Object.class, (Object)reconciler, (String)"fThread");
                if (thread != null) {
                    TeslaSWTAccess.call((Object)thread, (String)"suspendCallerWhileDirty", (Object[])new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    private static TextPosition earliestPos(TextPosition a, TextPosition b) {
        if (a.getLine() < b.getLine()) {
            return a;
        }
        if (a.getLine() > b.getLine()) {
            return b;
        }
        if (a.getColumn() < b.getColumn()) {
            return a;
        }
        return b;
    }

    private static String posToString(TextPosition p) {
        return String.format("line %s column %s", p.getLine(), p.getColumn());
    }
}

