/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class WorkingSetScope
extends AbstractSynchronizeScope
implements IPropertyChangeListener {
    private static final String CTX_SETS = "workingset_scope_sets";
    private static final String CTX_SET_NAME = "workingset_scope_name";
    private IWorkingSet[] sets;

    public WorkingSetScope(IWorkingSet[] sets) {
        this.setWorkingSets(sets);
    }

    protected WorkingSetScope(IMemento memento) {
        super(memento);
    }

    protected void setWorkingSets(IWorkingSet[] sets) {
        this.sets = sets;
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public String getName() {
        if (this.sets.length == 0) {
            return TeamUIMessages.WorkingSetScope_0;
        }
        StringBuffer name = new StringBuffer();
        int i = 0;
        while (i < this.sets.length) {
            IWorkingSet set = this.sets[i];
            name.append(set.getName());
            if (i < this.sets.length - 1) {
                name.append(", ");
            }
            ++i;
        }
        return name.toString();
    }

    @Override
    public IResource[] getRoots() {
        if (this.sets.length == 0) {
            return null;
        }
        HashSet roots = new HashSet();
        int i = 0;
        while (i < this.sets.length) {
            IWorkingSet set = this.sets[i];
            IResource[] resources = Utils.getResources(set.getElements());
            this.addNonOverlapping(roots, resources);
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private void addNonOverlapping(HashSet roots, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource newResource = resources[i];
            boolean add = true;
            Iterator iter = roots.iterator();
            while (iter.hasNext()) {
                IResource existingResource = (IResource)iter.next();
                if (existingResource.equals((Object)newResource)) {
                    add = false;
                    break;
                }
                if (existingResource.getFullPath().isPrefixOf(newResource.getFullPath())) {
                    add = false;
                    break;
                }
                if (!newResource.getFullPath().isPrefixOf(existingResource.getFullPath())) continue;
                iter.remove();
            }
            if (add) {
                roots.add(newResource);
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "workingSetContentChange") {
            IWorkingSet newSet = (IWorkingSet)event.getNewValue();
            int i = 0;
            while (i < this.sets.length) {
                IWorkingSet set = this.sets[i];
                if (newSet == set) {
                    this.fireRootsChanges();
                    return;
                }
                ++i;
            }
        } else if (event.getProperty() == "workingSetNameChange") {
            this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "prop_name", null, event.getNewValue()));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        int i = 0;
        while (i < this.sets.length) {
            IWorkingSet set = this.sets[i];
            IMemento rootNode = memento.createChild(CTX_SETS);
            rootNode.putString(CTX_SET_NAME, set.getName());
            ++i;
        }
    }

    @Override
    protected void init(IMemento memento) {
        super.init(memento);
        IMemento[] rootNodes = memento.getChildren(CTX_SETS);
        if (rootNodes != null) {
            ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
            int i = 0;
            while (i < rootNodes.length) {
                IMemento rootNode = rootNodes[i];
                String setName = rootNode.getString(CTX_SET_NAME);
                IWorkingSet set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setName);
                if (set != null) {
                    sets.add(set);
                }
                ++i;
            }
            this.setWorkingSets(sets.toArray(new IWorkingSet[sets.size()]));
        }
    }
}

