/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;

public class PDEMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        return !candidate.getAttribute("append.args", false) || candidate.hasAttribute("vminstall");
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        this.migrate(wc);
        wc.doSave();
    }

    public void migrate(ILaunchConfigurationWorkingCopy candidate) throws CoreException {
        if (!candidate.getAttribute("append.args", false)) {
            candidate.setAttribute("append.args", true);
            String args = candidate.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialProgramArguments());
            if (args.length() > 0) {
                buffer.append(" ");
                buffer.append(args);
            }
            candidate.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, buffer.toString());
        }
        if (candidate.hasAttribute("vminstall")) {
            IVMInstall vm;
            String name = candidate.getAttribute("vminstall", null);
            if (name != null && (vm = VMHelper.getVMInstall(name)) != null) {
                IPath path = JavaRuntime.newJREContainerPath((IVMInstall)vm);
                candidate.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            candidate.removeAttribute("vminstall");
        }
    }
}

