/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;

public final class RenameCompilationUnitProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaElementMapper {
    private RenameTypeProcessor fRenameTypeProcessor = null;
    private boolean fWillRenameType = false;
    private ICompilationUnit fCu;

    public RenameCompilationUnitProcessor(ICompilationUnit unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public RenameCompilationUnitProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameCompilationUnitProcessor";
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameCompilationUnitRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fCu);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    @Override
    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameTypeProcessor != null) {
            String newTypeName = RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName());
            RenameTypeArguments arguments = new RenameTypeArguments(newTypeName, this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
            result.rename(this.fRenameTypeProcessor.getType(), arguments, this.getUpdateSimilarDeclarations() ? new RenameTypeProcessor.ParticipantDescriptorFilter() : null);
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        IFile file;
        if (!this.fWillRenameType && (file = ResourceUtil.getFile(this.fCu)) != null) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }

    @Override
    public int getSaveMode() {
        return 4;
    }

    @Override
    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    @Override
    public String getCurrentElementQualifier() {
        IPackageFragment pack = (IPackageFragment)this.fCu.getParent();
        return pack.getElementName();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        String typeName = RenameCompilationUnitProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkCompilationUnitName(newName, (IJavaElement)this.fCu);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameCompilationUnitRefactoring_same_name);
        }
        return result;
    }

    @Override
    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(newName));
        }
    }

    @Override
    public Object getNewElement() {
        IPackageFragment pack = (IPackageFragment)this.fCu.getParent();
        if (JavaConventionsUtil.validateCompilationUnitName(this.getNewElementName(), (IJavaElement)pack).getSeverity() == 4) {
            return null;
        }
        return pack.getCompilationUnit(this.getNewElementName());
    }

    @Override
    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableTextUpdating();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(update);
        }
    }

    @Override
    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    @Override
    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    @Override
    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    @Override
    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    @Override
    public boolean canEnableSimilarDeclarationUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableSimilarDeclarationUpdating();
    }

    @Override
    public void setUpdateSimilarDeclarations(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateSimilarDeclarations(update);
    }

    @Override
    public boolean getUpdateSimilarDeclarations() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateSimilarDeclarations();
    }

    @Override
    public int getMatchStrategy() {
        if (this.fRenameTypeProcessor == null) {
            return 1;
        }
        return this.fRenameTypeProcessor.getMatchStrategy();
    }

    @Override
    public void setMatchStrategy(int selectedStrategy) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setMatchStrategy(selectedStrategy);
    }

    public IJavaElement[] getSimilarElements() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getSimilarElements();
    }

    public IResource getRefactoredResource(IResource element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredResource(element);
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredJavaElement(element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                RefactoringStatus result1 = new RefactoringStatus();
                RefactoringStatus result2 = new RefactoringStatus();
                result2.merge(Checks.checkCompilationUnitNewName(this.fCu, RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName())));
                if (result2.hasFatalError()) {
                    result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed_1, BasicElementLabels.getFileName((ITypeRoot)this.fCu)));
                } else {
                    result1.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed, BasicElementLabels.getFileName((ITypeRoot)this.fCu)));
                }
                result1.merge(result2);
            }
            if (this.fWillRenameType) {
                RefactoringStatus refactoringStatus = this.fRenameTypeProcessor.checkFinalConditions(pm, context);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName()));
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        this.fRenameTypeProcessor = type != null ? new RenameTypeProcessor(type) : null;
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        this.fRenameTypeProcessor = null;
        String newName = this.getNewElementName();
        IResource resource = this.fCu.getResource();
        if (resource != null && resource.isLinked()) {
            IProject project = resource.getProject();
            String name = project.getName();
            String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, BasicElementLabels.getResourceName((String)resource.getName()));
            String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false), BasicElementLabels.getResourceName((String)resource.getName())});
            String comment = new JDTRefactoringDescriptorComment(name, this, header).asString();
            RenameResourceDescriptor descriptor = (RenameResourceDescriptor)RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.rename.resource").createDescriptor();
            descriptor.setProject(name);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(2);
            descriptor.setResourcePath(resource.getFullPath());
            descriptor.setNewName(newName);
            RenameResourceChange resourceChange = new RenameResourceChange(resource.getFullPath(), newName);
            resourceChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            return new DynamicValidationStateChange((Change)resourceChange);
        }
        String label = JavaElementLabels.getTextLabel(this.fCu, JavaElementLabels.ALL_FULLY_QUALIFIED);
        String name = this.fCu.getJavaProject().getElementName();
        String description = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, BasicElementLabels.getFileName((ITypeRoot)this.fCu));
        String header = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{label, BasicElementLabels.getResourceName((String)newName)});
        String comment = new JDTRefactoringDescriptorComment(name, this, header).asString();
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.compilationunit");
        descriptor.setProject(name);
        descriptor.setDescription(description);
        descriptor.setComment(comment);
        descriptor.setFlags(2);
        descriptor.setJavaElement((IJavaElement)this.fCu);
        descriptor.setNewName(newName);
        return new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameCompilationUnitRefactoring_name, new Change[]{new RenameCompilationUnitChange(this.fCu, newName)});
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(participantChanges, pm);
        }
        return super.postCreateChange(participantChanges, pm);
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String handle = extended.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.compilationunit");
        }
        String name = extended.getAttribute("name");
        if (name == null || name.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fCu = (ICompilationUnit)element;
        try {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(name);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.compilationunit");
        }
        return new RefactoringStatus();
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        return this.fRenameTypeProcessor;
    }

    public boolean isWillRenameType() {
        return this.fWillRenameType;
    }
}

