/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

class GitSyncInfo
extends SyncInfo {
    private final GitSyncObjectCache cache;
    private final Repository repo;

    public GitSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator, GitSyncObjectCache cache, Repository repo) {
        super(local, base, remote, comparator);
        this.repo = repo;
        this.cache = cache;
    }

    protected int calculateKind() throws TeamException {
        String path;
        if (this.cache.membersCount() == 0) {
            return 0;
        }
        if (this.getLocal() != null && this.getLocal().getLocation() != null) {
            path = Repository.stripWorkDir((File)this.repo.getWorkTree(), (File)this.getLocal().getLocation().toFile());
        } else if (this.getRemote() != null) {
            path = ((GitRemoteResource)this.getRemote()).getPath();
        } else if (this.getBase() != null) {
            path = ((GitRemoteResource)this.getBase()).getPath();
        } else {
            return 0;
        }
        GitSyncObjectCache obj = this.cache.get(path);
        if (obj == null) {
            return 0;
        }
        if (obj.getDiffEntry().isTree() && !this.hasNonSyncFile(obj)) {
            return 0;
        }
        ThreeWayDiffEntry.Direction gitDirection = obj.getDiffEntry().getDirection();
        int direction = gitDirection == ThreeWayDiffEntry.Direction.INCOMING ? 8 : (gitDirection == ThreeWayDiffEntry.Direction.OUTGOING ? 4 : 12);
        ThreeWayDiffEntry.ChangeType changeType = obj.getDiffEntry().getChangeType();
        if (changeType == ThreeWayDiffEntry.ChangeType.MODIFY) {
            return direction | 3;
        }
        if (changeType == ThreeWayDiffEntry.ChangeType.ADD) {
            return direction | 1;
        }
        if (changeType == ThreeWayDiffEntry.ChangeType.DELETE) {
            return direction | 2;
        }
        return 0;
    }

    private boolean hasNonSyncFile(GitSyncObjectCache obj) {
        Collection<GitSyncObjectCache> children = obj.members();
        if (children == null) {
            return false;
        }
        for (GitSyncObjectCache child : children) {
            if (child.getDiffEntry().isTree() || child.getDiffEntry().getChangeType() == ThreeWayDiffEntry.ChangeType.IN_SYNC) continue;
            return true;
        }
        for (GitSyncObjectCache child : children) {
            if (!child.getDiffEntry().isTree() || !this.hasNonSyncFile(child)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

