/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractivePreferences;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class RebaseInteractiveStepActionToolBarProvider {
    private static final int[] MOVE_ACCELERATORS = new int[]{SWT.MOD1 + 0x1000001, SWT.MOD1 + 0x1000002};
    private ToolItem itemMoveUp;
    private ToolItem itemMoveDown;
    private final Map<RebaseInteractivePlan.ElementAction, ToolItem> rebaseActionItems = new EnumMap<RebaseInteractivePlan.ElementAction, ToolItem>(RebaseInteractivePlan.ElementAction.class);
    private final Map<RebaseInteractivePlan.ElementAction, Integer> accelerators = new EnumMap<RebaseInteractivePlan.ElementAction, Integer>(RebaseInteractivePlan.ElementAction.class);
    private final RebaseInteractiveView view;
    private final ToolBar theToolbar;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

    final ToolBar getTheToolbar() {
        return this.theToolbar;
    }

    public RebaseInteractiveStepActionToolBarProvider(Composite parent, int style, RebaseInteractiveView view) {
        this.accelerators.put(RebaseInteractivePlan.ElementAction.EDIT, 69);
        this.accelerators.put(RebaseInteractivePlan.ElementAction.FIXUP, 70);
        this.accelerators.put(RebaseInteractivePlan.ElementAction.PICK, 80);
        this.accelerators.put(RebaseInteractivePlan.ElementAction.REWORD, 82);
        this.accelerators.put(RebaseInteractivePlan.ElementAction.SKIP, 127);
        this.accelerators.put(RebaseInteractivePlan.ElementAction.SQUASH, 83);
        this.theToolbar = new ToolBar(parent, style);
        this.view = view;
        this.createToolBarItems();
        this.theToolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RebaseInteractiveStepActionToolBarProvider.this.dispose();
            }
        });
    }

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    private void dispose() {
        this.resources.dispose();
    }

    private String textFor(RebaseInteractivePlan.ElementAction action, String base) {
        int accelerator = this.getActionAccelerators().get(action);
        return String.valueOf(base) + " (" + SWTKeySupport.getKeyFormatterForPlatform().format(SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator)) + ')';
    }

    private String textFor(int idx, String base) {
        int accelerator = MOVE_ACCELERATORS[idx];
        return String.valueOf(base) + " (" + SWTKeySupport.getKeyFormatterForPlatform().format(SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator)) + ')';
    }

    private void createToolBarItems() {
        ToolItem itemPick = new ToolItem(this.theToolbar, 16);
        itemPick.setImage(this.getImage(UIIcons.CHERRY_PICK));
        itemPick.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.PICK));
        itemPick.setText(UIText.RebaseInteractiveStepActionToolBarProvider_PickText);
        itemPick.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.PICK, UIText.RebaseInteractiveStepActionToolBarProvider_PickDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.PICK, itemPick);
        ToolItem itemSkip = new ToolItem(this.theToolbar, 16);
        itemSkip.setImage(this.getImage(UIIcons.REBASE_SKIP));
        itemSkip.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SKIP));
        itemSkip.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SkipText);
        itemSkip.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.SKIP, UIText.RebaseInteractiveStepActionToolBarProvider_SkipDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.SKIP, itemSkip);
        ToolItem itemEdit = new ToolItem(this.theToolbar, 16);
        itemEdit.setImage(this.getImage(UIIcons.EDITCONFIG));
        itemEdit.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.EDIT));
        itemEdit.setText(UIText.RebaseInteractiveStepActionToolBarProvider_EditText);
        itemEdit.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.EDIT, UIText.RebaseInteractiveStepActionToolBarProvider_EditDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.EDIT, itemEdit);
        ToolItem itemSquash = new ToolItem(this.theToolbar, 16);
        itemSquash.setImage(this.getImage(UIIcons.SQUASH_UP));
        itemSquash.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SQUASH));
        itemSquash.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SquashText);
        itemSquash.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.SQUASH, UIText.RebaseInteractiveStepActionToolBarProvider_SquashDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.SQUASH, itemSquash);
        ToolItem itemFixup = new ToolItem(this.theToolbar, 16);
        itemFixup.setImage(this.getImage(UIIcons.FIXUP_UP));
        itemFixup.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.FIXUP));
        itemFixup.setText(UIText.RebaseInteractiveStepActionToolBarProvider_FixupText);
        itemFixup.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.FIXUP, UIText.RebaseInteractiveStepActionToolBarProvider_FixupDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.FIXUP, itemFixup);
        ToolItem itemReword = new ToolItem(this.theToolbar, 16);
        itemReword.setImage(this.getImage(UIIcons.REWORD));
        itemReword.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.REWORD));
        itemReword.setText(UIText.RebaseInteractiveStepActionToolBarProvider_RewordText);
        itemReword.setToolTipText(this.textFor(RebaseInteractivePlan.ElementAction.REWORD, UIText.RebaseInteractiveStepActionToolBarProvider_RewordDesc));
        this.rebaseActionItems.put(RebaseInteractivePlan.ElementAction.REWORD, itemReword);
        new ToolItem(this.theToolbar, 2);
        this.itemMoveUp = new ToolItem(this.theToolbar, 0);
        this.itemMoveUp.setImage(this.getImage(UIIcons.ELCL16_PREVIOUS));
        this.itemMoveUp.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveUpText);
        this.itemMoveUp.setToolTipText(this.textFor(0, UIText.RebaseInteractiveStepActionToolBarProvider_MoveUpDesc));
        this.itemMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseInteractiveStepActionToolBarProvider.this.moveUp();
                ((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getControl().setFocus();
            }
        });
        this.itemMoveDown = new ToolItem(this.theToolbar, 0);
        this.itemMoveDown.setImage(this.getImage(UIIcons.ELCL16_NEXT));
        this.itemMoveDown.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveDownText);
        this.itemMoveDown.setToolTipText(this.textFor(1, UIText.RebaseInteractiveStepActionToolBarProvider_MoveDownDesc));
        this.itemMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseInteractiveStepActionToolBarProvider.this.moveDown();
                ((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getControl().setFocus();
            }
        });
    }

    protected List<RebaseInteractivePlan.PlanElement> getSelectedRebaseTodoLines() {
        IStructuredSelection selection = (IStructuredSelection)this.view.planTreeViewer.getSelection();
        ArrayList<RebaseInteractivePlan.PlanElement> planEntries = new ArrayList<RebaseInteractivePlan.PlanElement>(selection.size());
        List candidates = selection.toList();
        for (Object candidate : candidates) {
            if (!(candidate instanceof RebaseInteractivePlan.PlanElement)) continue;
            planEntries.add((RebaseInteractivePlan.PlanElement)candidate);
        }
        return planEntries;
    }

    void mapActionItemsToSelection(ISelection selection) {
        this.setMoveItemsEnabled(false);
        if (selection == null || selection.isEmpty()) {
            if (this.theToolbar.isEnabled()) {
                this.theToolbar.setEnabled(false);
            }
            this.unselectAllActionItemsExecpt(null);
            return;
        }
        if (selection instanceof IStructuredSelection) {
            RebaseInteractivePlan.PlanElement firstSelectedEntry;
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object obj = structured.getFirstElement();
            if (!(obj instanceof RebaseInteractivePlan.PlanElement)) {
                return;
            }
            RebaseInteractivePlan.PlanElement lastSelectedEntry = firstSelectedEntry = (RebaseInteractivePlan.PlanElement)obj;
            RebaseInteractivePlan.ElementAction type = firstSelectedEntry.getPlanElementAction();
            boolean singleTypeSelected = true;
            if (!this.theToolbar.isEnabled() && !this.view.getCurrentPlan().hasRebaseBeenStartedYet()) {
                this.theToolbar.setEnabled(true);
            }
            if (structured.size() > 1) {
                for (Object selectedObj : structured.toList()) {
                    RebaseInteractivePlan.PlanElement entry;
                    if (!(selectedObj instanceof RebaseInteractivePlan.PlanElement)) continue;
                    lastSelectedEntry = entry = (RebaseInteractivePlan.PlanElement)selectedObj;
                    if (type == entry.getPlanElementAction()) continue;
                    singleTypeSelected = false;
                }
            }
            if (singleTypeSelected) {
                this.unselectAllActionItemsExecpt(type);
            } else {
                this.unselectAllActionItemsExecpt(null);
            }
            this.enableMoveButtons(firstSelectedEntry, lastSelectedEntry);
        }
    }

    private void enableMoveButtons(RebaseInteractivePlan.PlanElement firstSelectedEntry, RebaseInteractivePlan.PlanElement lastSelectedEntry) {
        List list = this.view.getCurrentPlan().getList();
        ArrayList<RebaseInteractivePlan.PlanElement> stepList = new ArrayList<RebaseInteractivePlan.PlanElement>();
        for (RebaseInteractivePlan.PlanElement planElement : list) {
            if (planElement.isComment()) continue;
            stepList.add(planElement);
        }
        int firstEntryIndex = stepList.indexOf(firstSelectedEntry);
        int lastEntryIndex = stepList.indexOf(lastSelectedEntry);
        if (!RebaseInteractivePreferences.isOrderReversed()) {
            this.itemMoveUp.setEnabled(firstEntryIndex > 0);
            this.itemMoveDown.setEnabled(lastEntryIndex < stepList.size() - 1);
        } else {
            this.itemMoveUp.setEnabled(firstEntryIndex < stepList.size() - 1);
            this.itemMoveDown.setEnabled(lastEntryIndex > 0);
        }
    }

    private void unselectAllActionItemsExecpt(RebaseInteractivePlan.ElementAction action) {
        for (Map.Entry<RebaseInteractivePlan.ElementAction, ToolItem> entry : this.rebaseActionItems.entrySet()) {
            entry.getValue().setSelection(entry.getKey() == action);
        }
    }

    private void setMoveItemsEnabled(boolean enabled) {
        this.itemMoveDown.setEnabled(enabled);
        this.itemMoveUp.setEnabled(enabled);
    }

    void moveUp() {
        List<RebaseInteractivePlan.PlanElement> selectedRebaseTodoLines = this.getSelectedRebaseTodoLines();
        for (RebaseInteractivePlan.PlanElement planElement : selectedRebaseTodoLines) {
            if (planElement.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                return;
            }
            if (!RebaseInteractivePreferences.isOrderReversed()) {
                this.view.getCurrentPlan().moveTodoEntryUp(planElement);
            } else {
                this.view.getCurrentPlan().moveTodoEntryDown(planElement);
            }
            this.mapActionItemsToSelection(this.view.planTreeViewer.getSelection());
        }
    }

    void moveDown() {
        List<RebaseInteractivePlan.PlanElement> selectedRebaseTodoLines = this.getSelectedRebaseTodoLines();
        Collections.reverse(selectedRebaseTodoLines);
        for (RebaseInteractivePlan.PlanElement planElement : selectedRebaseTodoLines) {
            if (planElement.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                return;
            }
            if (!RebaseInteractivePreferences.isOrderReversed()) {
                this.view.getCurrentPlan().moveTodoEntryDown(planElement);
            } else {
                this.view.getCurrentPlan().moveTodoEntryUp(planElement);
            }
            this.mapActionItemsToSelection(this.view.planTreeViewer.getSelection());
        }
    }

    Map<RebaseInteractivePlan.ElementAction, Integer> getActionAccelerators() {
        return this.accelerators;
    }

    int[] getMoveAccelerators() {
        return MOVE_ACCELERATORS;
    }

    private class ActionSelectionListener
    implements SelectionListener {
        private final RebaseInteractivePlan.ElementAction type;

        ActionSelectionListener(RebaseInteractivePlan.ElementAction action) {
            this.type = action;
        }

        public void widgetSelected(SelectionEvent e) {
            List<RebaseInteractivePlan.PlanElement> selected = RebaseInteractiveStepActionToolBarProvider.this.getSelectedRebaseTodoLines();
            if (selected == null || selected.isEmpty()) {
                return;
            }
            RebaseInteractivePlan.ElementAction typeToSet = this.type;
            if (this.type != RebaseInteractivePlan.ElementAction.PICK) {
                boolean allItemsHaveTargetType = true;
                for (RebaseInteractivePlan.PlanElement element : selected) {
                    allItemsHaveTargetType &= element.getPlanElementAction() == this.type;
                }
                if (allItemsHaveTargetType) {
                    typeToSet = RebaseInteractivePlan.ElementAction.PICK;
                    ((ToolItem)RebaseInteractiveStepActionToolBarProvider.this.rebaseActionItems.get(RebaseInteractivePlan.ElementAction.PICK)).setSelection(true);
                    if (e.getSource() instanceof ToolItem) {
                        ((ToolItem)e.getSource()).setSelection(false);
                    }
                }
            }
            for (RebaseInteractivePlan.PlanElement element : selected) {
                element.setPlanElementAction(typeToSet);
            }
            RebaseInteractiveStepActionToolBarProvider.this.mapActionItemsToSelection(((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getSelection());
            ((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getControl().setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

