/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ProjectUtils {
    public static void createProjects(Set<ProjectRecord> projectsToCreate, IWorkingSet[] selectedWorkingSets, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ProjectUtils.createProjects(projectsToCreate, false, selectedWorkingSets, monitor);
    }

    public static void createProjects(final Set<ProjectRecord> projectsToCreate, final boolean open, final IWorkingSet[] selectedWorkingSets, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                if (actMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                HashMap<IProject, File> projectsToConnect = new HashMap<IProject, File>();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)(projectsToCreate.size() * 2 + 1));
                for (ProjectRecord projectRecord : projectsToCreate) {
                    RepositoryMapping mapping;
                    IPath absolutePath;
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progress.setTaskName(projectRecord.getProjectLabel());
                    IProject project = ProjectUtils.createExistingProject(projectRecord, open, (IProgressMonitor)progress.newChild(1));
                    if (project == null) continue;
                    RepositoryFinder finder = new RepositoryFinder(project);
                    finder.setFindInChildren(false);
                    List mappings = finder.find((IProgressMonitor)progress.newChild(1));
                    if (!mappings.isEmpty() && (absolutePath = (mapping = (RepositoryMapping)mappings.iterator().next()).getGitDirAbsolutePath()) != null) {
                        projectsToConnect.put(project, absolutePath.toFile());
                    }
                    if (selectedWorkingSets == null || selectedWorkingSets.length <= 0) continue;
                    workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
                }
                if (!projectsToConnect.isEmpty()) {
                    ConnectProviderOperation connect = new ConnectProviderOperation(projectsToConnect);
                    connect.execute((IProgressMonitor)progress.newChild(1));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static IProject createExistingProject(ProjectRecord record, boolean open, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            if (open && !project.isOpen()) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IPath location = project.getFile(".project").getLocation();
                if (location != null && location.toFile().equals(record.getProjectSystemFile())) {
                    project.open((IProgressMonitor)progress.newChild(1));
                    project.refreshLocal(2, (IProgressMonitor)progress.newChild(1));
                }
            }
            return null;
        }
        if (record.getProjectDescription() == null) {
            record.setProjectDescription(workspace.newProjectDescription(projectName));
            Path locationPath = new Path(record.getProjectSystemFile().getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.getProjectDescription().setLocation(null);
            } else {
                record.getProjectDescription().setLocation((IPath)locationPath);
            }
        } else {
            record.getProjectDescription().setName(projectName);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)UIText.WizardProjectsImportPage_CreateProjectsTask, (int)8);
        project.create(record.getProjectDescription(), (IProgressMonitor)progress.newChild(3));
        project.open(128, (IProgressMonitor)progress.newChild(5));
        return project;
    }
}

