/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.MultiStateTextFileChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.InternalTextEditChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.TextEditGroupNode;

public class TextEditChangeNode
extends InternalTextEditChangeNode {
    public static ChildNode createTextEditGroupNode(ChildNode parent, TextEditBasedChangeGroup changeGroup) {
        return new TextEditGroupNode(parent, changeGroup);
    }

    public static ChildNode createTextEditGroupNode(TextEditChangeNode parent, TextEditBasedChangeGroup changeGroup) {
        return new TextEditGroupNode(parent, changeGroup);
    }

    public TextEditChangeNode(TextEditBasedChange change) {
        super(null, (Change)change);
    }

    @Override
    public final TextEditBasedChange getTextEditBasedChange() {
        return super.getTextEditBasedChange();
    }

    @Override
    public String getText() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        if (change instanceof TextFileChange) {
            IFile file = ((TextFileChange)change).getFile();
            return Messages.format(RefactoringUIMessages.PreviewWizardPage_changeElementLabelProvider_textFormat, new String[]{BasicElementLabels.getResourceName((IResource)file), BasicElementLabels.getPathLabel(file.getParent().getFullPath(), false)});
        }
        return super.getText();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_FILE_CHANGE;
    }

    @Override
    protected ChildNode[] createChildNodes() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        if (change instanceof MultiStateTextFileChange) {
            return new ChildNode[0];
        }
        TextEditBasedChangeGroup[] groups = this.getSortedChangeGroups(change);
        ChildNode[] result = new ChildNode[groups.length];
        int i = 0;
        while (i < groups.length) {
            result[i] = new TextEditGroupNode(this, groups[i]);
            ++i;
        }
        return result;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] groups = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(groups.length);
        int i = 0;
        while (i < groups.length) {
            if (!groups[i].getTextEditGroup().isEmpty()) {
                result.add(groups[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    public static abstract class ChildNode
    extends PreviewNode {
        protected ChildNode(PreviewNode parent) {
            super(parent);
        }

        protected TextEditChangeNode getTextEditChangeNode() {
            return TextEditChangeNode.internalGetTextEditChangeNode(this);
        }
    }

    private static class OffsetComparator
    implements Comparator<TextEditBasedChangeGroup> {
        private OffsetComparator() {
        }

        @Override
        public int compare(TextEditBasedChangeGroup c1, TextEditBasedChangeGroup c2) {
            int p2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

