/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.RepositoryPropertySourceProvider;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoriesView
extends CommonNavigator
implements IShowInSource,
IShowInTargetList {
    public static final String REMOTE = "remote";
    public static final String URL = "url";
    public static final String PUSHURL = "pushurl";
    public static final String PUSH = "push";
    public static final String FETCH = "fetch";
    public static final String VIEW_ID = "org.eclipse.egit.ui.RepositoriesView";
    private static final long DEFAULT_REFRESH_DELAY = 1000L;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final RefsChangedListener myRefsChangedListener;
    private final IndexChangedListener myIndexChangedListener;
    private final ConfigChangedListener myConfigChangeListener;
    private final List<ListenerHandle> myListeners = new LinkedList<ListenerHandle>();
    private Job scheduledJob;
    private final RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
    private final RepositoryCache repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
    private Composite emptyArea;
    private StackLayout layout;
    private volatile long lastInputChange = 0L;
    private volatile long lastInputUpdate = -1L;
    private boolean reactOnSelection;
    private final IEclipsePreferences.IPreferenceChangeListener configurationListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RepositoriesView.this.lastInputChange = System.currentTimeMillis();
            RepositoriesView.this.scheduleRefresh(1000L);
        }
    };
    private ISelectionListener selectionChangedListener;

    public RepositoriesView() {
        this.myRefsChangedListener = new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent e) {
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.myIndexChangedListener = new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.myConfigChangeListener = new ConfigChangedListener(){

            public void onConfigChanged(ConfigChangedEvent event) {
                RepositoriesView.this.scheduleRefresh(1000L);
            }
        };
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!RepositoriesView.this.reactOnSelection || part == RepositoriesView.this) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        RepositoriesView.this.reactOnSelection((ISelection)new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    } else if (input instanceof IURIEditorInput) {
                        RepositoriesView.this.reactOnSelection((ISelection)new StructuredSelection((Object)input));
                    }
                } else {
                    RepositoriesView.this.reactOnSelection(selection);
                }
            }
        };
    }

    protected void createEmptyArea(Composite parent) {
        this.emptyArea = new Composite(parent, 0);
        this.emptyArea.setBackgroundMode(2);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                RepositoriesView.this.getNavigatorActionService().fillContextMenu(m);
            }
        });
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.getCommonViewer());
        Menu menu = manager.createContextMenu((Control)this.emptyArea);
        this.emptyArea.setMenu(menu);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyArea);
        Composite infoArea = new Composite(this.emptyArea, 0);
        infoArea.setMenu(menu);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)infoArea);
        GridLayoutFactory.swtDefaults().applyTo(infoArea);
        Label messageLabel = new Label(infoArea, 64);
        messageLabel.setText(UIText.RepositoriesView_messsageEmpty);
        messageLabel.setMenu(menu);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)messageLabel);
        Composite optionsArea = new Composite(infoArea, 0);
        optionsArea.setMenu(menu);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)optionsArea);
        final FormToolkit toolkit = new FormToolkit(this.emptyArea.getDisplay());
        this.emptyArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.emptyArea.getDisplay());
        Label addLabel = new Label(optionsArea, 0);
        Image addImage = UIIcons.NEW_REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)addLabel, (Resource)addImage);
        addLabel.setImage(addImage);
        Hyperlink addLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkAdd, 64);
        addLink.setForeground(linkColor);
        addLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = CommonUtils.getService((IServiceLocator)RepositoriesView.this.getViewSite(), IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewAddRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)addLink);
        Label cloneLabel = new Label(optionsArea, 0);
        Image cloneImage = UIIcons.CLONEGIT.createImage();
        UIUtils.hookDisposal((Widget)cloneLabel, (Resource)cloneImage);
        cloneLabel.setImage(cloneImage);
        Hyperlink cloneLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkClone, 64);
        cloneLink.setForeground(linkColor);
        cloneLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = CommonUtils.getService((IServiceLocator)RepositoriesView.this.getViewSite(), IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewClone");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneLink);
        Label createLabel = new Label(optionsArea, 0);
        Image createImage = UIIcons.CREATE_REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)createLabel, (Resource)createImage);
        createLabel.setImage(createImage);
        Hyperlink createLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkCreate, 64);
        createLink.setForeground(linkColor);
        createLink.setText(UIText.RepositoriesView_linkCreate);
        createLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = CommonUtils.getService((IServiceLocator)RepositoriesView.this.getViewSite(), IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewCreateRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)createLink);
    }

    public void createPartControl(Composite aParent) {
        Composite displayArea = new Composite(aParent, 0);
        this.layout = new StackLayout();
        displayArea.setLayout((Layout)this.layout);
        this.createEmptyArea(displayArea);
        super.createPartControl(displayArea);
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService csrv = CommonUtils.getService((IServiceLocator)w, ICommandService.class);
        Command command = csrv.getCommand("org.eclipse.egit.ui.RepositoriesLinkWithSelection");
        this.reactOnSelection = (Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue();
        IWorkbenchSiteProgressService service = CommonUtils.getService((IServiceLocator)this.getSite(), IWorkbenchSiteProgressService.class);
        if (service != null) {
            service.showBusyForFamily(JobFamilies.REPO_VIEW_REFRESH);
            service.showBusyForFamily(JobFamilies.CLONE);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new RepositoryPropertySourceProvider(page));
            return page;
        }
        return super.getAdapter(adapter);
    }

    public void setReactOnSelection(boolean reactOnSelection) {
        this.reactOnSelection = reactOnSelection;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer viewer = super.createCommonViewer(aParent);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element.getRepository().isBare()) {
                    return;
                }
                if (element instanceof RefNode) {
                    RepositoriesView.this.executeOpenCommandWithConfirmation(((Ref)((RefNode)element).getObject()).getName());
                }
                if (element instanceof TagNode) {
                    RepositoriesView.this.executeOpenCommandWithConfirmation(((Ref)((TagNode)element).getObject()).getName());
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element instanceof FileNode || element instanceof StashedCommitNode) {
                    RepositoriesView.this.executeOpenCommand();
                }
            }
        });
        ISelectionService srv = CommonUtils.getService((IServiceLocator)this.getSite(), ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        this.repositoryUtil.getPreferences().addPreferenceChangeListener(this.configurationListener);
        this.initRepositoriesAndListeners();
        this.activateContextService();
        this.emptyArea.setBackground(viewer.getControl().getBackground());
        this.layout.topControl = !this.repositories.isEmpty() ? viewer.getControl() : this.emptyArea;
        return viewer;
    }

    private void executeOpenCommandWithConfirmation(String refName) {
        if (!BranchOperationUI.checkoutWillShowQuestionDialog(refName)) {
            String shortName = Repository.shortenRefName((String)refName);
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (store.getBoolean("show_checkout_confirmation")) {
                String toggleMessage = UIText.RepositoriesView_CheckoutConfirmationToggleMessage;
                MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getViewSite().getShell(), (String)UIText.RepositoriesView_CheckoutConfirmationTitle, (String)MessageFormat.format(UIText.RepositoriesView_CheckoutConfirmationMessage, shortName), (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"show_checkout_confirmation");
                if (dlg.getReturnCode() != 0) {
                    return;
                }
            }
        }
        this.executeOpenCommand();
    }

    private void executeOpenCommand() {
        IHandlerService srv = CommonUtils.getService((IServiceLocator)this.getViewSite(), IHandlerService.class);
        try {
            srv.executeCommand("org.eclipse.egit.ui.RepositoriesViewOpen", null);
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    private void activateContextService() {
        IContextService contextService = CommonUtils.getService((IServiceLocator)this.getSite(), IContextService.class);
        if (contextService != null) {
            contextService.activateContext(VIEW_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoriesAndListeners() {
        Set<Repository> set = this.repositories;
        synchronized (set) {
            this.repositories.clear();
            this.unregisterRepositoryListener();
            for (String dir : this.repositoryUtil.getConfiguredRepositories()) {
                File repoDir = new File(dir);
                try {
                    Repository repo = this.repositoryCache.lookupRepository(repoDir);
                    this.myListeners.add(repo.getListenerList().addIndexChangedListener(this.myIndexChangedListener));
                    this.myListeners.add(repo.getListenerList().addRefsChangedListener(this.myRefsChangedListener));
                    this.myListeners.add(repo.getListenerList().addConfigChangedListener(this.myConfigChangeListener));
                    this.repositories.add(repo);
                }
                catch (IOException e) {
                    String message = NLS.bind((String)UIText.RepositoriesView_ExceptionLookingUpRepoMessage, (Object)repoDir.getPath());
                    Activator.handleError(message, e, false);
                    this.repositoryUtil.removeDir(repoDir);
                }
            }
        }
    }

    public void dispose() {
        if (this.scheduledJob != null) {
            this.scheduledJob.cancel();
            this.scheduledJob = null;
        }
        this.repositoryUtil.getPreferences().removePreferenceChangeListener(this.configurationListener);
        ISelectionService srv = CommonUtils.getService((IServiceLocator)this.getSite(), ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        this.unregisterRepositoryListener();
        this.repositories.clear();
        super.dispose();
    }

    private void showResource(IResource resource) {
        IPath location = resource.getLocation();
        if (location != null) {
            this.showPaths(Arrays.asList(location));
        }
    }

    private void showPaths(List<IPath> paths) {
        final ArrayList<RepositoryTreeNode> nodesToShow = new ArrayList<RepositoryTreeNode>();
        Map pathsByRepo = ResourceUtil.splitPathsByRepository(paths);
        for (Map.Entry entry : pathsByRepo.entrySet()) {
            Repository repository;
            block7: {
                repository = (Repository)entry.getKey();
                try {
                    boolean added = this.repositoryUtil.addConfiguredRepository(repository.getDirectory());
                    if (!added) break block7;
                    this.scheduleRefresh(0L);
                }
                catch (IllegalArgumentException iae) {
                    Activator.handleError(iae.getMessage(), iae, false);
                    continue;
                }
            }
            if (this.scheduledJob != null) {
                try {
                    this.scheduledJob.join();
                }
                catch (InterruptedException e) {
                    Activator.handleError(e.getMessage(), e, false);
                }
            }
            for (String repoPath : (Collection)entry.getValue()) {
                RepositoryTreeNode node = this.getNodeForPath(repository, repoPath);
                if (node == null) continue;
                nodesToShow.add(node);
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoriesView.this.selectReveal((ISelection)new StructuredSelection(nodesToShow));
            }
        });
    }

    public void showRepository(Repository repositoryToShow) {
        ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        Object[] objectArray = cp.getElements(this.getCommonViewer().getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object repo = objectArray[n2];
            RepositoryTreeNode node = (RepositoryTreeNode)repo;
            if (repositoryToShow.getDirectory().equals(node.getRepository().getDirectory())) {
                this.selectReveal((ISelection)new StructuredSelection((Object)node));
            }
            ++n2;
        }
    }

    public void refresh() {
        this.lastInputUpdate = -1L;
        this.scheduleRefresh(0L);
    }

    private void trace(String message) {
        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), message);
    }

    private Job scheduleRefresh(long delay) {
        if (GitTraceLocation.REPOSITORIESVIEW.isActive()) {
            this.trace("Entering scheduleRefresh()");
        }
        if (this.scheduledJob != null) {
            this.schedule(this.scheduledJob, delay);
            return this.scheduledJob;
        }
        Job job = new Job("Refreshing Git Repositories view"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean needsNewInput;
                final CommonViewer tv = RepositoriesView.this.getCommonViewer();
                if (!UIUtils.isUsable((Viewer)tv)) {
                    return Status.CANCEL_STATUS;
                }
                final boolean trace = GitTraceLocation.REPOSITORIESVIEW.isActive();
                boolean bl = needsNewInput = RepositoriesView.this.lastInputChange > RepositoriesView.this.lastInputUpdate;
                if (trace) {
                    RepositoriesView.this.trace("Running the update, new input required: " + (RepositoriesView.this.lastInputChange > RepositoriesView.this.lastInputUpdate));
                }
                RepositoriesView.this.lastInputUpdate = System.currentTimeMillis();
                if (needsNewInput) {
                    RepositoriesView.this.initRepositoriesAndListeners();
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertySheet sheet;
                        IPage page;
                        if (!UIUtils.isUsable((Viewer)tv)) {
                            return;
                        }
                        long start = 0L;
                        if (trace) {
                            start = System.currentTimeMillis();
                            RepositoriesView.this.trace("Starting async update job");
                        }
                        if (needsNewInput) {
                            Object[] expanded = tv.getExpandedElements();
                            tv.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                            tv.setExpandedElements(expanded);
                        } else {
                            tv.refresh(true);
                        }
                        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
                        if (part instanceof PropertySheet && (page = (sheet = (PropertySheet)part).getCurrentPage()) instanceof PropertySheetPage) {
                            ((PropertySheetPage)page).refresh();
                        }
                        if (trace) {
                            RepositoriesView.this.trace("Ending async update job after " + (System.currentTimeMillis() - start) + " ms");
                        }
                        ((RepositoriesView)(this).RepositoriesView.this).layout.topControl = !RepositoriesView.this.repositories.isEmpty() ? RepositoriesView.this.getCommonViewer().getControl() : RepositoriesView.this.emptyArea;
                        RepositoriesView.this.emptyArea.getParent().layout(true, true);
                    }
                });
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.REPO_VIEW_REFRESH.equals(family);
            }
        };
        job.setSystem(true);
        this.schedule(job, delay);
        this.scheduledJob = job;
        return this.scheduledJob;
    }

    private void schedule(Job job, long delay) {
        IWorkbenchSiteProgressService service = CommonUtils.getService((IServiceLocator)this.getSite(), IWorkbenchSiteProgressService.class);
        if (GitTraceLocation.REPOSITORIESVIEW.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), "Scheduling refresh job");
        }
        service.schedule(job, delay);
    }

    private void unregisterRepositoryListener() {
        for (ListenerHandle lh : this.myListeners) {
            lh.remove();
        }
        this.myListeners.clear();
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<IPath> paths = new ArrayList<IPath>();
            for (Object element : ss) {
                IResource resource = (IResource)AdapterUtils.adapt(element, IResource.class);
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location == null) continue;
                    paths.add(location);
                    continue;
                }
                if (!(element instanceof IPath)) continue;
                paths.add((IPath)element);
            }
            if (!paths.isEmpty()) {
                this.showPaths(paths);
                return true;
            }
            Repository repository = SelectionUtils.getRepository(ss);
            if (repository != null) {
                this.showRepository(repository);
                return true;
            }
        }
        if (context.getInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)context.getInput();
            this.showResource((IResource)input.getFile());
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        List<Object> elements = RepositoriesView.getShowInElements(selection);
        HistoryPageInput historyPageInput = RepositoriesView.getHistoryPageInput(selection);
        return new ShowInContext((Object)historyPageInput, (ISelection)new StructuredSelection(elements));
    }

    public String[] getShowInTargetIds() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        for (Object element : selection.toList()) {
            if (!(element instanceof RepositoryNode)) continue;
            return new String[]{"org.eclipse.team.ui.GenericHistoryView", "org.eclipse.egit.ui.ReflogView"};
        }
        return new String[]{"org.eclipse.team.ui.GenericHistoryView"};
    }

    private static List<Object> getShowInElements(IStructuredSelection selection) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object element : selection.toList()) {
            if (element instanceof FileNode || element instanceof FolderNode || element instanceof WorkingDirNode) {
                RepositoryTreeNode treeNode = (RepositoryTreeNode)element;
                IPath path = treeNode.getPath();
                IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
                if (resource == null) continue;
                elements.add(resource);
                continue;
            }
            if (element instanceof RepositoryNode) {
                elements.add(element);
                continue;
            }
            if (!(element instanceof RepositoryNode) && !(element instanceof RemoteNode) && !(element instanceof FetchNode) && !(element instanceof PushNode) && !(element instanceof TagNode) && !(element instanceof RefNode)) continue;
            elements.add(element);
        }
        return elements;
    }

    private static HistoryPageInput getHistoryPageInput(IStructuredSelection selection) {
        ArrayList<File> files = new ArrayList<File>();
        Repository repo = null;
        for (Object element : selection.toList()) {
            Repository nodeRepository;
            if (element instanceof FileNode) {
                FileNode fileNode = (FileNode)element;
                files.add((File)fileNode.getObject());
                nodeRepository = fileNode.getRepository();
            } else if (element instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)element;
                files.add((File)folderNode.getObject());
                nodeRepository = folderNode.getRepository();
            } else {
                return null;
            }
            if (repo == null) {
                repo = nodeRepository;
            }
            if (repo == nodeRepository) continue;
            return null;
        }
        if (repo != null) {
            return new HistoryPageInput(repo, files.toArray(new File[files.size()]));
        }
        return null;
    }

    private void reactOnSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection ssel = (StructuredSelection)selection;
            if (ssel.size() != 1) {
                return;
            }
            if (ssel.getFirstElement() instanceof IResource) {
                this.showResource((IResource)ssel.getFirstElement());
                return;
            }
            IResource adapted = (IResource)AdapterUtils.adapt((Object)ssel.getFirstElement(), IResource.class);
            if (adapted != null) {
                this.showResource(adapted);
                return;
            }
            File file = (File)AdapterUtils.adapt((Object)ssel.getFirstElement(), File.class);
            if (file != null) {
                Path path = new Path(file.getAbsolutePath());
                this.showPaths(Arrays.asList(path));
                return;
            }
        }
    }

    private RepositoryTreeNode getNodeForPath(Repository repository, String repoRelativePath) {
        RepositoryTreeNode childNode;
        Object child;
        int n;
        int n2;
        Object[] objectArray;
        RepositoryTreeNode currentNode = null;
        ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        Object[] objectArray2 = cp.getElements(this.getCommonViewer().getInput());
        int n3 = objectArray2.length;
        int n4 = 0;
        block0: while (n4 < n3) {
            Object repo = objectArray2[n4];
            RepositoryTreeNode node = (RepositoryTreeNode)repo;
            if (repository.getDirectory().equals(((Repository)node.getObject()).getDirectory())) {
                objectArray = cp.getChildren((Object)node);
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    child = objectArray[n];
                    childNode = (RepositoryTreeNode)child;
                    if (childNode.getType() == RepositoryTreeNodeType.WORKINGDIR) {
                        currentNode = childNode;
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            ++n4;
        }
        Path relPath = new Path(repoRelativePath);
        String[] stringArray = relPath.segments();
        int n5 = stringArray.length;
        n3 = 0;
        while (n3 < n5) {
            String segment = stringArray[n3];
            objectArray = cp.getChildren(currentNode);
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                child = objectArray[n];
                childNode = (RepositoryTreeNode)child;
                if (((File)childNode.getObject()).getName().equals(segment)) {
                    currentNode = childNode;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        return currentNode;
    }
}

