/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.IContext;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class ConstraintVariableFactory
implements IConstraintVariableFactory {
    private Map<IBinding, IBinding> fBindingMap = new HashMap<IBinding, IBinding>();
    private Map<Object, ExpressionVariable> fExpressionMap = new Hashtable<Object, ExpressionVariable>();
    private Map<Integer, ExpressionVariable> fLiteralMap = new HashMap<Integer, ExpressionVariable>();
    private Map<CompilationUnitRange, TypeVariable> fTypeVariableMap = new HashMap<CompilationUnitRange, TypeVariable>();
    private Map<String, DeclaringTypeVariable> fDeclaringTypeVariableMap = new HashMap<String, DeclaringTypeVariable>();
    private Map<String, ParameterTypeVariable> fParameterMap = new HashMap<String, ParameterTypeVariable>();
    private Map<String, RawBindingVariable> fRawBindingMap = new HashMap<String, RawBindingVariable>();
    private Map<String, ReturnTypeVariable> fReturnVariableMap = new HashMap<String, ReturnTypeVariable>();
    public static final boolean REPORT = false;
    protected int nrCreated = 0;
    protected int nrRetrieved = 0;

    public int getNumCreated() {
        return this.nrCreated;
    }

    public ConstraintVariable makeExpressionOrTypeVariable(Expression expression, IContext context) {
        IBinding binding = ExpressionVariable.resolveBinding(expression);
        if (binding instanceof ITypeBinding) {
            ICompilationUnit cu = ASTCreator.getCu((ASTNode)expression);
            Assert.isNotNull((Object)cu);
            CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)expression);
            return this.makeTypeVariable((ITypeBinding)this.getKey(binding), expression.toString(), range);
        }
        if (ASTNodes.isLiteral(expression)) {
            Integer nodeType = new Integer(expression.getNodeType());
            if (!this.fLiteralMap.containsKey(nodeType)) {
                this.fLiteralMap.put(nodeType, new ExpressionVariable(expression));
            }
            return this.fLiteralMap.get(nodeType);
        }
        Object key = binding != null ? this.getKey(binding) : new CompilationUnitRange(ASTCreator.getCu((ASTNode)expression), (ASTNode)expression);
        ExpressionVariable ev = this.fExpressionMap.get(key);
        if (ev == null) {
            ev = new ExpressionVariable(expression);
            this.fExpressionMap.put(key, ev);
        }
        return ev;
    }

    private IBinding getKey(IBinding binding) {
        if (this.fBindingMap.containsKey(binding)) {
            return this.fBindingMap.get(binding);
        }
        for (IBinding b2 : this.fBindingMap.keySet()) {
            if (!Bindings.equals(binding, b2)) continue;
            this.fBindingMap.put(binding, b2);
            return b2;
        }
        this.fBindingMap.put(binding, binding);
        return binding;
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(ITypeBinding memberTypeBinding) {
        String key = memberTypeBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(memberTypeBinding));
        }
        return this.fDeclaringTypeVariableMap.get(key);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IVariableBinding fieldBinding) {
        String key = fieldBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(fieldBinding));
        }
        return this.fDeclaringTypeVariableMap.get(key);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        if (!this.fDeclaringTypeVariableMap.containsKey(key)) {
            this.fDeclaringTypeVariableMap.put(key, new DeclaringTypeVariable(methodBinding));
        }
        return this.fDeclaringTypeVariableMap.get(key);
    }

    public ParameterTypeVariable makeParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex) {
        String key = String.valueOf(methodBinding.getKey()) + parameterIndex;
        if (!this.fParameterMap.containsKey(key)) {
            this.fParameterMap.put(key, new ParameterTypeVariable(methodBinding, parameterIndex));
        }
        return this.fParameterMap.get(key);
    }

    public RawBindingVariable makeRawBindingVariable(ITypeBinding binding) {
        String key = binding.getKey();
        if (!this.fRawBindingMap.containsKey(key)) {
            this.fRawBindingMap.put(key, new RawBindingVariable(binding));
        }
        return this.fRawBindingMap.get(key);
    }

    public ReturnTypeVariable makeReturnTypeVariable(ReturnStatement returnStatement) {
        return this.makeReturnTypeVariable(ReturnTypeVariable.getMethod(returnStatement).resolveBinding());
    }

    public ReturnTypeVariable makeReturnTypeVariable(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        if (!this.fReturnVariableMap.containsKey(key)) {
            this.fReturnVariableMap.put(key, new ReturnTypeVariable(methodBinding));
        }
        return this.fReturnVariableMap.get(key);
    }

    public TypeVariable makeTypeVariable(Type type) {
        ICompilationUnit cu = ASTCreator.getCu((ASTNode)type);
        Assert.isNotNull((Object)cu);
        CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)type);
        if (!this.fTypeVariableMap.containsKey(range)) {
            this.fTypeVariableMap.put(range, new TypeVariable(type));
        }
        return this.fTypeVariableMap.get(range);
    }

    public TypeVariable makeTypeVariable(ITypeBinding binding, String source, CompilationUnitRange range) {
        if (!this.fTypeVariableMap.containsKey(range)) {
            this.fTypeVariableMap.put(range, new TypeVariable(binding, source, range));
        }
        return this.fTypeVariableMap.get(range);
    }

    protected void dumpConstraintStats() {
        System.out.println("created: " + this.nrCreated + ", retrieved: " + this.nrRetrieved);
    }
}

