/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.monitoring.DefaultUiFreezeEventLogger;
import org.eclipse.ui.internal.monitoring.FilterHandler;
import org.eclipse.ui.internal.monitoring.LongEventInfo;
import org.eclipse.ui.internal.monitoring.Messages;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.internal.monitoring.Tracer;
import org.eclipse.ui.monitoring.IUiFreezeEventLogger;
import org.eclipse.ui.monitoring.StackSample;
import org.eclipse.ui.monitoring.UiFreezeEvent;

public class EventLoopMonitorThread
extends Thread {
    private static final int EVENT_HISTORY_SIZE = 100;
    private static final String EXTENSION_ID = "org.eclipse.ui.monitoring.logger";
    private static final String NEW_LINE_AND_BULLET = "\n* ";
    private static final String TRACE_EVENT_MONITOR = "/debug/event_monitor";
    private static final String TRACE_PREFIX = "Event Loop Monitor";
    private static final Tracer tracer = Tracer.create("Event Loop Monitor", "org.eclipse.ui.monitoring/debug/event_monitor");
    private final EventLoopState eventLoopState = new EventLoopState();
    private volatile long eventStartOrResumeTime;
    private final int longEventWarningThreshold;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicReference<LongEventInfo> eventToPublish = new AtomicReference<Object>(null);
    private final List<IUiFreezeEventLogger> externalLoggers = new ArrayList<IUiFreezeEventLogger>();
    private DefaultUiFreezeEventLogger defaultLogger;
    private final Display display;
    private final FilterHandler uiThreadFilter;
    private final FilterHandler noninterestingThreadFilter;
    private final int longEventErrorThreshold;
    private final long sampleInterval;
    private final long allThreadsSampleInterval;
    private final int maxStackSamples;
    private final int maxLoggedStackSamples;
    private final long deadlockThreshold;
    private final long uiThreadId;
    private final Object sleepMonitor;
    private final boolean logToErrorLog;
    private EventHistory eventHistory;
    private ThreadMXBean threadMXBean;
    private boolean dumpLockedMonitors;
    private boolean dumpLockedSynchronizers;
    private long monitoringThreadId;

    public EventLoopMonitorThread(Parameters args) throws IllegalArgumentException {
        super(TRACE_PREFIX);
        if (tracer != null) {
            this.eventHistory = new EventHistory(100);
        }
        Assert.isNotNull((Object)args);
        args.checkParameters();
        this.setDaemon(true);
        this.setPriority(6);
        this.display = EventLoopMonitorThread.getDisplay();
        this.uiThreadId = this.display.getThread().getId();
        this.longEventWarningThreshold = Math.max(args.longEventWarningThreshold, 3);
        this.longEventErrorThreshold = Math.max(args.longEventErrorThreshold, this.longEventWarningThreshold);
        this.maxLoggedStackSamples = Math.max(args.maxStackSamples, 0);
        this.maxStackSamples = 2 * this.maxLoggedStackSamples;
        this.sampleInterval = this.longEventWarningThreshold * 2 / 3;
        this.allThreadsSampleInterval = this.longEventErrorThreshold * 2 / 3;
        this.deadlockThreshold = args.deadlockThreshold;
        this.logToErrorLog = args.logToErrorLog;
        this.uiThreadFilter = new FilterHandler(args.uiThreadFilter);
        this.noninterestingThreadFilter = new FilterHandler(args.noninterestingThreadFilter);
        this.sleepMonitor = new Object();
    }

    public void shutdown() throws SWTException {
        this.cancelled.set(true);
        if (!this.display.isDisposed()) {
            this.display.removeListener(50, (Listener)this.eventLoopState);
            this.display.removeListener(51, (Listener)this.eventLoopState);
            this.display.removeListener(52, (Listener)this.eventLoopState);
            this.display.removeListener(53, (Listener)this.eventLoopState);
        }
        this.wakeUp();
    }

    final void handleEvent(Event event) {
        this.eventLoopState.handleEvent(event);
    }

    private void handleEventTransition(boolean attemptToLogLongDelay, boolean startEventTimer) {
        int duration;
        long startTime;
        long currTime = this.getTimestamp();
        if (attemptToLogLongDelay && (startTime = this.eventStartOrResumeTime) != 0L && (duration = (int)(currTime - startTime)) >= this.longEventWarningThreshold) {
            LongEventInfo info = new LongEventInfo(startTime, duration);
            this.eventToPublish.set(info);
            this.wakeUp();
        }
        this.eventStartOrResumeTime = startEventTimer ? currTime : 0L;
    }

    @Override
    public void run() {
        if (this.logToErrorLog) {
            this.defaultLogger = new DefaultUiFreezeEventLogger(this.longEventErrorThreshold);
        }
        this.loadLoggerExtensions();
        if (!this.logToErrorLog && this.externalLoggers.isEmpty()) {
            MonitoringPlugin.logWarning(Messages.EventLoopMonitorThread_logging_disabled_error);
        }
        this.monitoringThreadId = Thread.currentThread().getId();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.dumpLockedMonitors = this.threadMXBean.isObjectMonitorUsageSupported();
        this.dumpLockedSynchronizers = this.threadMXBean.isSynchronizerUsageSupported();
        boolean contentionMonitoringSupported = this.threadMXBean.isThreadContentionMonitoringSupported();
        boolean resetStalledEventState = true;
        long deadlockTimerStart = 0L;
        long pollingNyquistDelay = this.sampleInterval / 2L;
        long pollingDelay = 0L;
        long grabStackSampleAt = 0L;
        long lastEventStartOrResumeTime = 0L;
        StackSample[] stackSamples = new StackSample[this.maxStackSamples];
        int numSamples = 0;
        boolean starvedAwake = false;
        boolean starvedAsleep = false;
        boolean dumpAllThreads = false;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                EventLoopMonitorThread.this.registerDisplayListeners();
            }
        });
        long currTime = this.getTimestamp();
        while (!this.cancelled.get()) {
            LongEventInfo eventSnapshot;
            boolean starved;
            boolean starvedAsleepCurrentCycle;
            boolean starvedAwakeCurrentCycle;
            long sleepFor;
            if (resetStalledEventState) {
                long eventTime;
                deadlockTimerStart = eventTime = this.eventStartOrResumeTime;
                if (eventTime == 0L) {
                    eventTime = currTime;
                }
                grabStackSampleAt = eventTime + this.sampleInterval;
                numSamples = 0;
                starvedAwake = false;
                starvedAsleep = false;
                if (dumpAllThreads) {
                    dumpAllThreads = false;
                    if (contentionMonitoringSupported) {
                        this.threadMXBean.setThreadContentionMonitoringEnabled(false);
                    }
                }
                pollingDelay = this.sampleInterval;
                sleepFor = pollingNyquistDelay;
                resetStalledEventState = false;
            } else {
                sleepFor = lastEventStartOrResumeTime == 0L ? pollingNyquistDelay : Math.min(pollingNyquistDelay, Math.max(1L, grabStackSampleAt - currTime));
            }
            int i = numSamples;
            while (i < stackSamples.length && stackSamples[i] != null) {
                stackSamples[i] = null;
                ++i;
            }
            long sleepAt = this.getTimestamp();
            long awakeDuration = currTime - sleepAt;
            boolean bl = starvedAwakeCurrentCycle = awakeDuration > sleepFor + (long)(this.longEventWarningThreshold / 2);
            if (starvedAwakeCurrentCycle) {
                starvedAwake = true;
            }
            this.sleepForMillis(sleepFor);
            currTime = this.getTimestamp();
            long currEventStartOrResumeTime = this.eventStartOrResumeTime;
            long sleepDuration = currTime - sleepAt;
            boolean bl2 = starvedAsleepCurrentCycle = sleepDuration > sleepFor + (long)(this.longEventWarningThreshold / 2);
            if (starvedAsleepCurrentCycle) {
                starvedAsleep = true;
            }
            boolean bl3 = starved = starvedAsleepCurrentCycle || starvedAwakeCurrentCycle;
            if (lastEventStartOrResumeTime != currEventStartOrResumeTime || starved) {
                resetStalledEventState = true;
                if (tracer != null && starved) {
                    if (starvedAwakeCurrentCycle) {
                        tracer.trace(String.format("Starvation detected! Polling loop took a significant amount of threshold: %dms", awakeDuration));
                    }
                    if (starvedAsleepCurrentCycle) {
                        tracer.trace(String.format("Starvation detected! Expected to sleep for %dms but actually slept for %dms", sleepFor, sleepDuration));
                    }
                }
            } else if (lastEventStartOrResumeTime != 0L) {
                long totalDuration;
                if (!dumpAllThreads && currTime >= lastEventStartOrResumeTime + this.allThreadsSampleInterval) {
                    dumpAllThreads = true;
                    if (contentionMonitoringSupported) {
                        this.threadMXBean.setThreadContentionMonitoringEnabled(true);
                    }
                }
                if (deadlockTimerStart != 0L && (totalDuration = currTime - deadlockTimerStart) >= this.deadlockThreshold) {
                    if (numSamples > this.maxLoggedStackSamples) {
                        EventLoopMonitorThread.decimate(stackSamples, numSamples, this.maxLoggedStackSamples);
                        numSamples = this.maxLoggedStackSamples;
                    }
                    if (this.uiThreadFilter.shouldLogEvent(stackSamples, numSamples, this.uiThreadId)) {
                        this.logEvent(new UiFreezeEvent(deadlockTimerStart, totalDuration, Arrays.copyOf(stackSamples, numSamples), true, starvedAwake, starvedAsleep));
                        deadlockTimerStart = 0L;
                    }
                }
                if (this.maxStackSamples > 0 && currTime >= grabStackSampleAt) {
                    if (numSamples == this.maxStackSamples) {
                        numSamples = this.maxStackSamples / 2;
                        EventLoopMonitorThread.decimate(stackSamples, this.maxStackSamples, numSamples);
                    }
                    ThreadInfo[] threadStacks = this.captureThreadStacks(dumpAllThreads);
                    stackSamples[numSamples++] = new StackSample(this.getTimestamp(), threadStacks);
                    if (numSamples == this.maxStackSamples) {
                        pollingDelay *= 2L;
                    }
                    grabStackSampleAt += pollingDelay;
                }
            }
            if ((eventSnapshot = (LongEventInfo)this.eventToPublish.getAndSet(null)) != null) {
                long eventEnd = eventSnapshot.start + eventSnapshot.duration;
                while (numSamples > 0 && eventEnd <= stackSamples[numSamples - 1].getTimestamp()) {
                    --numSamples;
                }
                if (numSamples > this.maxLoggedStackSamples && eventEnd - stackSamples[numSamples - 1].getTimestamp() < this.sampleInterval) {
                    --numSamples;
                }
                if (numSamples > this.maxLoggedStackSamples) {
                    EventLoopMonitorThread.decimate(stackSamples, numSamples, this.maxLoggedStackSamples);
                    numSamples = this.maxLoggedStackSamples;
                }
                if (this.uiThreadFilter.shouldLogEvent(stackSamples, numSamples, this.uiThreadId)) {
                    this.logEvent(new UiFreezeEvent(eventSnapshot.start, eventSnapshot.duration, Arrays.copyOf(stackSamples, numSamples), false, starvedAwake, starvedAsleep));
                }
                resetStalledEventState = true;
            }
            lastEventStartOrResumeTime = currEventStartOrResumeTime;
        }
    }

    private ThreadInfo[] captureThreadStacks(boolean dumpAllThreads) {
        block6: {
            if (!dumpAllThreads) break block6;
            ThreadInfo[] threadStacks = this.threadMXBean.dumpAllThreads(this.dumpLockedMonitors, this.dumpLockedSynchronizers);
            int index = 0;
            int i = 0;
            while (i < threadStacks.length) {
                block7: {
                    ThreadInfo thread;
                    block9: {
                        block8: {
                            thread = threadStacks[i];
                            long threadId = thread.getThreadId();
                            if (threadId == this.monitoringThreadId) break block7;
                            if (threadId != this.uiThreadId) break block8;
                            if (index != 0) {
                                thread = threadStacks[0];
                                threadStacks[0] = threadStacks[i];
                            }
                            break block9;
                        }
                        if (!this.isInteresting(thread)) break block7;
                    }
                    threadStacks[index++] = thread;
                }
                ++i;
            }
            return Arrays.copyOf(threadStacks, index);
        }
        return new ThreadInfo[]{this.threadMXBean.getThreadInfo(this.uiThreadId, Integer.MAX_VALUE)};
    }

    private boolean isInteresting(ThreadInfo thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (!this.noninterestingThreadFilter.matchesFilter(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Display getDisplay() throws IllegalStateException {
        IWorkbench workbench = MonitoringPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            throw new IllegalStateException(Messages.EventLoopMonitorThread_workbench_was_null);
        }
        Display display = workbench.getDisplay();
        if (display == null) {
            throw new IllegalStateException(Messages.EventLoopMonitorThread_display_was_null);
        }
        return display;
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleepForMillis(long milliseconds) {
        if (milliseconds > 0L) {
            try {
                Object object = this.sleepMonitor;
                synchronized (object) {
                    this.sleepMonitor.wait(milliseconds);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void loadLoggerExtensions() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IUiFreezeEventLogger) {
                    this.externalLoggers.add((IUiFreezeEventLogger)object);
                } else {
                    MonitoringPlugin.logWarning(NLS.bind((String)Messages.EventLoopMonitorThread_invalid_logger_type_error_4, (Object[])new Object[]{object.getClass().getName(), IUiFreezeEventLogger.class.getClass().getSimpleName(), EXTENSION_ID, element.getContributor().getName()}));
                }
            }
            catch (CoreException e) {
                MonitoringPlugin.logError(e.getMessage(), e);
            }
            ++n2;
        }
    }

    private void registerDisplayListeners() {
        this.display.addListener(50, (Listener)this.eventLoopState);
        this.display.addListener(51, (Listener)this.eventLoopState);
        this.display.addListener(52, (Listener)this.eventLoopState);
        this.display.addListener(53, (Listener)this.eventLoopState);
    }

    private static void decimate(StackSample[] samples, int fromSize, int toSize) {
        int i = 0;
        while (i < toSize) {
            int j = ((i + 1) * fromSize - 1) / toSize;
            samples[i] = samples[j];
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.sleepMonitor;
        synchronized (object) {
            this.sleepMonitor.notify();
        }
    }

    private void logEvent(UiFreezeEvent event) {
        if (tracer != null) {
            tracer.trace("Logging " + event + "Prior events:\n" + this.eventHistory.extractAndClear());
        }
        if (this.logToErrorLog) {
            this.defaultLogger.log(event);
        }
        int i = 0;
        while (i < this.externalLoggers.size()) {
            IUiFreezeEventLogger currentLogger = this.externalLoggers.get(i);
            try {
                currentLogger.log(event);
            }
            catch (Throwable t) {
                this.externalLoggers.remove(i);
                --i;
                MonitoringPlugin.logError(NLS.bind((String)Messages.EventLoopMonitorThread_external_exception_error_1, (Object)currentLogger.getClass().getName()), t);
            }
            ++i;
        }
    }

    private static class EventHistory {
        private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
        private final EventInfo[] buffer;
        private int start;
        private int size;

        EventHistory(int capacity) {
            this.buffer = new EventInfo[capacity];
            int i = 0;
            while (i < capacity) {
                this.buffer[i] = new EventInfo();
                ++i;
            }
        }

        synchronized void recordEvent(int eventType, int detail, int nestingLevel) {
            int j = (this.start + this.size) % this.buffer.length;
            EventInfo event = this.buffer[j];
            event.timestamp = System.currentTimeMillis();
            event.eventType = eventType;
            event.detail = detail;
            event.nestingLevel = nestingLevel;
            if (this.size < this.buffer.length) {
                ++this.size;
            } else if (++this.start >= this.buffer.length) {
                this.start = 0;
            }
        }

        synchronized String extractAndClear() {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < this.size) {
                int j = (this.start + i) % this.buffer.length;
                EventInfo eventInfo = this.buffer[j];
                buf.append(TIME_FORMAT.format(new Date(eventInfo.timestamp)));
                buf.append(": ");
                switch (eventInfo.eventType) {
                    case 50: {
                        buf.append("PreEvent");
                        break;
                    }
                    case 51: {
                        buf.append("PostEvent");
                        break;
                    }
                    case 52: {
                        buf.append("PreExternalEventDispatch");
                        break;
                    }
                    case 53: {
                        buf.append("PostExternalEventDispatch");
                        break;
                    }
                    default: {
                        buf.append("Event ");
                        buf.append(eventInfo.eventType);
                    }
                }
                buf.append(' ');
                buf.append(eventInfo.detail);
                buf.append(" nesting level: ");
                buf.append(eventInfo.nestingLevel);
                buf.append('\n');
                ++i;
            }
            this.size = 0;
            return buf.toString();
        }

        private static class EventInfo {
            long timestamp;
            int eventType;
            int detail;
            int nestingLevel;

            private EventInfo() {
            }
        }
    }

    private class EventLoopState
    implements Listener {
        private int nestingLevel;
        private int[] nestingLevelStack = new int[64];
        private int nestingLevelStackSize;

        private EventLoopState() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 50: {
                    if (!this.doesEventIndicateResponsiveUI(event.detail)) break;
                    ++this.nestingLevel;
                    if (EventLoopMonitorThread.this.eventHistory != null) {
                        EventLoopMonitorThread.this.eventHistory.recordEvent(event.type, event.detail, this.nestingLevel);
                    }
                    EventLoopMonitorThread.this.handleEventTransition(true, true);
                    break;
                }
                case 51: {
                    if (!this.doesEventIndicateResponsiveUI(event.detail)) break;
                    if (--this.nestingLevel < 0) {
                        this.nestingLevel = 0;
                    }
                    if (EventLoopMonitorThread.this.eventHistory != null) {
                        EventLoopMonitorThread.this.eventHistory.recordEvent(event.type, event.detail, this.nestingLevel);
                    }
                    EventLoopMonitorThread.this.handleEventTransition(true, this.nestingLevel > 0);
                    break;
                }
                case 52: {
                    this.saveAndResetNestingLevel();
                    if (EventLoopMonitorThread.this.eventHistory != null) {
                        EventLoopMonitorThread.this.eventHistory.recordEvent(event.type, event.detail, this.nestingLevel);
                    }
                    EventLoopMonitorThread.this.handleEventTransition(true, false);
                    break;
                }
                case 53: {
                    this.restoreNestingLevel();
                    if (EventLoopMonitorThread.this.eventHistory != null) {
                        EventLoopMonitorThread.this.eventHistory.recordEvent(event.type, event.detail, this.nestingLevel);
                    }
                    EventLoopMonitorThread.this.handleEventTransition(false, this.nestingLevel > 0);
                    break;
                }
            }
        }

        private boolean doesEventIndicateResponsiveUI(int eventType) {
            switch (eventType) {
                case 12: 
                case 41: 
                case 45: {
                    return false;
                }
            }
            return true;
        }

        private void saveAndResetNestingLevel() {
            if (this.nestingLevelStackSize < this.nestingLevelStack.length) {
                this.nestingLevelStack[this.nestingLevelStackSize++] = this.nestingLevel;
                this.nestingLevel = 0;
            } else {
                MonitoringPlugin.logError(NLS.bind((String)Messages.EventLoopMonitorThread_max_event_loop_depth_exceeded_1, (Object)this.nestingLevelStack.length), null);
                EventLoopMonitorThread.this.shutdown();
            }
        }

        private void restoreNestingLevel() {
            this.nestingLevel = this.nestingLevelStackSize > 0 ? this.nestingLevelStack[--this.nestingLevelStackSize] : 0;
        }
    }

    public static class Parameters {
        public int longEventWarningThreshold;
        public int longEventErrorThreshold;
        public long deadlockThreshold;
        public int maxStackSamples;
        public boolean logToErrorLog;
        public String uiThreadFilter;
        public String noninterestingThreadFilter;

        public void checkParameters() throws IllegalArgumentException {
            StringBuilder problems = new StringBuilder();
            if (this.longEventWarningThreshold <= 0) {
                problems.append(EventLoopMonitorThread.NEW_LINE_AND_BULLET + NLS.bind((String)Messages.EventLoopMonitorThread_warning_threshold_error_1, (Object)this.longEventWarningThreshold));
            }
            if (this.longEventErrorThreshold < this.longEventWarningThreshold) {
                problems.append(EventLoopMonitorThread.NEW_LINE_AND_BULLET + NLS.bind((String)Messages.EventLoopMonitorThread_error_threshold_too_low_error_2, (Object)this.longEventErrorThreshold, (Object)this.longEventWarningThreshold));
            }
            if (this.deadlockThreshold <= 0L) {
                problems.append(EventLoopMonitorThread.NEW_LINE_AND_BULLET + NLS.bind((String)Messages.EventLoopMonitorThread_deadlock_error_1, (Object)this.deadlockThreshold));
            } else if (this.deadlockThreshold <= (long)this.longEventErrorThreshold) {
                problems.append(EventLoopMonitorThread.NEW_LINE_AND_BULLET + NLS.bind((String)Messages.EventLoopMonitorThread_deadlock_threshold_too_low_error_2, (Object)this.deadlockThreshold, (Object)this.longEventErrorThreshold));
            }
            if (problems.length() != 0) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.EventLoopMonitorThread_invalid_argument_error_1, (Object)problems.toString()));
            }
        }
    }
}

