/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.workbench.texteditor;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.ClickText;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClickText;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtText;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.OpenDeclaration;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.RulerClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerDoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerHover;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.SetCaretPosition;
import org.eclipse.rcptt.tesla.core.protocol.SetCursorOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection2;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.core.utils.TeslaUtils;
import org.eclipse.rcptt.tesla.ecl.model.SelectRange;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTEvents;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.jface.text.JFaceTextManager;
import org.eclipse.rcptt.tesla.jface.text.JFaceTextProcessor;
import org.eclipse.rcptt.tesla.workbench.texteditor.TextEditorMapper;
import org.eclipse.rcptt.util.swt.Events;
import org.eclipse.rcptt.util.swt.ShellUtilsProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class WorkbenchTexteditorProcessor
implements ITeslaCommandProcessor,
ISWTModelMapperExtension {
    private AbstractTeslaClient client;
    private SWTUIProcessor swtUIProcessor;
    private final AtomicInteger useTextViewer = new AtomicInteger(0);
    private ISWTUIPlayerExtension extension = new AbstractSWTUIPlayerExtension(){

        public GenericElementKind getKind(Object w) {
            if (WorkbenchTexteditorProcessor.this.useTextViewer.get() == 1) {
                if (WorkbenchTexteditorProcessor.this.isTextEditorStyledText(w)) {
                    return new GenericElementKind(ElementKind.TextViewer);
                }
                ElementKind rulerKind = WorkbenchTexteditorProcessor.getTextEditorRulerKind(w);
                if (rulerKind != null) {
                    return new GenericElementKind(rulerKind);
                }
            }
            return null;
        }

        public SWTUIElement select(SWTUIPlayer swtuiPlayer, PlayerSelectionFilter f) {
            if (f.kind.is(ElementKind.TextViewer)) {
                return swtuiPlayer.selectWidget(f, new Class[]{StyledText.class});
            }
            if (f.kind.in(new Object[]{ElementKind.LeftRuler, ElementKind.RightRuler, ElementKind.VerticalRuler, ElementKind.VerticalColumn})) {
                return swtuiPlayer.selectWidget(f, new Class[]{Canvas.class});
            }
            return null;
        }

        public String getRawText(SWTUIElement element) {
            return WorkbenchTexteditorProcessor.getTextEditorRulerText(element.unwrap());
        }
    };
    private static final Pattern clickText = Pattern.compile("(\\d+)(:(\\d+))?");

    public WorkbenchTexteditorProcessor() {
        SWTUIPlayer.addExtension((ISWTUIPlayerExtension)this.extension);
    }

    private static ElementKind getTextEditorRulerKind(Object widget) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    if (ruler instanceof CompositeRuler) {
                        return ElementKind.LeftRuler;
                    }
                    if (ruler instanceof OverviewRuler) {
                        return ElementKind.RightRuler;
                    }
                    return ElementKind.VerticalRuler;
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    return ElementKind.VerticalColumn;
                }
            }
        }
        return null;
    }

    private static String getTextEditorRulerText(Object widget) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    if (ruler instanceof CompositeRuler) {
                        return null;
                    }
                    if (ruler instanceof OverviewRuler) {
                        return null;
                    }
                    return null;
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    return column.getClass().getSimpleName();
                }
            }
        }
        return null;
    }

    private static IVerticalRuler getTextEditorRuler(Object widget) {
        if (widget instanceof Canvas) {
            List rulers = JFaceTextManager.getRulers();
            for (IVerticalRuler ruler : rulers) {
                if (widget.equals(ruler.getControl())) {
                    return ruler;
                }
                if (!(ruler instanceof CompositeRuler)) continue;
                Iterator iterator = ((CompositeRuler)ruler).getDecoratorIterator();
                while (iterator.hasNext()) {
                    IVerticalRulerColumn column;
                    Object next = iterator.next();
                    if (!(next instanceof IVerticalRulerColumn) || !widget.equals((column = (IVerticalRulerColumn)next).getControl())) continue;
                    return ruler;
                }
            }
        }
        return null;
    }

    protected boolean isTextEditorStyledText(Object widget) {
        TextViewer viewer;
        return widget instanceof StyledText && (viewer = JFaceTextManager.getViewer((StyledText)((StyledText)widget))) != null;
    }

    public String getFeatureID() {
        return "swt.workbench.texteditor";
    }

    public boolean isSelectorSupported(String kind) {
        if (kind.equals(ElementKind.TextViewer.name())) {
            return true;
        }
        return kind.equals(ElementKind.LeftRuler.name()) || kind.equals(ElementKind.RightRuler.name()) || kind.equals(ElementKind.VerticalRuler.name()) || kind.equals(ElementKind.VerticalColumn.name());
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        try {
            this.useTextViewer.set(1);
            SelectResponse selectResponse = this.getSWTUIProcessor().select(cmd, generator, mapper);
            return selectResponse;
        }
        finally {
            this.useTextViewer.set(0);
        }
    }

    public boolean isCommandSupported(Command cmd) {
        if (cmd instanceof SetCaretPosition || cmd instanceof SelectRange || cmd instanceof HoverAtText || cmd instanceof OpenDeclaration || cmd instanceof RulerClick || cmd instanceof RulerDoubleClick || cmd instanceof RulerHover) {
            return true;
        }
        return this.getSWTUIProcessor().isCommandSupported(cmd);
    }

    private SWTUIProcessor getSWTUIProcessor() {
        if (this.swtUIProcessor == null) {
            this.swtUIProcessor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        }
        return this.swtUIProcessor;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (command instanceof SetCursorOffset) {
            return this.handleSetCursorOffset((SetCursorOffset)command);
        }
        if (command instanceof SetTextSelection2) {
            return this.handleSetTextSelection((SetTextSelection2)command);
        }
        if (command instanceof HoverAtText) {
            return this.handleHoverAtText((HoverAtText)command);
        }
        if (command instanceof OpenDeclaration) {
            return this.handleOpenDeclaration((OpenDeclaration)command);
        }
        if (command instanceof RulerClick) {
            return this.handleRulerClick((RulerClick)command);
        }
        if (command instanceof RulerDoubleClick) {
            return this.handleRulerDoubleClick((RulerDoubleClick)command);
        }
        if (command instanceof RulerHover) {
            return this.handleRulerHover((RulerHover)command);
        }
        if (command instanceof ClickText) {
            return this.handleClickText((ClickText)command);
        }
        if (command instanceof DoubleClickText) {
            return this.handleDoubleClickText((DoubleClickText)command);
        }
        Response result = this.getSWTUIProcessor().executeCommand(command, mapper);
        if (result == null) {
            result = ((JFaceTextProcessor)this.client.getProcessor(JFaceTextProcessor.class)).executeCommand(command, mapper);
        }
        return result;
    }

    private static Point parseLineColumnCoords(String str) {
        Matcher m = clickText.matcher(str);
        if (!m.matches()) {
            return null;
        }
        if (m.group(3) == null) {
            return new Point(1, Integer.parseInt(str));
        }
        return new Point(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(3)));
    }

    private Response handleClickText(ClickText command) {
        String start = command.getStart();
        String end = command.getEnd();
        Element element = command.getElement();
        boolean isRange = end != null && end.length() > 0;
        Point startPoint = WorkbenchTexteditorProcessor.parseLineColumnCoords(start);
        Point endPoint = null;
        if (startPoint == null) {
            return SWTUIProcessor.failResponse((String)("Cannot parse position " + start));
        }
        if (isRange) {
            endPoint = WorkbenchTexteditorProcessor.parseLineColumnCoords(end);
            if (endPoint == null) {
                return SWTUIProcessor.failResponse((String)("Cannot parse position " + end));
            }
            SetTextSelection2 cmd = ProtocolFactory.eINSTANCE.createSetTextSelection2();
            cmd.setElement(element);
            cmd.setBlockMode(false);
            cmd.setEndLine(endPoint.x);
            cmd.setEndOffset(endPoint.y);
            cmd.setStartLine(startPoint.x);
            cmd.setEndLine(startPoint.y);
            return this.handleSetTextSelection(cmd);
        }
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        if (!(control instanceof StyledText)) {
            return SWTUIProcessor.failResponse((String)"Control is not a styled text");
        }
        final StyledText styledText = (StyledText)control;
        final int visibleOffset = this.getVisibleCaretOffset(styledText, startPoint.x, startPoint.y);
        if (visibleOffset == -1) {
            return SWTUIProcessor.failResponse((String)"Cannot click text at position %d:%d - it is either hidden, or out of document bounds");
        }
        this.getPlayer().exec("Click text", new Runnable(){

            @Override
            public void run() {
                int line = styledText.getLineAtOffset(visibleOffset);
                styledText.setTopIndex(line);
                Point point = styledText.getLocationAtOffset(visibleOffset);
                SWTEvents events = WorkbenchTexteditorProcessor.this.getPlayer().getEvents();
                events.sendFocus((org.eclipse.swt.widgets.Widget)styledText);
                events.sendAll((org.eclipse.swt.widgets.Widget)styledText, Events.createClick((Point)point));
                events.sendUnfocus((org.eclipse.swt.widgets.Widget)styledText);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    private Response handleDoubleClickText(DoubleClickText command) {
        String pos = command.getPosition();
        final int button = TeslaUtils.buttonNameToInt((String)command.getButton());
        Element element = command.getElement();
        Point lineCol = WorkbenchTexteditorProcessor.parseLineColumnCoords(pos);
        if (lineCol == null) {
            return SWTUIProcessor.failResponse((String)("Cannot parse position " + pos));
        }
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(element);
        org.eclipse.swt.widgets.Widget control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        if (!(control instanceof StyledText)) {
            return SWTUIProcessor.failResponse((String)"Control is not a styled text");
        }
        final StyledText styledText = (StyledText)control;
        final int visibleOffset = this.getVisibleCaretOffset(styledText, lineCol.x, lineCol.y);
        if (visibleOffset == -1) {
            return SWTUIProcessor.failResponse((String)"Cannot double-click text at position %d:%d - it is either hidden, or out of document bounds");
        }
        this.getPlayer().exec("Double-click text", new Runnable(){

            @Override
            public void run() {
                int line = styledText.getLineAtOffset(visibleOffset);
                styledText.setTopIndex(line);
                Point point = styledText.getLocationAtOffset(visibleOffset);
                SWTEvents events = WorkbenchTexteditorProcessor.this.getPlayer().getEvents();
                events.sendFocus((org.eclipse.swt.widgets.Widget)styledText);
                events.sendAll((org.eclipse.swt.widgets.Widget)styledText, Events.createDoubleClick((int)button, (int)0, (int)point.x, (int)point.y));
                events.sendUnfocus((org.eclipse.swt.widgets.Widget)styledText);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    private Response handleRulerClick(RulerClick command) {
        return this.sendRulerEvents(command.getElement(), command.getLine(), "Click ruler", Events.createClick((int)command.getButton(), (int)command.getStateMask(), (int)0, (int)0));
    }

    private Response sendRulerEvents(Element element, int line, String operationName, final Event ... events) {
        int y;
        BooleanResponse result = ProtocolFactory.eINSTANCE.createBooleanResponse();
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(element);
        final org.eclipse.swt.widgets.Widget control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        IVerticalRuler ruler = WorkbenchTexteditorProcessor.getTextEditorRuler(control);
        if (ruler == null) {
            return result;
        }
        final StyledText styledText = JFaceTextManager.getViewer((IVerticalRuler)ruler).getTextWidget();
        final int x = ((Canvas)control).getBounds().width / 2;
        try {
            y = this.getYCoordFromLine(styledText, line, ruler);
        }
        catch (CoreException e) {
            result.setStatus(ResponseStatus.FAILED);
            result.setMessage(e.getMessage());
            return result;
        }
        this.getPlayer().exec(operationName, new Runnable(){

            @Override
            public void run() {
                SWTUIPlayer player = WorkbenchTexteditorProcessor.this.getPlayer();
                Display display = player.getDisplay();
                SWTEvents eventSender = player.getEvents();
                player.addMouseWidgetInfo(control, x, y);
                styledText.forceFocus();
                try {
                    ShellUtilsProvider.getShellUtils().forceActive(styledText.getShell());
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                while (display.readAndDispatch()) {
                }
                eventSender.sendFocus(control);
                Event[] eventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    Event event = eventArray[n2];
                    event.widget = control;
                    event.display = display;
                    event.time = (int)System.currentTimeMillis();
                    event.x = x;
                    event.y = y;
                    eventSender.sendEvent(control, event);
                    ++n2;
                }
            }
        });
        return result;
    }

    private Response handleRulerDoubleClick(RulerDoubleClick command) {
        return this.sendRulerEvents(command.getElement(), command.getLine(), "Double-click ruler", Events.createDoubleClick((int)command.getButton(), (int)command.getStateMask(), (int)0, (int)0));
    }

    private Response handleRulerHover(RulerHover command) {
        Event mouseMove = new Event();
        mouseMove.stateMask = command.getStateMask();
        mouseMove.type = 5;
        Event mouseHover = SWTEvents.clone((Event)mouseMove);
        mouseHover.type = 32;
        return this.sendRulerEvents(command.getElement(), command.getLine(), "Hover ruler", mouseMove, mouseHover);
    }

    private static IStatus createInvalidRulerLineErr(int line) {
        return new Status(4, "org.eclipse.rcptt.tesla.workbench.texteditor", String.format("Line %d is not present on ruler. Probably it is folded or removed?", line));
    }

    private int getYCoordFromLine(StyledText text, int line, IVerticalRuler ruler) throws CoreException {
        if (ruler instanceof OverviewRuler) {
            OverviewRuler overviewRuler = (OverviewRuler)ruler;
            int y = 0;
            while (y < overviewRuler.getControl().getBounds().height) {
                int lineAtPixel = overviewRuler.toDocumentLineNumber(y) + 1;
                if (lineAtPixel == line) {
                    return y;
                }
                if (lineAtPixel > line) break;
                ++y;
            }
            throw new CoreException(WorkbenchTexteditorProcessor.createInvalidRulerLineErr(line));
        }
        int offset = this.getVisibleCaretOffset(text, line, 1);
        if (offset == -1) {
            throw new CoreException(WorkbenchTexteditorProcessor.createInvalidRulerLineErr(line));
        }
        text.setTopIndex(text.getLineAtOffset(offset));
        return text.getLocationAtOffset((int)offset).y + text.getLineHeight() / 2;
    }

    private Response handleOpenDeclaration(OpenDeclaration command) {
        org.eclipse.swt.widgets.Widget control;
        Element element = command.getElement();
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(element);
        if (widget != null && (control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget)) instanceof StyledText) {
            this.getPlayer().exec("Open declaration", new Runnable(){

                @Override
                public void run() {
                    StyledText styledText = (StyledText)control;
                    int currentOffset = styledText.getCaretOffset();
                    int line = styledText.getLineAtOffset(currentOffset);
                    styledText.setTopIndex(line);
                    Point point = styledText.getLocationAtOffset(currentOffset);
                    SWTEvents events = WorkbenchTexteditorProcessor.this.getPlayer().getEvents();
                    Event e = events.createEvent((org.eclipse.swt.widgets.Widget)styledText);
                    e.x = point.x;
                    e.y = point.y;
                    WorkbenchTexteditorProcessor.this.getPlayer().addMouseWidgetInfo((org.eclipse.swt.widgets.Widget)styledText, e.x, e.y);
                    try {
                        ShellUtilsProvider.getShellUtils().forceActive(styledText.getShell());
                    }
                    catch (CoreException exc) {
                        throw new RuntimeException(exc);
                    }
                    styledText.forceFocus();
                    e.stateMask = SWT.MOD1;
                    e.count = 1;
                    e.type = 5;
                    events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                    e.type = 32;
                    events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                    e.button = 1;
                    e.type = 3;
                    events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                    events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, 13);
                    e.type = 4;
                    events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                }
            });
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    private Response handleHoverAtText(final HoverAtText command) {
        BooleanResponse result = ProtocolFactory.eINSTANCE.createBooleanResponse();
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget);
        if (!(control instanceof StyledText)) {
            return result;
        }
        final StyledText styledText = (StyledText)control;
        final int visibleOffset = this.getVisibleCaretOffset(styledText, command.getLine(), command.getOffset());
        if (visibleOffset == -1) {
            result.setStatus(ResponseStatus.FAILED);
            result.setMessage(String.format("Cannot hover text at position %d:%d - it is either hidden, or out of document bounds", command.getLine(), command.getOffset()));
            return result;
        }
        this.getPlayer().exec("Hover at text offset", new Runnable(){

            @Override
            public void run() {
                int line = styledText.getLineAtOffset(visibleOffset);
                styledText.setTopIndex(line);
                Point point = styledText.getLocationAtOffset(visibleOffset);
                SWTEvents events = WorkbenchTexteditorProcessor.this.getPlayer().getEvents();
                Event e = events.createEvent((org.eclipse.swt.widgets.Widget)styledText);
                e.x = point.x;
                e.y = point.y;
                WorkbenchTexteditorProcessor.this.getPlayer().addMouseWidgetInfo((org.eclipse.swt.widgets.Widget)styledText, e.x, e.y);
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText.getShell(), 27);
                try {
                    ShellUtilsProvider.getShellUtils().forceActive(styledText.getShell());
                }
                catch (CoreException exc) {
                    throw new RuntimeException(exc);
                }
                styledText.forceFocus();
                e.stateMask = command.getStateMask();
                e.type = 5;
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                e.type = 32;
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
            }
        });
        return result;
    }

    protected Response handleSetTextSelection(final SetTextSelection2 command) {
        final SWTUIElement element = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("set text selection", new Runnable(){

            @Override
            public void run() {
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                int startOffset = WorkbenchTexteditorProcessor.this.getVisibleCaretOffset((StyledText)rawWidget, command.getStartLine(), command.getStartOffset());
                int endOffset = WorkbenchTexteditorProcessor.this.getVisibleCaretOffset((StyledText)rawWidget, command.getEndLine(), command.getEndOffset());
                StyledText text = (StyledText)rawWidget;
                text.forceFocus();
                text.setSelection(startOffset, endOffset);
                if (text.getAccessible() != null) {
                    text.getAccessible().textSelectionChanged();
                }
                Event event = new Event();
                event.x = startOffset;
                event.y = endOffset - startOffset;
                event.type = 13;
                WorkbenchTexteditorProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)text, event);
            }
        });
        return response;
    }

    private Response handleSetCursorOffset(final SetCursorOffset command) {
        org.eclipse.swt.widgets.Widget control;
        Element element = command.getElement();
        SWTUIElement widget = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(element);
        if (widget != null && (control = PlayerWrapUtils.unwrapWidget((SWTUIElement)widget)) instanceof StyledText) {
            this.getPlayer().exec("Set text offset", new Runnable(){

                @Override
                public void run() {
                    int offset = command.getOffset();
                    int line = command.getLine();
                    int caretOffset = WorkbenchTexteditorProcessor.this.getVisibleCaretOffset((StyledText)control, line, offset);
                    StyledText styledText = (StyledText)control;
                    styledText.setFocus();
                    styledText.setCaretOffset(caretOffset);
                    if (styledText.getAccessible() != null) {
                        styledText.getAccessible().textCaretMoved(caretOffset);
                    }
                }
            });
        }
        return ProtocolFactory.eINSTANCE.createBooleanResponse();
    }

    protected int getVisibleCaretOffset(StyledText control, int line, int offset) {
        TextViewer viewer = JFaceTextManager.getViewer((StyledText)control);
        IDocument document = viewer.getDocument();
        try {
            int lineOffset = document.getLineOffset(line - 1);
            int len = document.getLineLength(line - 1);
            document.get(lineOffset, len);
            int tabs = control.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i <= lineOffset + len) {
                if (column == offset - 1) {
                    column = i - lineOffset;
                    break;
                }
                column = '\t' == document.getChar(i) ? (column += tabs - (tabs == 0 ? 0 : column % tabs)) : ++column;
                ++i;
            }
            return viewer.modelOffset2WidgetOffset(lineOffset + column);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
            return -1;
        }
    }

    private SWTUIPlayer getPlayer() {
        return this.getSWTUIProcessor().getPlayer();
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return this.getSWTUIProcessor().preExecute(command, previousStatus, info);
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
    }

    public boolean isInactivityRequired() {
        return false;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        List managers = JFaceTextManager.isSomeHoverManagerActive();
        for (AbstractHoverInformationControlManager mgr : managers) {
            Q7WaitUtils.updateInfo((String)"text.hover", (String)mgr.getClass().getName(), (Q7WaitInfoRoot)info);
        }
        return managers.isEmpty();
    }

    public void clean() {
    }

    public void terminate() {
        SWTUIPlayer.removeExtension((ISWTUIPlayerExtension)this.extension);
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }

    private int[] getCursorOffset(StyledText text, int offset) {
        int[] result = null;
        try {
            TextViewer viewer = JFaceTextManager.getViewer((StyledText)text);
            IDocument document = viewer.getDocument();
            int realOffset = viewer.widgetOffset2ModelOffset(offset);
            int lineAtOffset = document.getLineOfOffset(realOffset);
            int offsetAtLine = document.getLineOffset(lineAtOffset);
            int tabWidth = text.getTabs();
            int column = 0;
            int i = offsetAtLine;
            while (i < realOffset) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            result = new int[]{lineAtOffset + 1, column + 1};
        }
        catch (BadLocationException e) {
            TeslaCore.log((Throwable)e);
        }
        return result;
    }

    public Widget mapExtraValues(SWTUIElement element, Widget result) {
        return TextEditorMapper.mapExtraValues(element, result);
    }
}

