/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.refactoring.JUnitRenameParticipant;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class TypeRenameParticipant
extends JUnitRenameParticipant {
    private IType fType;

    protected boolean initialize(Object element) {
        this.fType = (IType)element;
        return this.isTestOrTestSuite();
    }

    protected boolean isTestOrTestSuite() {
        try {
            return CoreTestSearchEngine.isTestOrTestSuite((IType)this.fType);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void createChangeForConfig(JUnitRenameParticipant.ChangeList list, LaunchConfigurationContainer config) throws CoreException {
        String mainType;
        String typeName = this.fType.getFullyQualifiedName('.');
        if (typeName.equals(mainType = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null))) {
            int index = mainType.lastIndexOf(46);
            if (index == -1) {
                String string = "";
            }
            String prefix = mainType.substring(0, index + 1);
            String newValue = String.valueOf(prefix) + this.getNewName();
            list.addAttributeChange(config, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, newValue);
            list.addRenameChangeIfNeeded(config, this.fType.getElementName());
        }
    }
}

