/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.graphics.Image;

public class CommitLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private GitDateFormatter dateFormatter;
    private boolean showEmail;
    private RevCommit lastCommit;
    private PersonIdent lastAuthor;
    private PersonIdent lastCommitter;
    private GitDateFormatter.Format format = GitDateFormatter.Format.LOCALELOCAL;

    public String getColumnText(Object element, int columnIndex) {
        PersonIdent committer;
        PersonIdent author;
        RevCommit c = (RevCommit)element;
        if (columnIndex == 0) {
            return c.getId().abbreviate(7).name();
        }
        if (columnIndex == 1) {
            return c.getShortMessage();
        }
        if ((columnIndex == 2 || columnIndex == 3) && (author = this.authorOf(c)) != null) {
            switch (columnIndex) {
                case 2: {
                    if (this.showEmail) {
                        return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + '>';
                    }
                    return author.getName();
                }
                case 3: {
                    return this.getDateFormatter().formatDate(author);
                }
            }
        }
        if ((columnIndex == 4 || columnIndex == 5) && (committer = this.committerOf(c)) != null) {
            switch (columnIndex) {
                case 4: {
                    if (this.showEmail) {
                        return String.valueOf(committer.getName()) + " <" + committer.getEmailAddress() + '>';
                    }
                    return committer.getName();
                }
                case 5: {
                    return this.getDateFormatter().formatDate(committer);
                }
            }
        }
        return "";
    }

    private GitDateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new GitDateFormatter(this.format);
        }
        return this.dateFormatter;
    }

    private PersonIdent authorOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastAuthor;
    }

    private PersonIdent committerOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastCommitter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void setRelativeDate(boolean relative) {
        this.dateFormatter = null;
        this.format = relative ? GitDateFormatter.Format.RELATIVE : GitDateFormatter.Format.LOCALELOCAL;
    }

    public void setShowEmailAddresses(boolean showEmail) {
        this.showEmail = showEmail;
    }
}

