/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchMonitor;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.events.AutEventManager;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.StartLevelSupport;
import org.eclipse.rcptt.launching.internal.target.Q7Target;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.Versions;
import org.osgi.framework.Version;

public class Q7ExternalLaunchDelegate
extends EclipseApplicationLaunchConfiguration {
    private static final String ATTR_D32 = "-d32";
    private static final String Q7_LAUNCHING_AUT = "RCPTT: Launching AUT: ";
    private static final String SECURE_STORAGE_FILE_NAME = "secure_storage";
    private ILaunch launch;
    private static final String KEY_BUNDLES_TO_LAUNCH = "bundlesToLaunch";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block7: {
            this.launch = launch;
            SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (int)2000);
            Q7ExtLaunchMonitor waiter = new Q7ExtLaunchMonitor(launch);
            try {
                super.launch(configuration, mode, launch, (IProgressMonitor)subm.newChild(1000));
                waiter.wait((IProgressMonitor)subm.newChild(1000), TeslaLimits.getAUTStartupTimeout() / 1000);
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.getDefault().log("RCPTT: Failed to Launch AUT: " + configuration.getName() + " cause " + e.getMessage(), e);
                waiter.handle((Exception)((Object)e));
                if (!e.getStatus().matches(8)) {
                    throw e;
                }
                waiter.dispose();
                break block7;
            }
            catch (RuntimeException e) {
                try {
                    Q7ExtLaunchingPlugin.getDefault().log("RCPTT: Failed to Launch AUT: " + configuration.getName() + " cause " + e.getMessage(), e);
                    waiter.handle(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    waiter.dispose();
                    throw throwable;
                }
            }
            waiter.dispose();
        }
        monitor.done();
    }

    protected void manageLaunch(ILaunch launch) {
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (Q7ExternalLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (Q7ExternalLaunchDelegate.isHeadless(configuration)) {
            return true;
        }
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.beginTask("", 4);
        if (!Q7ExternalLaunchDelegate.isHeadless(configuration) && !super.preLaunchCheck(configuration, mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
            monitor.done();
            return false;
        }
        this.waitForClearBundlePool(monitor);
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        if (info.target != null) {
            monitor.done();
            return true;
        }
        ITargetPlatformHelper target = Q7TargetPlatformManager.getTarget(configuration, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
        if (monitor.isCanceled()) {
            this.removeTargetPlatform(configuration);
            return false;
        }
        info.target = target;
        MultiStatus error = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Target platform initialization failed  for " + configuration.getName(), null);
        error.add(target.getStatus());
        if (!error.isOK()) {
            if (monitor.isCanceled()) {
                this.removeTargetPlatform(configuration);
                return false;
            }
            Q7ExtLaunchingPlugin.log((IStatus)error);
            this.removeTargetPlatform(configuration);
            throw new CoreException((IStatus)error);
        }
        boolean haveAUT = false;
        OSArchitecture configArch = null;
        StringBuilder detectMsg = new StringBuilder();
        OSArchitecture architecture = configArch == null ? ((ITargetPlatformHelper)info.target).detectArchitecture(true, detectMsg) : configArch;
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": Detected AUT architecture is " + architecture.name() + "." + detectMsg.toString());
        IVMInstall install = VMHelper.getVMInstall((ILaunchConfiguration)configuration);
        OSArchitecture jvmArch = JDTUtils.detect(install);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": Selected JVM is " + install.getInstallLocation().toString() + " detected architecture is " + jvmArch.name());
        boolean canRun32bit = false;
        if (jvmArch.equals((Object)architecture) || jvmArch.equals((Object)OSArchitecture.x86_64) && (canRun32bit = JDTUtils.canRun32bit(install))) {
            haveAUT = true;
        }
        if (!haveAUT && architecture != OSArchitecture.Unknown && target.detectArchitecture(false, new StringBuilder()) == OSArchitecture.Unknown) {
            Q7ExtLaunchingPlugin.getDefault().info("Cannot determine AUT architecture, sticking to architecture of selected JVM, which is " + jvmArch.name());
            haveAUT = true;
        }
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": JVM and AUT architectures are compatible: " + haveAUT + "." + (jvmArch.equals((Object)OSArchitecture.x86_64) ? " JVM is 64bit and support running 32bit: " + canRun32bit : ""));
        if (!haveAUT) {
            haveAUT = Q7ExternalLaunchDelegate.updateJVM(configuration, architecture, (ITargetPlatformHelper)info.target);
            if (!haveAUT) {
                JDTUtils.registerCurrentJVM();
                haveAUT = Q7ExternalLaunchDelegate.updateJVM(configuration, architecture, (ITargetPlatformHelper)info.target);
            }
            if (haveAUT) {
                Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + "JVM configuration is updated to compatible one: " + VMHelper.getVMInstall((ILaunchConfiguration)configuration).getInstallLocation());
            }
        }
        if (!haveAUT) {
            String errorMessage = "The " + configuration.getName() + " requires " + (OSArchitecture.x86.equals((Object)architecture) ? "32 bit" : "64 bit") + " Java VM which cannot be found.";
            Q7ExtLaunchingPlugin.getDefault().log(errorMessage, null);
            this.removeTargetPlatform(configuration);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", errorMessage, null));
        }
        monitor.done();
        return true;
    }

    private void removeTargetPlatform(ILaunchConfiguration configuration) throws CoreException {
        String targetPlatformName = Q7TargetPlatformManager.getTargetPlatformName(configuration);
        Q7TargetPlatformManager.delete(targetPlatformName);
        LaunchInfoCache.remove((ILaunchConfiguration)configuration);
        TargetPlatformManager.deleteTargetPlatform(targetPlatformName);
    }

    private static boolean isHeadless(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("q7.headless.launch", false);
    }

    private void waitForClearBundlePool(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)"q7.clean.bundle.pool.job", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Exception e1) {
            Q7ExtLaunchingPlugin.getDefault().log("Failed to wait for bundle pool clear job", e1);
        }
    }

    private static boolean updateJVM(ILaunchConfiguration configuration, OSArchitecture architecture, ITargetPlatformHelper target) throws CoreException {
        IVMInstall jvmInstall = null;
        OSArchitecture jvmArch = OSArchitecture.Unknown;
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        boolean haveArch = false;
        IVMInstallType[] iVMInstallTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] installs;
            IVMInstallType ivmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = installs = ivmInstallType.getVMInstalls();
            int n3 = installs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall ivmInstall = iVMInstallArray[n4];
                jvmArch = JDTUtils.detect(ivmInstall);
                if (jvmArch.equals((Object)architecture) || jvmArch.equals((Object)OSArchitecture.x86_64) && JDTUtils.canRun32bit(ivmInstall)) {
                    jvmInstall = ivmInstall;
                    haveArch = true;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (haveArch) {
            OSArchitecture autArch;
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            String vmArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, Q7LaunchDelegateUtils.getJoinedVMArgs(target, null));
            String archAttrValue = configuration.getAttribute("com.xored.launching.common.attrArch", "");
            OSArchitecture configArch = archAttrValue.isEmpty() ? null : OSArchitecture.valueOf(archAttrValue);
            OSArchitecture oSArchitecture = autArch = configArch == null ? target.detectArchitecture(true, null) : configArch;
            if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
                vmArgs = vmArgs != null && !vmArgs.contains(ATTR_D32) ? String.valueOf(vmArgs) + " -d32" : ATTR_D32;
            }
            if (vmArgs != null && vmArgs.length() > 0) {
                vmArgs = UpdateVMArgs.updateAttr(vmArgs);
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", jvmInstall.getVMInstallType().getId(), jvmInstall.getName()));
            String programArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, LaunchArgumentsHelper.getInitialProgramArguments().trim());
            if (programArgs.contains("${target.arch}")) {
                programArgs = programArgs.replace("${target.arch}", autArch.name());
            } else if (programArgs.contains("-arch")) {
                int pos = programArgs.indexOf("-arch ") + 6;
                int len = 6;
                int pos2 = programArgs.indexOf("x86_64", pos);
                if (pos2 == -1) {
                    len = 3;
                    pos2 = programArgs.indexOf("x86", pos);
                }
                if (pos2 != -1) {
                    programArgs = String.valueOf(programArgs.substring(0, pos)) + autArch.name() + programArgs.substring(pos2 + len, programArgs.length());
                }
            } else {
                programArgs = String.valueOf(programArgs) + " -arch " + autArch.name();
            }
            if (programArgs.length() > 0) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
            }
            workingCopy.doSave();
            return true;
        }
        return false;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    private String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        String jarPath = target.getEquinoxStartupPath("org.eclipse.equinox.launcher");
        if (jarPath == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(jarPath);
        String bootstrap = configuration.getAttribute("bootstrap", "");
        StringTokenizer tok = new StringTokenizer(Q7ExternalLaunchDelegate.getSubstitutedString(bootstrap), ",");
        while (tok.hasMoreTokens()) {
            entries.add(tok.nextToken().trim());
        }
        return entries.toArray(new String[entries.size()]);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = this.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup;
            throw new CoreException(LauncherUtils.createErrorStatus((String)message));
        }
        return classpath;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        if (info.programArgs != null) {
            return info.programArgs;
        }
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.addAll(Arrays.asList(super.getProgramArguments(configuration)));
        try {
            File config = new File(this.getConfigDir(configuration), "config.ini");
            Properties props = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(config));
            props.load(in);
            in.close();
            File location = target.getQ7Target().getInstallLocation();
            if (location != null) {
                props.setProperty("osgi.install.area", location.getAbsolutePath());
            }
            props.setProperty("osgi.bundles", Q7LaunchDelegateUtils.computeOSGiBundles(Q7ExternalLaunchDelegate.getBundlesToLaunch((LaunchInfoCache.CachedInfo)info).latestVersionsOnly));
            OriginalOrderProperties properties = target.getConfigIniProperties();
            properties.setBeginAdd(true);
            properties.putAll((Map<?, ?>)props);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(config));
            properties.store(out, "Configuration File");
            out.close();
        }
        catch (IOException e) {
            throw new CoreException(Q7ExtLaunchingPlugin.status(e));
        }
        String override = configuration.getAttribute("override-secure-storage", null);
        if (override == null || "true".equals(override)) {
            programArgs.add("-eclipse.keyring");
            programArgs.add(String.valueOf(this.getConfigDir(configuration).toString()) + '/' + SECURE_STORAGE_FILE_NAME);
        }
        IVMInstall install = VMHelper.getVMInstall((ILaunchConfiguration)configuration);
        programArgs.add("-vm");
        programArgs.add(install.getInstallLocation().toString());
        info.programArgs = programArgs.toArray(new String[programArgs.size()]);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + configuration.getName() + ": AUT command line arguments is set to: " + Arrays.toString(info.programArgs));
        return info.programArgs;
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)config);
        if (info.vmArgs != null) {
            return info.vmArgs;
        }
        List<String> args = new ArrayList<String>(Arrays.asList(super.getVMArguments(config)));
        Iterables.removeIf(args, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains("-Declipse.pde.launch=true");
            }
        });
        args.add("-Dq7id=" + this.launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID"));
        args.add("-Dq7EclPort=" + AutEventManager.INSTANCE.getPort());
        TargetPlatformHelper target = (TargetPlatformHelper)((ITargetPlatformHelper)info.target);
        IPluginModelBase hook = target.getWeavingHook();
        if (hook == null) {
            throw new CoreException(Q7ExtLaunchingPlugin.status("No org.eclipse.equinox.weaving.hook plugin"));
        }
        OriginalOrderProperties properties = target.getConfigIniProperties();
        args = UpdateVMArgs.addHook(args, hook, properties.getProperty("osgi.framework.extensions"));
        args.add("-Declipse.vmargs=" + Joiner.on((String)"\n").join(args) + "\n");
        info.vmArgs = args.toArray(new String[args.size()]);
        Q7ExtLaunchingPlugin.getDefault().info(Q7_LAUNCHING_AUT + config.getName() + ": AUT JVM arguments is set to : " + Arrays.toString(info.vmArgs));
        return info.vmArgs;
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        super.preLaunchCheck(configuration, launch, (IProgressMonitor)subm.newChild(50));
        if (monitor.isCanceled()) {
            return;
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        BundlesToLaunch bundlesToLaunch = Q7ExternalLaunchDelegate.collectBundles(target.getQ7Target(), (IProgressMonitor)subm.newChild(50));
        Q7ExternalLaunchDelegate.setBundlesToLaunch(info, bundlesToLaunch);
        this.removeDuplicatedModels(bundlesToLaunch.fModels, target.getQ7Target());
        Q7LaunchDelegateUtils.setDelegateFields(this, bundlesToLaunch.fModels, bundlesToLaunch.fAllBundles);
        this.copyConfiguratonFiles(configuration, info);
        monitor.done();
    }

    private void removeDuplicatedModels(Map<IPluginModelBase, String> fModels, Q7Target target) {
        String path = target.getInstallLocation().getAbsolutePath();
        ArrayList<IPluginModelBase> keysForRemove = new ArrayList<IPluginModelBase>();
        HashMap<UniquePluginModel, IPluginModelBase> cache = new HashMap<UniquePluginModel, IPluginModelBase>();
        for (Map.Entry<IPluginModelBase, String> entry : fModels.entrySet()) {
            IPluginModelBase model = entry.getKey();
            UniquePluginModel uniqueModel = new UniquePluginModel(model);
            IPluginModelBase secondModel = (IPluginModelBase)cache.get(uniqueModel);
            if (secondModel != null) {
                if (secondModel.getInstallLocation().contains(path)) {
                    keysForRemove.add(secondModel);
                    continue;
                }
                keysForRemove.add(model);
                continue;
            }
            cache.put(uniqueModel, model);
        }
        for (IPluginModelBase key : keysForRemove) {
            fModels.remove(key);
        }
    }

    public static boolean isQ7BundleContainer(ITargetLocation container) {
        URI[] uris;
        if (!(container instanceof IUBundleContainer)) {
            return false;
        }
        URI[] uRIArray = uris = ((IUBundleContainer)container).getRepositories();
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (!uri.getScheme().equals("platform") || !uri.getPath().startsWith("/plugin/org.eclipse.rcptt")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static BundlesToLaunch collectBundles(Q7Target target, IProgressMonitor monitor) {
        TargetBundle bundle;
        int n;
        int n2;
        TargetBundle[] targetBundleArray;
        BundlesToLaunchCollector collector = new BundlesToLaunchCollector();
        SubMonitor subm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Collecting bundles", (int)3000);
        SubMonitor install = subm.newChild(1000);
        if (target.getInstall() != null) {
            Map<String, BundleStart> bundlesFromConfig = target.getInstall().configIniBundles();
            TargetBundle[] installationBundles = target.getInstall().getBundles();
            install.beginTask("Scanning " + target.getInstall().getInstallLocation(), installationBundles.length);
            targetBundleArray = target.getInstall().getBundles();
            n2 = targetBundleArray.length;
            n = 0;
            while (n < n2) {
                bundle = targetBundleArray[n];
                BundleStart hint = (BundleStart)Objects.firstNonNull((Object)bundlesFromConfig.get(bundle.getBundleInfo().getSymbolicName()), (Object)BundleStart.fromBundle(bundle.getBundleInfo()));
                collector.addInstallationBundle(bundle, hint);
                install.worked(1);
                ++n;
            }
        }
        install.done();
        SubMonitor pluginsDirMonitor = subm.newChild(1000);
        if (target.pluginsDir != null) {
            TargetBundle[] bundles = target.pluginsDir.getBundles();
            pluginsDirMonitor.beginTask("Scanning " + target.pluginsDir, bundles.length);
            targetBundleArray = bundles;
            n2 = bundles.length;
            n = 0;
            while (n < n2) {
                bundle = targetBundleArray[n];
                collector.addPluginBundle(bundle);
                pluginsDirMonitor.worked(1);
                ++n;
            }
        }
        pluginsDirMonitor.done();
        SubMonitor extrasMonitor = subm.newChild(1000);
        extrasMonitor.beginTask("Injecting RCPTT runtime", 1);
        for (ITargetLocation extra : target.getExtras()) {
            TargetBundle[] targetBundleArray2 = extra.getBundles();
            int n3 = targetBundleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TargetBundle bundle2 = targetBundleArray2[n4];
                collector.addExtraBundle(bundle2);
                ++n4;
            }
            extrasMonitor.worked(1);
        }
        extrasMonitor.done();
        return new BundlesToLaunch(collector.rejectedBundles, collector.plugins, collector.latestVersions);
    }

    public static void setBundlesToLaunch(LaunchInfoCache.CachedInfo info, BundlesToLaunch bundles) {
        info.data.put(KEY_BUNDLES_TO_LAUNCH, bundles);
    }

    public static BundlesToLaunch getBundlesToLaunch(LaunchInfoCache.CachedInfo info) {
        return (BundlesToLaunch)info.data.get(KEY_BUNDLES_TO_LAUNCH);
    }

    private static IPluginModelBase[] getModels(TargetBundle bundle) {
        try {
            return new PDEState(new URL[]{new URL(String.format("file://%s", bundle.getBundleInfo().getLocation().getPath()))}, true, true, (IProgressMonitor)new NullProgressMonitor()).getTargetModels();
        }
        catch (MalformedURLException e) {
            Q7ExtLaunchingPlugin.log(Q7ExtLaunchingPlugin.status("Problem in resolving AUT bundle " + bundle, e));
            return new IPluginModelBase[0];
        }
    }

    private static Version version(IPluginModelBase plugin) {
        try {
            return new Version(plugin.getPluginBase().getVersion());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Version.emptyVersion;
        }
    }

    private void copyConfiguratonFiles(ILaunchConfiguration configuration, LaunchInfoCache.CachedInfo info) throws CoreException {
        File[] listFiles;
        String targetPlatformPath = ((ITargetPlatformHelper)info.target).getTargetPlatformProfilePath();
        File configFolder = new File(targetPlatformPath, "configuration");
        if (!configFolder.exists()) {
            return;
        }
        HashSet<String> filter = new HashSet<String>(Arrays.asList(new String(".p2;org.eclipse.core.runtime;org.eclipse.equinox.app;org.eclipse.equinox.simpleconfigurator;org.eclipse.equinox.source;org.eclipse.osgi;org.eclipse.ui.intro.universal;org.eclipse.update;config.ini;.settings;org.eclipse.help.base").split(";")));
        File target = this.getConfigDir(configuration);
        File[] fileArray = listFiles = configFolder.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!filter.contains(file.getName())) {
                if (file.isDirectory()) {
                    FileUtil.copyFiles((File)file, (File)new File(target, file.getName()));
                } else {
                    FileUtil.copyFiles((File)file, (File)target);
                }
            }
            ++n2;
        }
    }

    public static class BundlesToLaunch {
        public final Map<IPluginModelBase, BundleStart> resolvedBundles;
        public final Map<IPluginModelBase, BundleStart> latestVersionsOnly;
        public final Map<IPluginModelBase, String> fModels;
        public final Map<String, Object> fAllBundles;

        public BundlesToLaunch(Set<String> rejectedBundles, Map<IPluginModelBase, BundleStart> plugins, final Map<String, IPluginModelBase> latestVersions) {
            this.resolvedBundles = plugins;
            this.latestVersionsOnly = Maps.filterKeys(this.resolvedBundles, (Predicate)new Predicate<IPluginModelBase>(){

                public boolean apply(IPluginModelBase input) {
                    return latestVersions.get(Q7LaunchDelegateUtils.id(input)) == input;
                }
            });
            this.fAllBundles = new HashMap<String, IPluginModelBase>(latestVersions);
            this.fModels = new HashMap<IPluginModelBase, String>(Maps.transformValues(this.resolvedBundles, (Function)new Function<BundleStart, String>(){

                public String apply(BundleStart input) {
                    return input.toModelString();
                }
            }));
        }
    }

    public static class BundlesToLaunchCollector {
        private final Set<String> idsToSkip = new HashSet<String>();
        private final Set<String> rejectedBundles = new LinkedHashSet<String>();
        private final Map<IPluginModelBase, BundleStart> plugins = new HashMap<IPluginModelBase, BundleStart>();
        private final Map<String, IPluginModelBase> latestVersions = new HashMap<String, IPluginModelBase>();

        private void addInstallationBundle(TargetBundle bundle, BundleStart hint) {
            IPluginModelBase[] iPluginModelBaseArray = Q7ExternalLaunchDelegate.getModels(bundle);
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase base = iPluginModelBaseArray[n2];
                this.addInstallationBundle(base, hint);
                ++n2;
            }
        }

        public void addInstallationBundle(IPluginModelBase base, BundleStart hint) {
            String id = Q7LaunchDelegateUtils.id(base);
            this.idsToSkip.add(id);
            this.put(base, StartLevelSupport.getStartInfo(base, hint));
        }

        private void addPluginBundle(TargetBundle bundle) {
            IPluginModelBase[] iPluginModelBaseArray = Q7ExternalLaunchDelegate.getModels(bundle);
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase base = iPluginModelBaseArray[n2];
                String id = Q7LaunchDelegateUtils.id(base);
                if (!this.idsToSkip.contains(id)) {
                    this.put(base, StartLevelSupport.getStartInfo(base, BundleStart.DEFAULT));
                }
                ++n2;
            }
        }

        public void addExtraBundle(TargetBundle bundle) {
            IPluginModelBase[] iPluginModelBaseArray = Q7ExternalLaunchDelegate.getModels(bundle);
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase base = iPluginModelBaseArray[n2];
                this.put(base, StartLevelSupport.getStartInfo(base, BundleStart.DEFAULT));
                ++n2;
            }
        }

        public BundlesToLaunch getResult() {
            return new BundlesToLaunch(this.rejectedBundles, this.plugins, this.latestVersions);
        }

        private void put(IPluginModelBase plugin, BundleStart start) {
            String id = Q7LaunchDelegateUtils.id(plugin);
            if (id.equals("org.eclipse.equinox.weaving.aspectj") || id.equals("org.aspectj.runtime") || id.equals("org.eclipse.equinox.weaving.hook")) {
                Iterables.removeIf(this.plugins.entrySet(), this.isEqualsId(id));
                this.latestVersions.remove(id);
            }
            this.plugins.put(plugin, start);
            IPluginModelBase existing = this.latestVersions.get(id);
            if (existing == null || Versions.isGreater((Version)Q7ExternalLaunchDelegate.version(plugin), (Version)Q7ExternalLaunchDelegate.version(existing))) {
                this.latestVersions.put(id, plugin);
            }
        }

        private Predicate<Map.Entry<IPluginModelBase, BundleStart>> isEqualsId(final String id) {
            return new Predicate<Map.Entry<IPluginModelBase, BundleStart>>(){

                public boolean apply(Map.Entry<IPluginModelBase, BundleStart> input) {
                    return id.equals(Q7LaunchDelegateUtils.id(input.getKey()));
                }
            };
        }
    }

    public class UniquePluginModel {
        private String name;
        private Version version;

        public UniquePluginModel(IPluginModelBase model) {
            this.version = model.getBundleDescription().getVersion();
            this.name = model.getBundleDescription().getName();
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.version == null ? 0 : this.version.hashCode());
            return 0;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof UniquePluginModel)) {
                return false;
            }
            UniquePluginModel uniquePluginModel = (UniquePluginModel)object;
            return uniquePluginModel.name.equals(this.name) && uniquePluginModel.version.equals((Object)this.version);
        }
    }
}

