/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.fls.gear;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.EagerFloatingState;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.FlsGear;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.api.io.Hashes;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.base.io.MD5Hashes;
import org.eclipse.passage.lic.base.io.PathKeyKeeper;
import org.eclipse.passage.lic.base.registry.ReadOnlyRegistry;
import org.eclipse.passage.lic.bc.BcStreamCodec;
import org.eclipse.passage.lic.licenses.model.transport.XmiConditionTransport;

final class PassageFlsGear
implements FlsGear {
    private final Registry<StringServiceId, Hashes> hashes = new ReadOnlyRegistry((Service)new MD5Hashes());
    private EagerFloatingState state;
    static final PassageFlsGear gear = new PassageFlsGear();

    PassageFlsGear() {
    }

    public HashesRegistry hashes() {
        return () -> this.hashes;
    }

    public KeyKeeper keyKeper(LicensedProduct product, Supplier<Path> residense) {
        return new PathKeyKeeper(product, residense);
    }

    public StreamCodec codec(LicensedProduct product) {
        return new BcStreamCodec(() -> product);
    }

    public ConditionTransport transport(ContentType contentType) {
        return new XmiConditionTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatingState state(Supplier<Path> storage) {
        if (this.state == null) {
            PassageFlsGear passageFlsGear = this;
            synchronized (passageFlsGear) {
                if (this.state == null) {
                    this.state = new EagerFloatingState(storage);
                }
            }
        }
        return this.state;
    }
}

