/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.jetty.interaction.JettyCommands;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;
import org.osgi.framework.BundleContext;

public abstract class Command
implements JettyCommands {
    protected final Scope scope;
    private final String[] names;

    protected Command(Scope scope, String[] names) {
        this.scope = scope;
        this.names = names;
    }

    protected Command(Scope scope, List<String> names) {
        this(scope, names.toArray(new String[names.size()]));
    }

    public final Scope scope() {
        return this.scope;
    }

    @Override
    public final void register(BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("osgi.command.scope", this.scope.id());
        properties.put("osgi.command.function", this.names);
        context.registerService(this.getClass().getName(), (Object)this, properties);
    }

    protected final void reportDiagnostic(Diagnostic diagnostic) {
        if (new NoErrors().test(diagnostic)) {
            return;
        }
        System.out.printf("\n%s\n", new DiagnosticExplained(diagnostic).get());
    }

    @Override
    public final List<String> names() {
        return this.commands().stream().map(name -> this.scope.id() + ":" + name).collect(Collectors.toList());
    }

    protected abstract List<String> commands();

    protected static abstract class Name
    implements Supplier<List<String>> {
        private final List<String> names;

        protected Name(String name) {
            this(Collections.singletonList(name));
        }

        protected Name(List<String> names) {
            this.names = names;
        }

        @Override
        public List<String> get() {
            return this.names;
        }
    }
}

