/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.Passage;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.FrameworkAware;
import org.eclipse.passage.lic.internal.base.access.Access;

public final class BasePassage
implements Passage {
    private final FrameworkAware delegate;

    public BasePassage(FrameworkAware delegate) {
        this.delegate = delegate;
    }

    public boolean canUse(String feature) {
        return this.delegate.withFramework(framework -> new Access((Framework)framework).canUse(feature)).orElse(Boolean.FALSE);
    }

    public ServiceInvocationResult<ExaminationCertificate> assess() {
        return this.delegate.withFrameworkService(framework -> new Access((Framework)framework).assess());
    }

    public ServiceInvocationResult<GrantLockAttempt> acquireLicense(String feature) {
        return this.delegate.withFrameworkService(framework -> new Access((Framework)framework).acquire(feature));
    }

    public ServiceInvocationResult<Boolean> releaseLicense(GrantLockAttempt lock) {
        return this.delegate.withFrameworkService(framework -> new Access((Framework)framework).release(lock));
    }

    public ServiceInvocationResult<LicensedProduct> product() {
        return this.delegate.withFrameworkService(framework -> new BaseServiceInvocationResult<LicensedProduct>(framework.product()));
    }
}

