/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services.about;

import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.e4.core.services.about.ISystemInformation;

abstract class PrintedMap
implements ISystemInformation {
    PrintedMap() {
    }

    @Override
    public void append(PrintWriter writer) {
        this.source().entrySet().stream().flatMap(this::mapEntry).forEach(s -> writer.println((String)s));
    }

    protected abstract TreeMap<String, String> source();

    private Stream<String> mapEntry(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        String value = entry.getValue();
        if (this.needsSecurity(key)) {
            return Stream.of(this.pair(key, this.secure(value)));
        }
        return Stream.of(this.plain(this.pair(key, value)));
    }

    private boolean needsSecurity(String key) {
        return key.toUpperCase().contains("PASSWORD");
    }

    private String pair(String key, String value) {
        return String.format("%s=%s", key, value);
    }

    private String secure(String raw) {
        return IntStream.range(0, raw.length()).mapToObj(i -> "*").collect(Collectors.joining());
    }

    private String[] plain(String raw) {
        return raw.split("\n");
    }
}

