/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.component.ExtFactoryComponentInstance;
import org.apache.felix.scr.impl.inject.ComponentMethods;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContainer;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl<S>
extends AbstractComponentManager<S>
implements ComponentFactory<S>,
ComponentContainer<S> {
    private final Map<SingleComponentManager<S>, SingleComponentManager<S>> m_componentInstances = new IdentityHashMap<SingleComponentManager<S>, SingleComponentManager<S>>();
    private volatile Map<String, Object> m_configuration = new HashMap<String, Object>();
    private volatile boolean m_hasConfiguration;
    protected volatile long m_changeCount = -1L;
    protected TargetedPID m_targetedPID;

    public ComponentFactoryImpl(ComponentContainer<S> container, ComponentMethods componentMethods) {
        super(container, componentMethods);
    }

    @Override
    protected boolean verifyDependencyManagers() {
        if (!this.getComponentMetadata().isPersistentFactoryComponent()) {
            return super.verifyDependencyManagers();
        }
        return true;
    }

    @Override
    public boolean isFactory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstance<S> newInstance(Dictionary<String, ?> dictionary) {
        ComponentInstance<S> instance;
        SingleComponentManager<S> cm = this.createComponentManager();
        this.getLogger().log(InternalLogger.Level.DEBUG, "Creating new instance from component factory", null);
        cm.setFactoryProperties(dictionary);
        cm.reconfigure(this.m_configuration, false, null);
        cm.enableInternal();
        if (this.getComponentMetadata().isPersistentFactoryComponent()) {
            instance = new ModifyComponentInstance<S>(cm);
        } else {
            instance = cm.getComponentInstance();
            if (instance == null || instance.getInstance() == null) {
                cm.dispose(5);
                throw new ComponentException("Failed activating component");
            }
        }
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.put(cm, cm);
        }
        return instance;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentFactoryImpl)) {
            return false;
        }
        ComponentFactoryImpl other = (ComponentFactoryImpl)object;
        return this.getComponentMetadata().getName().equals(other.getComponentMetadata().getName());
    }

    public int hashCode() {
        return this.getComponentMetadata().getName().hashCode();
    }

    @Override
    protected void deleteComponent(int reason) {
    }

    @Override
    protected String[] getProvidedServices() {
        return new String[]{ComponentFactory.class.getName()};
    }

    public boolean hasConfiguration() {
        return this.m_hasConfiguration;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        List<ReferenceMetadata> depMetaData = this.getComponentMetadata().getDependencies();
        for (ReferenceMetadata rm : depMetaData) {
            if (rm.getTarget() == null) continue;
            props.put(rm.getTargetPropertyName(), rm.getTarget());
        }
        for (String key : this.m_configuration.keySet()) {
            if (!key.endsWith(".target")) continue;
            props.put(key, this.m_configuration.get(key));
        }
        return props;
    }

    @Override
    public void setServiceProperties(Dictionary<String, ?> serviceProperties) {
        throw new IllegalStateException("ComponentFactory service properties are immutable");
    }

    @Override
    void postRegister() {
    }

    @Override
    void preDeregister() {
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>(this.getComponentMetadata().getFactoryProperties());
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        return props;
    }

    @Override
    protected boolean collectDependencies(ComponentContextImpl<S> componentContext) {
        return true;
    }

    @Override
    <T> boolean invokeUpdatedMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> ref, int trackingCount) {
        return false;
    }

    @Override
    <T> void invokeBindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> reference, int trackingCount) {
    }

    @Override
    <T> void invokeUnbindMethod(DependencyManager<S, T> dependencyManager, RefPair<S, T> oldRef, int trackingCount) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(int reason) {
        ArrayList<AbstractComponentManager<S>> cms = new ArrayList<AbstractComponentManager<S>>();
        this.getComponentManagers(this.m_componentInstances, cms);
        for (AbstractComponentManager abstractComponentManager : cms) {
            abstractComponentManager.dispose(reason);
        }
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.clear();
        }
        super.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposed(SingleComponentManager<S> component) {
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.remove(component);
        }
    }

    private SingleComponentManager<S> createComponentManager() {
        return new SingleComponentManager(this, this.getComponentMethods(), !this.getComponentMetadata().isPersistentFactoryComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getComponentManagers(Map<?, SingleComponentManager<S>> componentMap, List<AbstractComponentManager<S>> componentManagers) {
        if (componentMap != null) {
            Map<?, SingleComponentManager<S>> map = componentMap;
            synchronized (map) {
                componentManagers.addAll(componentMap.values());
            }
        }
    }

    public TargetedPID getConfigurationTargetedPID(TargetedPID pid, TargetedPID factoryPid) {
        return this.m_targetedPID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Map<String, Object> configuration, boolean configurationDeleted, TargetedPID factoryPid) {
        ArrayList<SingleComponentManager<S>> cms;
        if (factoryPid != null) {
            return;
        }
        this.m_configuration = configuration;
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            cms = new ArrayList<SingleComponentManager<S>>(this.m_componentInstances.keySet());
        }
        for (SingleComponentManager singleComponentManager : cms) {
            singleComponentManager.reconfigure(configuration, configurationDeleted, factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getComponentManagers(List<AbstractComponentManager<S>> cms) {
        Map<SingleComponentManager<S>, SingleComponentManager<S>> map = this.m_componentInstances;
        synchronized (map) {
            cms.addAll(this.m_componentInstances.keySet());
        }
    }

    private static class ModifyComponentInstance<S>
    implements ExtFactoryComponentInstance<S> {
        private final SingleComponentManager<S> cm;

        public ModifyComponentInstance(SingleComponentManager<S> cm) {
            this.cm = cm;
        }

        public void dispose() {
            this.cm.dispose();
        }

        public S getInstance() {
            ComponentInstance<S> componentInstance = this.cm.getComponentInstance();
            return (S)(componentInstance == null ? null : componentInstance.getInstance());
        }

        @Override
        public void modify(Dictionary<String, ?> properties) {
            this.cm.setFactoryProperties(properties);
            this.cm.reconfigure(false);
        }
    }
}

