/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.equinox.requirements.BundleManifest;
import org.eclipse.passage.lic.equinox.requirements.LicCapabilityAttributesFromDeclaration;
import org.eclipse.passage.lic.equinox.requirements.ProvidedCapabilitiesFromManifest;
import org.eclipse.passage.lic.equinox.requirements.RequirementFromAttributes;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.Bundle;

final class RequirementsFromManifest
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Bundle bundle;

    public RequirementsFromManifest(Bundle bundle) {
        Objects.requireNonNull(bundle, "RequirementsFromManifest::bundle");
        this.bundle = bundle;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        try {
            return this.scan();
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), AccessMessages.RequirementsFromManifest_failure));
        }
    }

    private ServiceInvocationResult<Collection<Requirement>> scan() throws LicensingException {
        String manifest = new BundleManifest(this.bundle).get();
        Optional<String> declaration = new ProvidedCapabilitiesFromManifest(manifest).get();
        if (!declaration.isPresent()) {
            return this.none();
        }
        return new LicCapabilityAttributesFromDeclaration(declaration.get()).get().stream().map(pack -> new RequirementFromAttributes(this.bundle, (Map<String, Object>)pack)).map(RequirementFromAttributes::get).reduce((BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections())).orElseGet(() -> new BaseServiceInvocationResult(new ArrayList()));
    }

    private ServiceInvocationResult<Collection<Requirement>> none() {
        return new BaseServiceInvocationResult(new ArrayList());
    }
}

