/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassageLicenseCoverage;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.RequirementsLicensingStatusExplained;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;

final class LicenseStatus
extends Command {
    public LicenseStatus() {
        super(new Scope.Self(), new String[]{"licstatus"});
    }

    public void licstatus() {
        ServiceInvocationResult response = new EquinoxPassageLicenseCoverage().assess();
        if (response.data().isPresent()) {
            this.reportCertificate((ExaminationCertificate)response.data().get());
        }
        this.reportDiagnostic(response.diagnostic());
    }

    private void reportCertificate(ExaminationCertificate certificate) {
        System.out.printf("\n%s\n", new RequirementsLicensingStatusExplained(certificate).get());
    }
}

