/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.PassageUI;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassageLicenseCoverage;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.LicenseStatusDialog;
import org.eclipse.swt.widgets.Shell;

public final class EquinoxPassageUI
implements PassageUI {
    private final Supplier<Shell> shell;

    public EquinoxPassageUI(Supplier<Shell> shell) {
        this.shell = shell;
    }

    public ServiceInvocationResult<GrantLockAttempt> acquireLicense(String feature) {
        ServiceInvocationResult<GrantLockAttempt> lock = this.investigate(() -> this.acquire(feature), GrantLockAttempt::certificate, cert -> !new CertificateWorthAttention().test(cert));
        return lock;
    }

    public ServiceInvocationResult<ExaminationCertificate> assessLicensingStatus() {
        return this.investigate(this::assess, Function.identity(), c -> false);
    }

    private <T> ServiceInvocationResult<T> investigate(Supplier<ServiceInvocationResult<T>> service, Function<T, ExaminationCertificate> certificate, Predicate<Optional<ExaminationCertificate>> ok) {
        ServiceInvocationResult<T> result = service.get();
        while (this.exposeAndMayBeEvenFix(result, certificate, ok)) {
            result = service.get();
        }
        return result;
    }

    private ServiceInvocationResult<GrantLockAttempt> acquire(String feature) {
        return new EquinoxPassage().acquireLicense(feature);
    }

    private ServiceInvocationResult<ExaminationCertificate> assess() {
        return new EquinoxPassageLicenseCoverage().assess();
    }

    private <T> boolean exposeAndMayBeEvenFix(ServiceInvocationResult<T> result, Function<T, ExaminationCertificate> get, Predicate<Optional<ExaminationCertificate>> ok) {
        if (!result.data().isPresent()) {
            new DiagnosticDialog(this.shell.get(), result.diagnostic()).open();
            return false;
        }
        Optional<ExaminationCertificate> certificate = Optional.of(get.apply(result.data().get()));
        if (ok.test(certificate)) {
            return false;
        }
        LicenseStatusDialog dialog = new LicenseStatusDialog(this.shell.get(), certificate.get(), result.diagnostic());
        if (dialog.open() != 0) {
            return false;
        }
        return dialog.goodIntention().paveTheWay();
    }
}

