/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Hashtable;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.internal.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;
import org.osgi.framework.BundleContext;

public abstract class Command {
    protected final Scope scope;
    private final String[] names;

    public Command(Scope scope, String[] names) {
        this.scope = scope;
        this.names = names;
    }

    public final void register(BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("osgi.command.scope", this.scope.id());
        properties.put("osgi.command.function", this.names);
        context.registerService(this.getClass().getName(), (Object)this, properties);
    }

    protected final void reportDiagnostic(Diagnostic diagnostic) {
        if (new NoErrors().test(diagnostic)) {
            return;
        }
        System.out.printf("\n%s\n", new DiagnosticExplained(diagnostic).get());
    }
}

