/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.actions;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.jface.EquinoxPassageUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class LicensedAction
extends Action {
    protected abstract void doAction();

    public final void runWithEvent(Event event) {
        this.runEverywhere(event.display);
    }

    public final void run() {
        this.runEverywhere(Display.getDefault());
    }

    private void runEverywhere(Display display) {
        Optional<ServiceInvocationResult<GrantLockAttempt>> response = Optional.empty();
        try {
            response = Optional.of(new EquinoxPassageUI(() -> ((Display)display).getActiveShell()).acquireLicense(this.getId()));
            if (this.grantAcquired(response)) {
                this.doAction();
            }
        }
        catch (Throwable throwable) {
            response.flatMap(ServiceInvocationResult::data).ifPresent(lock -> {
                ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(lock);
            });
            throw throwable;
        }
        response.flatMap(ServiceInvocationResult::data).ifPresent(lock -> {
            ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(lock);
        });
    }

    private boolean grantAcquired(Optional<ServiceInvocationResult<GrantLockAttempt>> response) {
        return response.flatMap(ServiceInvocationResult::data).map(GrantLockAttempt::successful).orElse(false);
    }
}

