/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.hardware.platform.windows.WindowsComputerSystem;
import oshi.jna.platform.windows.PdhUtil;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsCentralProcessor.class);
    private static final byte MAJOR_VERSION = Kernel32.INSTANCE.GetVersion().getLow().byteValue();
    private static final String PROCESSOR = "Processor";
    private static final String PROCESSOR_LOCALIZED = PdhUtil.PdhLookupPerfNameByIndex(null, PdhUtil.PdhLookupPerfIndexByEnglishName("Processor"));
    private static final String TOTAL_INSTANCE = "_Total";
    private transient PerfDataUtil.PerfCounter[] dpcTickCounter = null;
    private transient PerfDataUtil.PerfCounter[] interruptTickCounter = null;
    private transient PerfDataUtil.PerfCounter[] privilegedTickCounter = null;
    private transient PerfDataUtil.PerfCounter[] processorTickCounter = null;
    private transient PerfDataUtil.PerfCounter[] userTickCounter = null;
    private transient WbemcliUtil.WmiQuery<ProcessorTickCountProperty> processorTickCountQuery = null;
    private transient PerfDataUtil.PerfCounter irqTickCounter = null;
    private transient PerfDataUtil.PerfCounter softIrqTickCounter = null;
    private transient WbemcliUtil.WmiQuery<SystemTickCountProperty> systemTickCountQuery = null;
    private transient PerfDataUtil.PerfCounter interruptsPerSecCounter = null;
    private transient WbemcliUtil.WmiQuery<InterruptsProperty> interruptsQuery = null;
    private transient PerfDataUtil.PerfCounter contextSwitchesPerSecCounter = null;
    private transient WbemcliUtil.WmiQuery<ContextSwitchProperty> contextSwitchQuery = null;
    private static long lastRefresh = 0L;

    public WindowsCentralProcessor() {
        this.initVars();
        this.initPdhCounters();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\";
        String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\");
        if (processorIds.length > 0) {
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorIds[0];
            this.setVendor(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"VendorIdentifier"));
            this.setName(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString"));
            this.setIdentifier(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"Identifier"));
        }
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 9 || sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 6) {
            this.setCpu64(true);
        } else if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 0) {
            this.setCpu64(false);
        }
        WbemcliUtil.WmiQuery<ProcessorProperty> processorIdQuery = WbemcliUtil.createQuery("Win32_Processor", ProcessorProperty.class);
        WbemcliUtil.WmiResult<ProcessorProperty> processorId = WmiUtil.queryWMI(processorIdQuery);
        if (processorId.getResultCount() > 0) {
            this.setProcessorID(processorId.getString(ProcessorProperty.PROCESSORID, 0));
        }
    }

    private void initPdhCounters() {
        this.contextSwitchesPerSecCounter = PerfDataUtil.createCounter("System", null, "Context Switches/sec");
        if (!PerfDataUtil.addCounterToQuery(this.contextSwitchesPerSecCounter)) {
            this.contextSwitchesPerSecCounter = null;
            this.contextSwitchQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfOS_System", ContextSwitchProperty.class);
        }
        boolean enumeration = true;
        try {
            PdhUtil.PdhEnumObjectItems objectItems = PdhUtil.PdhEnumObjectItems(null, null, PROCESSOR_LOCALIZED, 100);
            if (!objectItems.getInstances().isEmpty()) {
                PerfDataUtil.PerfCounter counter;
                this.dpcTickCounter = new PerfDataUtil.PerfCounter[this.logicalProcessorCount];
                this.interruptTickCounter = new PerfDataUtil.PerfCounter[this.logicalProcessorCount];
                this.privilegedTickCounter = new PerfDataUtil.PerfCounter[this.logicalProcessorCount];
                this.processorTickCounter = new PerfDataUtil.PerfCounter[this.logicalProcessorCount];
                this.userTickCounter = new PerfDataUtil.PerfCounter[this.logicalProcessorCount];
                List<String> instances = objectItems.getInstances();
                for (int i = 0; i < instances.size() && i < this.logicalProcessorCount; ++i) {
                    String instance = instances.get(i);
                    this.dpcTickCounter[i] = counter = PerfDataUtil.createCounter(PROCESSOR, instance, "% DPC Time");
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    this.interruptTickCounter[i] = counter = PerfDataUtil.createCounter(PROCESSOR, instance, "% Interrupt Time");
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    this.privilegedTickCounter[i] = counter = PerfDataUtil.createCounter(PROCESSOR, instance, "% Privileged Time");
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    this.processorTickCounter[i] = counter = PerfDataUtil.createCounter(PROCESSOR, instance, "% Processor Time");
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    this.userTickCounter[i] = counter = PerfDataUtil.createCounter(PROCESSOR, instance, "% User Time");
                    if (PerfDataUtil.addCounterToQuery(counter)) continue;
                    throw new PdhUtil.PdhException(0);
                }
                this.irqTickCounter = counter = PerfDataUtil.createCounter(PROCESSOR, TOTAL_INSTANCE, "% Interrupt Time");
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    throw new PdhUtil.PdhException(0);
                }
                this.softIrqTickCounter = counter = PerfDataUtil.createCounter(PROCESSOR, TOTAL_INSTANCE, "% DPC Time");
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    throw new PdhUtil.PdhException(0);
                }
                this.interruptsPerSecCounter = counter = PerfDataUtil.createCounter(PROCESSOR, TOTAL_INSTANCE, "Interrupts/sec");
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    throw new PdhUtil.PdhException(0);
                }
            }
        }
        catch (PdhUtil.PdhException e) {
            LOG.warn("Unable to enumerate performance counter instances for {}.", (Object)PROCESSOR_LOCALIZED);
            enumeration = false;
        }
        if (!enumeration) {
            PerfDataUtil.removeAllCounters(PROCESSOR);
            this.dpcTickCounter = null;
            this.interruptTickCounter = null;
            this.privilegedTickCounter = null;
            this.processorTickCounter = null;
            this.userTickCounter = null;
            this.irqTickCounter = null;
            this.softIrqTickCounter = null;
            this.interruptsPerSecCounter = null;
            this.processorTickCountQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfOS_Processor WHERE NOT Name=\"_Total\"", ProcessorTickCountProperty.class);
            this.systemTickCountQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfOS_Processor WHERE Name=\"_Total\"", SystemTickCountProperty.class);
            this.interruptsQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfOS_Processor WHERE Name=\"_Total\"", InterruptsProperty.class);
        }
        this.processorTickCountQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfOS_Processor WHERE NOT Name=\"_Total\"", ProcessorTickCountProperty.class);
    }

    @Override
    protected void calculateProcessorCounts() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] processors;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        this.logicalProcessorCount = sysinfo.dwNumberOfProcessors.intValue();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION proc : processors = Kernel32Util.getLogicalProcessorInformation()) {
            if (proc.relationship == 3) {
                ++this.physicalPackageCount;
            }
            if (proc.relationship != 0) continue;
            ++this.physicalProcessorCount;
        }
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (!Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to update system idle/kernel/user times. Error code: {}", (Object)Native.getLastError());
            return ticks;
        }
        if (this.systemTickCountQuery == null) {
            WindowsCentralProcessor.refreshTickCounters();
            ticks[CentralProcessor.TickType.IRQ.getIndex()] = PerfDataUtil.queryCounter(this.irqTickCounter) / 10000L;
            ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] = PerfDataUtil.queryCounter(this.softIrqTickCounter) / 10000L;
        } else {
            WbemcliUtil.WmiResult<SystemTickCountProperty> result = WmiUtil.queryWMI(this.systemTickCountQuery);
            if (result.getResultCount() > 0) {
                ticks[CentralProcessor.TickType.IRQ.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(SystemTickCountProperty.PERCENTINTERRUPTTIME, 0), 0L) / 10000L;
                ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(SystemTickCountProperty.PERCENTDPCTIME, 0), 0L) / 10000L;
            }
        }
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = lpIdleTime.toDWordLong().longValue() / 10000L;
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = lpKernelTime.toDWordLong().longValue() / 10000L - ticks[CentralProcessor.TickType.IDLE.getIndex()];
        ticks[CentralProcessor.TickType.USER.getIndex()] = lpUserTime.toDWordLong().longValue() / 10000L;
        int n = CentralProcessor.TickType.SYSTEM.getIndex();
        ticks[n] = ticks[n] - (ticks[CentralProcessor.TickType.IRQ.getIndex()] + ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()]);
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        for (int i = 0; i < average.length; ++i) {
            average[i] = -1.0;
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        int cpu;
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        if (this.processorTickCountQuery == null) {
            WindowsCentralProcessor.refreshTickCounters();
            for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = PerfDataUtil.queryCounter(this.privilegedTickCounter[cpu]);
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = PerfDataUtil.queryCounter(this.userTickCounter[cpu]);
                ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = PerfDataUtil.queryCounter(this.interruptTickCounter[cpu]);
                ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()] = PerfDataUtil.queryCounter(this.dpcTickCounter[cpu]);
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = PerfDataUtil.queryCounter(this.processorTickCounter[cpu]);
            }
        } else {
            ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
            WbemcliUtil.WmiResult<ProcessorTickCountProperty> result = WmiUtil.queryWMI(this.processorTickCountQuery);
            for (int cpu2 = 0; cpu2 < result.getResultCount() && cpu2 < this.logicalProcessorCount; ++cpu2) {
                ticks[cpu2][CentralProcessor.TickType.SYSTEM.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(ProcessorTickCountProperty.PERCENTPRIVILEGEDTIME, cpu2), 0L);
                ticks[cpu2][CentralProcessor.TickType.USER.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(ProcessorTickCountProperty.PERCENTUSERTIME, cpu2), 0L);
                ticks[cpu2][CentralProcessor.TickType.IRQ.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(ProcessorTickCountProperty.PERCENTINTERRUPTTIME, cpu2), 0L);
                ticks[cpu2][CentralProcessor.TickType.SOFTIRQ.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(ProcessorTickCountProperty.PERCENTDPCTIME, cpu2), 0L);
                ticks[cpu2][CentralProcessor.TickType.IDLE.getIndex()] = ParseUtil.parseLongOrDefault(result.getString(ProcessorTickCountProperty.PERCENTPROCESSORTIME, cpu2), 0L);
            }
        }
        for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long[] lArray = ticks[cpu];
            int n = CentralProcessor.TickType.IDLE.getIndex();
            lArray[n] = lArray[n] - (ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] + ticks[cpu][CentralProcessor.TickType.USER.getIndex()]);
            long[] lArray2 = ticks[cpu];
            int n2 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray2[n2] = lArray2[n2] - (ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] + ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()]);
            long[] lArray3 = ticks[cpu];
            int n3 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray3[n3] = lArray3[n3] / 10000L;
            long[] lArray4 = ticks[cpu];
            int n4 = CentralProcessor.TickType.USER.getIndex();
            lArray4[n4] = lArray4[n4] / 10000L;
            long[] lArray5 = ticks[cpu];
            int n5 = CentralProcessor.TickType.IRQ.getIndex();
            lArray5[n5] = lArray5[n5] / 10000L;
            long[] lArray6 = ticks[cpu];
            int n6 = CentralProcessor.TickType.SOFTIRQ.getIndex();
            lArray6[n6] = lArray6[n6] / 10000L;
            long[] lArray7 = ticks[cpu];
            int n7 = CentralProcessor.TickType.IDLE.getIndex();
            lArray7[n7] = lArray7[n7] / 10000L;
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        if (MAJOR_VERSION >= 6) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    @Override
    @Deprecated
    public String getSystemSerialNumber() {
        return new WindowsComputerSystem().getSerialNumber();
    }

    @Override
    public long getContextSwitches() {
        if (this.contextSwitchQuery == null) {
            PerfDataUtil.updateQuery(this.contextSwitchesPerSecCounter);
            return PerfDataUtil.queryCounter(this.contextSwitchesPerSecCounter) / 10000L;
        }
        WbemcliUtil.WmiResult<ContextSwitchProperty> result = WmiUtil.queryWMI(this.contextSwitchQuery);
        if (result.getResultCount() > 0) {
            return (long)result.getInteger(ContextSwitchProperty.CONTEXTSWITCHESPERSEC, 0).intValue() / 10000L;
        }
        return 0L;
    }

    @Override
    public long getInterrupts() {
        if (this.interruptsQuery == null) {
            WindowsCentralProcessor.refreshTickCounters();
            return PerfDataUtil.queryCounter(this.interruptsPerSecCounter) / 10000L;
        }
        WbemcliUtil.WmiResult<InterruptsProperty> result = WmiUtil.queryWMI(this.interruptsQuery);
        if (result.getResultCount() > 0) {
            return result.getInteger(InterruptsProperty.INTERRUPTSPERSEC, 0).intValue();
        }
        return 0L;
    }

    private static void refreshTickCounters() {
        if (System.currentTimeMillis() - lastRefresh > 100L) {
            lastRefresh = PerfDataUtil.updateQuery(PROCESSOR);
        }
    }

    static enum ContextSwitchProperty {
        CONTEXTSWITCHESPERSEC;

    }

    static enum InterruptsProperty {
        INTERRUPTSPERSEC;

    }

    static enum ProcessorProperty {
        PROCESSORID;

    }

    static enum ProcessorTickCountProperty {
        PERCENTDPCTIME,
        PERCENTINTERRUPTTIME,
        PERCENTPRIVILEGEDTIME,
        PERCENTPROCESSORTIME,
        PERCENTUSERTIME;

    }

    static enum SystemTickCountProperty {
        PERCENTDPCTIME,
        PERCENTINTERRUPTTIME;

    }
}

