/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.jetty;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.passage.lbc.runtime.ServerHandler;
import org.eclipse.passage.lbc.runtime.ServerRequestHandler;

public class JettyServerHandler
implements ServerHandler {
    private static Logger LOG = Logger.getLogger(JettyServerHandler.class.getName());
    private List<ServerRequestHandler> serverHandlers = new ArrayList<ServerRequestHandler>();
    private Server server;

    public void launch() {
        this.server = new Server(8080);
        try {
            HandlerList handlers = new HandlerList();
            for (ServerRequestHandler handler : this.serverHandlers) {
                if (!(handler instanceof Handler)) continue;
                handlers.addHandler((Handler)handler);
            }
            this.server.setHandler((Handler)handlers);
            this.server.start();
            LOG.info(this.server.getState());
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public void terminate() {
        if (this.server != null) {
            try {
                this.server.stop();
                LOG.info(this.server.getState());
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
    }

    public void addServerRequestHandler(ServerRequestHandler handler) {
        this.serverHandlers.add(handler);
    }

    public void remServerRequestHandler(ServerRequestHandler handler) {
        this.serverHandlers.remove(handler);
    }
}

