/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.users.model.migration;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.passage.lic.emf.migration.DelegateClassifiers;
import org.eclipse.passage.lic.emf.migration.EAttributeRoute;
import org.eclipse.passage.lic.emf.migration.EClassRoutes;
import org.eclipse.passage.lic.emf.migration.MigrationRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleAttributeRoute;
import org.eclipse.passage.lic.emf.migration.SimpleClassRoutes;
import org.eclipse.passage.lic.emf.migration.SimpleMigrationRoutes;
import org.eclipse.passage.lic.emf.xmi.MigratingResourceHandler;
import org.eclipse.passage.lic.internal.users.model.migration.EnsureLicenseOwnerContact;
import org.eclipse.passage.lic.users.model.api.Contact;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;

public final class UsersResourceHandler
extends MigratingResourceHandler {
    protected void register() {
        this.migrate033();
        this.migrate040();
        this.migrate050();
        this.migrate100();
        this.migrate110();
    }

    protected void complete(XMLResource resource) {
        resource.getContents().stream().filter(UserOrigin.class::isInstance).map(UserOrigin.class::cast).forEach(this::complete);
    }

    protected MigrationRoutes attributes() {
        SimpleMigrationRoutes routes = new SimpleMigrationRoutes();
        UsersPackage users = UsersPackage.eINSTANCE;
        routes.define("preferredConditionType", (EAttributeRoute)new SimpleAttributeRoute(users.getUser_PreferredEvaluationType()));
        routes.define("preferredConditionExpression", (EAttributeRoute)new SimpleAttributeRoute(users.getUser_PreferredEvaluationExpression()));
        routes.define("email", (EAttributeRoute)new SimpleAttributeRoute(users.getContact_Email(), new EReference[]{users.getLicenseOwner_Contact()}));
        routes.define("fullName", (EAttributeRoute)new SimpleAttributeRoute(users.getContact_Name(), new EReference[]{users.getLicenseOwner_Contact()}));
        routes.ignore("userLicenses", users.getUser());
        return routes;
    }

    private void migrate033() {
        String uri = "http://www.eclipse.org/passage/lic/0.3.3";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate040() {
        String uri = "http://www.eclipse.org/passage/lic/users/0.4.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate050() {
        String uri = "http://www.eclipse.org/passage/lic/users/0.5.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate100() {
        String uri = "http://www.eclipse.org/passage/lic/users/1.0.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private void migrate110() {
        String uri = "http://www.eclipse.org/passage/lic/users/1.1.0";
        new DelegateClassifiers(uri).delegate(this.classRoutes200());
    }

    private EClassRoutes classRoutes200() {
        UsersPackage delegate = UsersPackage.eINSTANCE;
        EClassRoutes.Smart routes = new EClassRoutes.Smart((EClassRoutes)new SimpleClassRoutes());
        routes.define(delegate.getUserOrigin());
        routes.define(delegate.getUser());
        return routes;
    }

    private void complete(UserOrigin origin) {
        origin.getUsers().forEach(this::complete);
    }

    private void complete(User user) {
        Contact contact = new EnsureLicenseOwnerContact().apply(user);
        if (user.getIdentifier() == null) {
            user.setIdentifier(contact.getEmail());
        }
        if (user.getName() == null) {
            user.setName(contact.getName());
        }
    }
}

