/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;

final class CalmedDown
implements Supplier<ServiceInvocationResult<Collection<ConditionPack>>> {
    private final ServiceInvocationResult<Collection<ConditionPack>> original;

    CalmedDown(ServiceInvocationResult<Collection<ConditionPack>> original) {
        this.original = original;
    }

    @Override
    public ServiceInvocationResult<Collection<ConditionPack>> get() {
        ServiceFailedOnMorsel morsel = new ServiceFailedOnMorsel();
        List<Trouble> calmed = this.original.diagnostic().severe().stream().filter(trouble -> trouble.code().equals((Object)morsel)).collect(Collectors.toList());
        return new BaseServiceInvocationResult<Collection<ConditionPack>>((Diagnostic)new BaseDiagnostic(this.severe(calmed), this.bearable(calmed)), this.original.data());
    }

    private List<Trouble> severe(List<Trouble> calmed) {
        ArrayList<Trouble> severe = new ArrayList<Trouble>(this.original.diagnostic().severe());
        severe.removeAll(calmed);
        return severe;
    }

    private List<Trouble> bearable(List<Trouble> calmed) {
        ArrayList<Trouble> bearable = new ArrayList<Trouble>(this.original.diagnostic().bearable());
        bearable.addAll(calmed);
        return bearable;
    }
}

