/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.interaction;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.eclipse.passage.lbc.internal.base.interaction.Pack;
import org.eclipse.passage.lbc.internal.base.interaction.PacksFound;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.base.io.ExternalLicense;

public final class IncomingLicense {
    private final Path origin;
    private final Path storage;

    public IncomingLicense(String origin, Path storage) {
        Objects.requireNonNull(origin, "IncomingLicense:origin");
        Objects.requireNonNull(storage, "IncomingLicense:storage");
        this.origin = Paths.get(origin, new String[0]);
        this.storage = storage;
        this.validateOrigin();
    }

    public ServiceInvocationResult<List<Path>> upload() {
        ServiceInvocationResult<Collection<Pack>> packs = new PacksFound(this.origin).get();
        if (!packs.data().isPresent() || ((Collection)packs.data().get()).isEmpty()) {
            return new BaseServiceInvocationResult(packs.diagnostic());
        }
        return ((Collection)packs.data().get()).stream().map(this::uploadPack).reduce((ServiceInvocationResult)new BaseServiceInvocationResult(Collections.emptyList()), (BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfLists()));
    }

    private ServiceInvocationResult<List<Path>> uploadPack(Pack pack) {
        try {
            Pack.Resolved resolved = pack.resolve();
            Path destination = new ExternalLicense(this.storage, resolved.product()).install(pack.content());
            return new BaseServiceInvocationResult(Collections.singletonList(destination));
        }
        catch (Exception e) {
            return this.failedToUploadPack(pack, e);
        }
    }

    private BaseServiceInvocationResult<List<Path>> failedToUploadPack(Pack pack, Exception e) {
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("Failed to upload %s", pack), e))));
    }

    private final void validateOrigin() {
        String info = this.origin.toAbsolutePath().toString();
        if (!Files.exists(this.origin, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s does not exist", info));
        }
        if (!Files.isDirectory(this.origin, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s is not a directory", info));
        }
        if (!Files.isExecutable(this.origin)) {
            throw new IllegalArgumentException(String.format("%s cannot be read", info));
        }
    }
}

