/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.interaction;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.LicensingException;

final class OnlyFileOfType {
    private final Path folder;
    private final String extension;

    public OnlyFileOfType(Path folder, String extension) {
        this.folder = folder;
        this.extension = extension;
    }

    Path get() throws Exception {
        List keys = Files.find(this.folder, 1, this::ofType, new FileVisitOption[0]).collect(Collectors.toList());
        if (keys.size() != 1) {
            throw new LicensingException(String.format("%s is expected to contain exactly one file of type %s", this.folder.toString(), this.extension));
        }
        return (Path)keys.get(0);
    }

    private boolean ofType(Path file, BasicFileAttributes any) {
        return file.getFileName().toString().endsWith(this.extension);
    }
}

