/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.Request;
import org.eclipse.passage.lic.internal.hc.remote.impl.FloatingServerCoordinates;
import org.eclipse.passage.lic.internal.net.HostPort;

public abstract class RemoteRequest<C extends Connection>
implements Request<C> {
    protected final LicensedProduct product;
    protected final FloatingLicenseAccess access;

    public RemoteRequest(LicensedProduct product, FloatingLicenseAccess access) {
        this.product = product;
        this.access = access;
    }

    @Override
    public final URL url() throws LicensingException {
        try {
            HostPort corrdinates = new FloatingServerCoordinates(this.access).get();
            return new URL("http", corrdinates.host(), Integer.parseInt(corrdinates.port()), this.parameters().query());
        }
        catch (NumberFormatException | MalformedURLException | LicensingException e) {
            throw new LicensingException(AccessMessages.Request_failed_to_compose_url, e);
        }
    }
}

