/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.Framework;
import org.eclipse.passage.lic.internal.api.FrameworkSupplier;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoFramework;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class FrameworkAware {
    private final BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();

    protected FrameworkAware() {
    }

    private Optional<ServiceReference<FrameworkSupplier>> frameworkIfAny() {
        try {
            Collection refs = this.context.getServiceReferences(FrameworkSupplier.class, null);
            if (refs.size() != 1) {
                return Optional.empty();
            }
            ServiceReference ref = (ServiceReference)new ArrayList(refs).get(0);
            return Optional.of(ref);
        }
        catch (InvalidSyntaxException e) {
            return Optional.empty();
        }
    }

    private <T> ServiceInvocationResult<T> noFramework() {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new NoFramework(), String.format(AccessMessages.EquinoxPassage_no_framewrok, new Object[0])));
    }

    protected <T> ServiceInvocationResult<T> withFrameworkService(Function<Framework, ServiceInvocationResult<T>> invoke) {
        return this.withReference(reference -> Optional.ofNullable((FrameworkSupplier)this.context.getService(reference)).flatMap(Supplier::get).map(invoke::apply).orElseGet(this::noFramework), this::noFramework);
    }

    protected <T> Optional<T> withFramework(Function<Framework, T> invoke) {
        return this.withReference(reference -> Optional.ofNullable((FrameworkSupplier)this.context.getService(reference)).flatMap(Supplier::get).map(invoke::apply), Optional::empty);
    }

    protected <K> K withReference(Function<ServiceReference<FrameworkSupplier>, K> action, Supplier<K> noAction) {
        Optional<ServiceReference<FrameworkSupplier>> candidate = this.frameworkIfAny();
        if (!candidate.isPresent()) {
            return noAction.get();
        }
        ServiceReference<FrameworkSupplier> reference = candidate.get();
        try {
            K k = action.apply(reference);
            return k;
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

