/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.RemedyElementCategory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.Remedy;
import org.eclipse.equinox.p2.operations.RemedyIUDetail;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class RemediationGroup {
    static final int ALLOWPARTIALINSTALL_INDEX = 0;
    static final int ALLOWDIFFERENTVERSION_INDEX = 1;
    static final int ALLOWINSTALLEDUPDATE_INDEX = 2;
    static final int ALLOWINSTALLEDREMOVAL_INDEX = 3;
    private RemediationOperation remediationOperation;
    Composite remediationComposite;
    private Button bestBeingInstalledRelaxedButton;
    private Button bestInstalledRelaxedButton;
    Button buildMyOwnSolution;
    final ArrayList<Button> checkboxes = new ArrayList();
    private Composite resultFoundComposite;
    private Composite resultComposite;
    private Composite resultNotFoundComposite;
    private Composite resultErrorComposite;
    private Remedy currentRemedy;
    private TreeViewer treeViewer;
    private TreeViewerComparator treeComparator;
    protected IUElementListRoot input;
    private StackLayout switchRemediationLayout;
    Group detailsControl;
    Text detailStatusText;
    Composite checkBoxesComposite;
    private IUDetailsGroup iuDetailsGroup;
    HashMap<String, String[]> CONSTRAINTS = new HashMap();
    private final WizardPage containerPage;

    public RemediationGroup(WizardPage page) {
        this.CONSTRAINTS.put(ProvUIMessages.RemediationPage_BeingInstalledSection, new String[]{ProvUIMessages.RemediationPage_BeingInstalledSection_AllowPartialInstall, ProvUIMessages.RemediationPage_BeingInstalledSection_AllowDifferentVersion});
        this.CONSTRAINTS.put(ProvUIMessages.RemediationPage_InstalledSection, new String[]{ProvUIMessages.RemediationPage_InstalledSection_AllowInstalledUpdate, ProvUIMessages.RemediationPage_InstalledSection_AllowInstalledRemoval});
        this.containerPage = page;
    }

    public Composite getComposite() {
        return this.remediationComposite;
    }

    public void createRemediationControl(Composite container) {
        this.remediationComposite = new Composite(container, 0);
        this.remediationComposite.setLayout((Layout)new GridLayout());
        Label descriptionLabel = new Label(this.remediationComposite, 0);
        descriptionLabel.setText(ProvUIMessages.RemediationPage_SubDescription);
        Listener solutionslistener = e -> {
            Button btn = (Button)e.widget;
            Remedy remedy = btn.getData() == null ? null : (Remedy)btn.getData();
            this.checkboxes.get(0).setSelection(remedy != null && remedy.getConfig().allowPartialInstall);
            this.checkboxes.get(1).setSelection(remedy != null && remedy.getConfig().allowDifferentVersion);
            this.checkboxes.get(2).setSelection(remedy != null && remedy.getConfig().allowInstalledUpdate);
            this.checkboxes.get(3).setSelection(remedy != null && remedy.getConfig().allowInstalledRemoval);
            for (Button btn1 : this.checkboxes) {
                btn1.setVisible(true);
            }
            if (btn == this.buildMyOwnSolution && btn.getSelection()) {
                this.checkBoxesComposite.setVisible(true);
                ((GridData)this.checkBoxesComposite.getLayoutData()).exclude = false;
            } else {
                this.checkBoxesComposite.setVisible(false);
                ((GridData)this.checkBoxesComposite.getLayoutData()).exclude = true;
            }
            this.currentRemedy = this.searchRemedyMatchingUserChoices();
            this.refreshResultComposite();
            this.remediationComposite.layout(false);
        };
        this.bestBeingInstalledRelaxedButton = new Button(this.remediationComposite, 16);
        this.bestBeingInstalledRelaxedButton.setText(ProvUIMessages.RemediationPage_BestSolutionBeingInstalledRelaxed);
        this.bestBeingInstalledRelaxedButton.addListener(13, solutionslistener);
        this.bestInstalledRelaxedButton = new Button(this.remediationComposite, 16);
        this.bestInstalledRelaxedButton.setText(ProvUIMessages.RemediationPage_BestSolutionInstallationRelaxed);
        this.bestInstalledRelaxedButton.addListener(13, solutionslistener);
        this.buildMyOwnSolution = new Button(this.remediationComposite, 16);
        this.buildMyOwnSolution.setText(ProvUIMessages.RemediationPage_BestSolutionBuilt);
        this.buildMyOwnSolution.addListener(13, solutionslistener);
        Listener checkboxListener = e -> {
            this.currentRemedy = this.searchRemedyMatchingUserChoices();
            this.refreshResultComposite();
        };
        this.checkBoxesComposite = new Composite(this.remediationComposite, 0);
        this.checkBoxesComposite.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData();
        data.exclude = false;
        data.horizontalAlignment = 4;
        this.checkBoxesComposite.setLayoutData((Object)data);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 30;
        for (String key : this.CONSTRAINTS.keySet()) {
            String[] values;
            String[] stringArray = values = this.CONSTRAINTS.get(key);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                Button checkBtn = new Button(this.checkBoxesComposite, 32);
                checkBtn.setText(value);
                checkBtn.setData((Object)value);
                checkBtn.setLayoutData((Object)gd);
                checkBtn.addListener(13, checkboxListener);
                this.checkboxes.add(checkBtn);
                ++n2;
            }
        }
        this.resultComposite = new Composite(this.remediationComposite, 0);
        this.switchRemediationLayout = new StackLayout();
        this.resultComposite.setLayout((Layout)this.switchRemediationLayout);
        GridData data1 = new GridData(1808);
        this.resultComposite.setLayoutData((Object)data1);
        this.resultErrorComposite = new Composite(this.resultComposite, 0);
        this.resultErrorComposite.setLayout((Layout)new GridLayout());
        this.resultErrorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultNotFoundComposite = new Composite(this.resultComposite, 0);
        this.resultNotFoundComposite.setLayout((Layout)new GridLayout());
        Label resultNotFoundLabel = new Label(this.resultNotFoundComposite, 0);
        resultNotFoundLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        resultNotFoundLabel.setText(ProvUIMessages.RemediationPage_NoSolutionFound);
        this.resultFoundComposite = new Composite(this.resultComposite, 0);
        this.resultFoundComposite.setLayout((Layout)new GridLayout());
        Group insideFoundComposite = new Group(this.resultFoundComposite, 0);
        insideFoundComposite.setText(ProvUIMessages.RemediationPage_SolutionDetails);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        insideFoundComposite.setLayout((Layout)gridLayout);
        insideFoundComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer = new TreeViewer((Composite)insideFoundComposite, 67586);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        data = new GridData(1808);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.getColumn().setText(ProvUIMessages.ProvUI_NameColumnTitle);
        nameColumn.getColumn().setWidth(400);
        nameColumn.getColumn().setMoveable(true);
        nameColumn.getColumn().addSelectionListener(this.columnChangeListener(0));
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RemedyElementCategory) {
                    return ((RemedyElementCategory)element).getName();
                }
                if (element instanceof RemedyIUDetail) {
                    RemedyIUDetail iu = (RemedyIUDetail)element;
                    String label = iu.getIu().getProperty("org.eclipse.equinox.p2.name", null);
                    if (label == null) {
                        label = iu.getIu().getId();
                    }
                    return label;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof RemedyElementCategory) {
                    RemedyElementCategory category = (RemedyElementCategory)element;
                    if (category.getName().equals(ProvUIMessages.RemedyCategoryAdded)) {
                        return ProvUIImages.getImage("obj/iu_add.svg");
                    }
                    if (category.getName().equals(ProvUIMessages.RemedyCategoryChanged)) {
                        return ProvUIImages.getImage("obj/iu_update_obj.svg");
                    }
                    if (category.getName().equals(ProvUIMessages.RemedyCategoryNotAdded)) {
                        return ProvUIImages.getImage("obj/iu_notadd.svg");
                    }
                    if (category.getName().equals(ProvUIMessages.RemedyCategoryRemoved)) {
                        return ProvUIImages.getImage("obj/iu_remove.svg");
                    }
                } else if (element instanceof RemedyIUDetail) {
                    RemedyIUDetail iuDetail = (RemedyIUDetail)element;
                    int status = this.compare(iuDetail);
                    if (this.compare(iuDetail.getBeingInstalledVersion(), iuDetail.getRequestedVersion()) < 0 && RemediationGroup.this.containerPage != null && RemediationGroup.this.containerPage.getWizard() instanceof UpdateWizard) {
                        Image img = ProvUIImages.getImage("obj/iu_upgraded.svg");
                        ImageDescriptor overlay = ProvUIActivator.getDefault().getImageRegistry().getDescriptor("obj/iu_info.svg");
                        String decoratedImageId = "obj/iu_upgraded.svg".concat("obj/iu_info.svg");
                        if (ProvUIActivator.getDefault().getImageRegistry().get(decoratedImageId) == null) {
                            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(img, overlay, 3);
                            ProvUIActivator.getDefault().getImageRegistry().put(decoratedImageId, (ImageDescriptor)decoratedImage);
                        }
                        Image decoratedImg = ProvUIActivator.getDefault().getImageRegistry().get(decoratedImageId);
                        return decoratedImg;
                    }
                    if (status < 0) {
                        return ProvUIImages.getImage("obj/iu_downgraded.svg");
                    }
                    if (status > 0) {
                        return ProvUIImages.getImage("obj/iu_upgraded.svg");
                    }
                    return ProvUIImages.getImage("obj/iu_obj.svg");
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof RemedyIUDetail) {
                    RemedyIUDetail iuDetail = (RemedyIUDetail)element;
                    Object toolTipText = "";
                    ArrayList<CallSite> versions = new ArrayList<CallSite>();
                    if (iuDetail.getInstalledVersion() != null) {
                        versions.add((CallSite)((Object)(ProvUIMessages.RemedyElementInstalledVersion + iuDetail.getInstalledVersion().toString())));
                    }
                    if (iuDetail.getRequestedVersion() != null) {
                        versions.add((CallSite)((Object)(ProvUIMessages.RemedyElementRequestedVersion + iuDetail.getRequestedVersion().toString())));
                    }
                    if (iuDetail.getBeingInstalledVersion() != null) {
                        versions.add((CallSite)((Object)(ProvUIMessages.RemedyElementBeingInstalledVersion + iuDetail.getBeingInstalledVersion().toString())));
                    }
                    for (String string : versions) {
                        toolTipText = (String)toolTipText + (toolTipText == "" ? "" : "\n") + string;
                    }
                    if (RemediationGroup.this.containerPage != null && RemediationGroup.this.containerPage.getWizard() instanceof UpdateWizard && this.compare(iuDetail.getBeingInstalledVersion(), iuDetail.getRequestedVersion()) < 0) {
                        toolTipText = ProvUIMessages.RemedyElementNotHighestVersion + "\n\n" + (String)toolTipText;
                    }
                    return toolTipText;
                }
                return super.getToolTipText(element);
            }

            private int compare(Version versionA, Version versionB) {
                if (versionA != null && versionB != null) {
                    return versionA.compareTo((Object)versionB);
                }
                return 0;
            }

            private int compare(RemedyIUDetail iuDetail) {
                if (iuDetail.getStatus() == 1 && iuDetail.getRequestedVersion() != null && iuDetail.getBeingInstalledVersion() != null) {
                    return this.compare(iuDetail.getBeingInstalledVersion(), iuDetail.getRequestedVersion());
                }
                if (iuDetail.getStatus() == 4 && iuDetail.getInstalledVersion() != null && iuDetail.getBeingInstalledVersion() != null) {
                    return this.compare(iuDetail.getBeingInstalledVersion(), iuDetail.getInstalledVersion());
                }
                return 0;
            }
        });
        TreeViewerColumn versionColumn = new TreeViewerColumn(this.treeViewer, 16384);
        versionColumn.getColumn().setText(ProvUIMessages.ProvUI_VersionColumnTitle);
        versionColumn.getColumn().setWidth(200);
        versionColumn.getColumn().addSelectionListener(this.columnChangeListener(1));
        versionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RemedyIUDetail iu;
                if (element instanceof RemedyIUDetail && (iu = (RemedyIUDetail)element).getBeingInstalledVersion() != null) {
                    return iu.getBeingInstalledVersion().toString();
                }
                return "";
            }
        });
        TreeViewerColumn idColumn = new TreeViewerColumn(this.treeViewer, 16384);
        idColumn.getColumn().setText(ProvUIMessages.ProvUI_IdColumnTitle);
        idColumn.getColumn().setWidth(200);
        idColumn.getColumn().addSelectionListener(this.columnChangeListener(2));
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RemedyIUDetail) {
                    RemedyIUDetail iu = (RemedyIUDetail)element;
                    return iu.getIu().getId();
                }
                return "";
            }
        });
        this.treeComparator = new TreeViewerComparator();
        this.treeViewer.setComparator((ViewerComparator)this.treeComparator);
        this.treeViewer.setContentProvider((IContentProvider)new RemedyContentProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.iuDetailsGroup = new IUDetailsGroup(this.resultErrorComposite, (ISelectionProvider)this.treeViewer, 500, true);
    }

    public IUDetailsGroup getDetailsGroup() {
        return this.iuDetailsGroup;
    }

    private Remedy searchBestDefaultRemedy() {
        if (this.remediationOperation.bestSolutionChangingTheRequest() != null) {
            return this.remediationOperation.bestSolutionChangingTheRequest();
        }
        if (this.remediationOperation.bestSolutionChangingWhatIsInstalled() != null) {
            return this.remediationOperation.bestSolutionChangingWhatIsInstalled();
        }
        return (Remedy)this.remediationOperation.getRemedies().get(0);
    }

    public void update(RemediationOperation operation) {
        Assert.isNotNull((Object)operation, (String)"operation");
        this.remediationOperation = operation;
        this.currentRemedy = this.searchBestDefaultRemedy();
        this.bestBeingInstalledRelaxedButton.setData((Object)this.remediationOperation.bestSolutionChangingTheRequest());
        this.bestInstalledRelaxedButton.setData((Object)this.remediationOperation.bestSolutionChangingWhatIsInstalled());
        this.bestBeingInstalledRelaxedButton.setEnabled(this.remediationOperation.bestSolutionChangingTheRequest() != null);
        this.bestInstalledRelaxedButton.setEnabled(this.remediationOperation.bestSolutionChangingWhatIsInstalled() != null);
        this.bestBeingInstalledRelaxedButton.setSelection(false);
        this.bestInstalledRelaxedButton.setSelection(false);
        this.buildMyOwnSolution.setSelection(false);
        if (this.currentRemedy == this.remediationOperation.bestSolutionChangingTheRequest()) {
            this.bestBeingInstalledRelaxedButton.setSelection(true);
            this.bestBeingInstalledRelaxedButton.notifyListeners(13, new Event());
        } else if (this.currentRemedy == this.remediationOperation.bestSolutionChangingWhatIsInstalled()) {
            this.bestInstalledRelaxedButton.setSelection(true);
            this.bestInstalledRelaxedButton.notifyListeners(13, new Event());
        } else {
            this.buildMyOwnSolution.setData((Object)this.currentRemedy);
            this.buildMyOwnSolution.setSelection(true);
            this.buildMyOwnSolution.notifyListeners(13, new Event());
        }
    }

    private boolean isContraintOK(int btnIndex, boolean value) {
        return this.checkboxes.get(btnIndex).getSelection() && value || !this.checkboxes.get(btnIndex).getSelection() && !value;
    }

    Remedy searchRemedyMatchingUserChoices() {
        if (this.remediationOperation == null) {
            ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, ProvUIActivator.getContext().getBundle().getSymbolicName(), "RemediationOperation was not initialized yet."));
            return null;
        }
        for (Remedy remedy : this.remediationOperation.getRemedies()) {
            if (!this.isContraintOK(0, remedy.getConfig().allowPartialInstall) || !this.isContraintOK(1, remedy.getConfig().allowDifferentVersion) || !this.isContraintOK(2, remedy.getConfig().allowInstalledUpdate) || !this.isContraintOK(3, remedy.getConfig().allowInstalledRemoval) || remedy.getRequest() == null) continue;
            return remedy;
        }
        return null;
    }

    void refreshResultComposite() {
        this.resultComposite.setVisible(true);
        if (!(this.checkboxes.get(0).getSelection() || this.checkboxes.get(1).getSelection() || this.checkboxes.get(2).getSelection() || this.checkboxes.get(3).getSelection())) {
            this.switchRemediationLayout.topControl = this.resultErrorComposite;
        } else if (this.currentRemedy == null) {
            this.switchRemediationLayout.topControl = this.resultNotFoundComposite;
        } else if (this.currentRemedy.getIusDetails().size() == 0) {
            this.switchRemediationLayout.topControl = this.resultNotFoundComposite;
        } else {
            this.treeViewer.setInput((Object)this.currentRemedy);
            this.switchRemediationLayout.topControl = this.resultFoundComposite;
        }
        this.resultComposite.layout();
        this.containerPage.setPageComplete(this.currentRemedy != null);
    }

    public Remedy getCurrentRemedy() {
        return this.currentRemedy;
    }

    public String getMessage() {
        return ProvUIMessages.InstallRemediationPage_Description;
    }

    private SelectionListener columnChangeListener(int index) {
        return SelectionListener.widgetSelectedAdapter(e -> this.updateTableSorting(index));
    }

    private void updateTableSorting(int columnIndex) {
        TreeViewerComparator comparator = (TreeViewerComparator)this.treeViewer.getComparator();
        if (columnIndex == this.treeComparator.getSortColumn()) {
            comparator.setAscending(!this.treeComparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.treeViewer.getTree().setSortColumn(this.treeViewer.getTree().getColumn(columnIndex));
        this.treeViewer.getTree().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.treeViewer.refresh(false);
        this.treeViewer.expandToLevel(2);
    }

    public class RemedyContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = ElementUtils.requestToRemedyElementsCategories((Remedy)inputElement);
            return elements;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RemedyElementCategory) {
                RemedyElementCategory category = (RemedyElementCategory)parentElement;
                return category.getElements().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof RemedyElementCategory;
        }
    }

    class TreeViewerComparator
    extends ViewerComparator {
        private int sortColumn = 0;
        private int ascending = 1;

        TreeViewerComparator() {
        }

        public int compare(Viewer viewer1, Object e1, Object e2) {
            if (!(e1 instanceof RemedyIUDetail) || !(e2 instanceof RemedyIUDetail)) {
                return 0;
            }
            IInstallableUnit iu1 = ((RemedyIUDetail)e1).getIu();
            IInstallableUnit iu2 = ((RemedyIUDetail)e2).getIu();
            if (iu1 != null && iu2 != null) {
                if (viewer1 instanceof TreeViewer) {
                    TreeViewer theTreeViewer = (TreeViewer)viewer1;
                    ColumnLabelProvider labelProvider = (ColumnLabelProvider)theTreeViewer.getLabelProvider(this.sortColumn);
                    String e1p = labelProvider.getText(e1);
                    String e2p = labelProvider.getText(e2);
                    return this.ascending * this.getComparator().compare(e1p, e2p);
                }
                return 0;
            }
            return super.compare(viewer1, e1, e2);
        }

        public void setSortColumn(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public boolean isAscending() {
            return this.ascending == 1;
        }

        public void setAscending(boolean asc) {
            this.ascending = asc ? 1 : -1;
        }
    }
}

