/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.openpgp.OpenedPGPKeyData;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.util.Strings;

public class PGPSecretKeyParser {
    public static boolean isExtendedSExpression(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("input stream must support mark");
        }
        inputStream.mark(1);
        int n = inputStream.read();
        inputStream.reset();
        return n != 40;
    }

    private static int lastIndexOfWhitespace(String string) {
        if (string.length() == 0) {
            return -1;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c > ' ') continue;
            return i;
        }
        return -1;
    }

    private static void consumeUntil(InputStream inputStream, char c, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    public static OpenedPGPKeyData parse(InputStream inputStream, int n) throws IOException {
        OpenedPGPKeyData.Builder builder = OpenedPGPKeyData.builder();
        if (PGPSecretKeyParser.isExtendedSExpression(inputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = null;
            do {
                PGPSecretKeyParser.consumeUntil(inputStream, ':', byteArrayOutputStream);
                String string2 = Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray()).trim();
                int n2 = PGPSecretKeyParser.lastIndexOfWhitespace(string2);
                if (n2 == -1) {
                    string = string2;
                    continue;
                }
                builder.add(new PGPExtendedKeyHeader(string, string2.substring(0, n2)));
                string = string2.substring(n2).trim();
            } while (!string.equalsIgnoreCase("Key"));
        }
        builder.setKeyExpression(SExpression.parse(inputStream, n));
        return builder.build();
    }
}

